/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;

public abstract class ToggleCommand
implements TabExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (args.length) {
            case 0: {
                if (CommandUtils.noConsoleUsage(sender)) {
                    return true;
                }
                if (!this.hasSelfPermission(sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                this.applyCommandAction(UserManager.getPlayer(sender.getName()));
                return true;
            }
            case 1: {
                McMMOPlayer mcMMOPlayer;
                if (!this.hasOtherPermission(sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                String playerName = CommandUtils.getMatchedPlayerName(args[0]);
                if (!CommandUtils.checkPlayerExistence(sender, playerName, mcMMOPlayer = UserManager.getPlayer(playerName))) {
                    return true;
                }
                if (CommandUtils.isOffline(sender, (OfflinePlayer)mcMMOPlayer.getPlayer())) {
                    return true;
                }
                this.applyCommandAction(mcMMOPlayer);
                this.sendSuccessMessage(sender, playerName);
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        switch (args.length) {
            case 1: {
                List<String> playerNames = CommandUtils.getOnlinePlayerNames(sender);
                return (List)StringUtil.copyPartialMatches((String)args[0], playerNames, new ArrayList(playerNames.size()));
            }
        }
        return ImmutableList.of();
    }

    protected abstract boolean hasOtherPermission(CommandSender var1);

    protected abstract boolean hasSelfPermission(CommandSender var1);

    protected abstract void applyCommandAction(McMMOPlayer var1);

    protected abstract void sendSuccessMessage(CommandSender var1, String var2);
}

