/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;

public class XprateCommand
implements TabExecutor {
    private final double ORIGINAL_XP_RATE = ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (args.length) {
            case 1: {
                if (!args[0].equalsIgnoreCase("reset")) {
                    return false;
                }
                if (!Permissions.xprateReset((Permissible)sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (mcMMO.p.isXPEventEnabled()) {
                    mcMMO.p.getServer().broadcastMessage(LocaleLoader.getString("Commands.xprate.over"));
                    mcMMO.p.toggleXpEventEnabled();
                }
                ExperienceConfig.getInstance().setExperienceGainsGlobalMultiplier(this.ORIGINAL_XP_RATE);
                return true;
            }
            case 2: {
                if (CommandUtils.isInvalidInteger(sender, args[0])) {
                    return true;
                }
                if (!Permissions.xprateSet((Permissible)sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (CommandUtils.shouldDisableToggle(args[1])) {
                    mcMMO.p.setXPEventEnabled(false);
                } else if (CommandUtils.shouldEnableToggle(args[1])) {
                    mcMMO.p.setXPEventEnabled(true);
                } else {
                    return false;
                }
                int newXpRate = Integer.parseInt(args[0]);
                ExperienceConfig.getInstance().setExperienceGainsGlobalMultiplier(newXpRate);
                if (mcMMO.p.isXPEventEnabled()) {
                    mcMMO.p.getServer().broadcastMessage(LocaleLoader.getString("Commands.xprate.started.0"));
                    mcMMO.p.getServer().broadcastMessage(LocaleLoader.getString("Commands.xprate.started.1", newXpRate));
                } else {
                    sender.sendMessage(LocaleLoader.getString("Commands.xprate.modified", newXpRate));
                }
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        switch (args.length) {
            case 1: {
                if (StringUtils.isInt(args[0])) {
                    return ImmutableList.of();
                }
                return (List)StringUtil.copyPartialMatches((String)args[0], CommandUtils.RESET_OPTIONS, new ArrayList(CommandUtils.RESET_OPTIONS.size()));
            }
            case 2: {
                return (List)StringUtil.copyPartialMatches((String)args[1], CommandUtils.TRUE_FALSE_OPTIONS, new ArrayList(CommandUtils.TRUE_FALSE_OPTIONS.size()));
            }
        }
        return ImmutableList.of();
    }
}

