/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.chat;

import com.gmail.nossr50.chat.PartyChatManager;
import com.gmail.nossr50.commands.chat.ChatCommand;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.chat.ChatMode;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyFeature;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyChatCommand
extends ChatCommand {
    public PartyChatCommand() {
        super(ChatMode.PARTY);
    }

    @Override
    protected void handleChatSending(CommandSender sender, String[] args) {
        String message;
        Party party;
        if (sender instanceof Player) {
            party = UserManager.getPlayer((Player)sender).getParty();
            if (party == null) {
                sender.sendMessage(LocaleLoader.getString("Commands.Party.None"));
                return;
            }
            if (party.getLevel() < Config.getInstance().getPartyFeatureUnlockLevel(PartyFeature.CHAT)) {
                sender.sendMessage(LocaleLoader.getString("Party.Feature.Disabled.1"));
                return;
            }
            message = this.buildChatMessage(args, 0);
        } else {
            if (args.length < 2) {
                sender.sendMessage(LocaleLoader.getString("Party.Specify"));
                return;
            }
            party = PartyManager.getParty(args[0]);
            if (party == null) {
                sender.sendMessage(LocaleLoader.getString("Party.InvalidName"));
                return;
            }
            message = this.buildChatMessage(args, 1);
        }
        ((PartyChatManager)this.chatManager).setParty(party);
        this.chatManager.handleChat(sender.getName(), this.getDisplayName(sender), message);
    }
}

