/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.hardcore;

import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.google.common.collect.ImmutableList;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;

public abstract class HardcoreModeCommand
implements TabExecutor {
    protected final DecimalFormat percent = new DecimalFormat("##0.00%");

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (args.length) {
            case 0: {
                if (!this.checkTogglePermissions(sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (this.checkEnabled(null)) {
                    this.disable(null);
                } else {
                    this.enable(null);
                }
                return true;
            }
            case 1: {
                if (CommandUtils.shouldEnableToggle(args[0])) {
                    if (!Permissions.hardcoreToggle((Permissible)sender)) {
                        sender.sendMessage(command.getPermissionMessage());
                        return true;
                    }
                    this.enable(null);
                    return true;
                }
                if (CommandUtils.shouldDisableToggle(args[0])) {
                    if (!Permissions.hardcoreToggle((Permissible)sender)) {
                        sender.sendMessage(command.getPermissionMessage());
                        return true;
                    }
                    this.disable(null);
                    return true;
                }
                if (CommandUtils.isInvalidDouble(sender, args[0])) {
                    return true;
                }
                if (!Permissions.hardcoreModify((Permissible)sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                this.modify(sender, Double.parseDouble(args[0]));
                return true;
            }
            case 2: {
                if (CommandUtils.isInvalidSkill(sender, args[0])) {
                    return true;
                }
                SkillType skill = SkillType.getSkill(args[0]);
                if (!CommandUtils.isChildSkill(sender, skill)) {
                    return true;
                }
                if (CommandUtils.shouldEnableToggle(args[1])) {
                    if (!Permissions.hardcoreToggle((Permissible)sender)) {
                        sender.sendMessage(command.getPermissionMessage());
                        return true;
                    }
                    this.enable(skill);
                    return true;
                }
                if (CommandUtils.shouldDisableToggle(args[1])) {
                    if (!Permissions.hardcoreToggle((Permissible)sender)) {
                        sender.sendMessage(command.getPermissionMessage());
                        return true;
                    }
                    this.enable(skill);
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        switch (args.length) {
            case 1: {
                if (StringUtils.isDouble(args[0])) {
                    return ImmutableList.of();
                }
                return (List)StringUtil.copyPartialMatches((String)args[0], CommandUtils.TRUE_FALSE_OPTIONS, new ArrayList(CommandUtils.TRUE_FALSE_OPTIONS.size()));
            }
        }
        return ImmutableList.of();
    }

    protected abstract boolean checkTogglePermissions(CommandSender var1);

    protected abstract boolean checkModifyPermissions(CommandSender var1);

    protected abstract boolean checkEnabled(SkillType var1);

    protected abstract void enable(SkillType var1);

    protected abstract void disable(SkillType var1);

    protected abstract void modify(CommandSender var1, double var2);
}

