/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.repair.ArcaneForging;
import com.gmail.nossr50.skills.repair.Repair;
import com.gmail.nossr50.skills.repair.RepairManager;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class RepairCommand
extends SkillCommand {
    private String repairMasteryBonus;
    private String superRepairChance;
    private String superRepairChanceLucky;
    private boolean canSuperRepair;
    private boolean canMasterRepair;
    private boolean canArcaneForge;
    private boolean canSalvage;
    private boolean canRepairStone;
    private boolean canRepairIron;
    private boolean canRepairGold;
    private boolean canRepairDiamond;
    private boolean canRepairString;
    private boolean canRepairLeather;
    private boolean canRepairWood;
    private boolean arcaneBypass;
    private int diamondLevel;
    private int goldLevel;
    private int ironLevel;
    private int stoneLevel;

    public RepairCommand() {
        super(SkillType.REPAIR);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue, boolean isLucky) {
        Repairable diamondRepairable = mcMMO.getRepairableManager().getRepairable(Material.DIAMOND_PICKAXE);
        Repairable goldRepairable = mcMMO.getRepairableManager().getRepairable(Material.GOLD_PICKAXE);
        Repairable ironRepairable = mcMMO.getRepairableManager().getRepairable(Material.IRON_PICKAXE);
        Repairable stoneRepairable = mcMMO.getRepairableManager().getRepairable(Material.STONE_PICKAXE);
        this.diamondLevel = diamondRepairable == null ? 0 : diamondRepairable.getMinimumLevel();
        this.goldLevel = goldRepairable == null ? 0 : goldRepairable.getMinimumLevel();
        this.ironLevel = ironRepairable == null ? 0 : ironRepairable.getMinimumLevel();
        int n = this.stoneLevel = stoneRepairable == null ? 0 : stoneRepairable.getMinimumLevel();
        if (this.canMasterRepair) {
            this.repairMasteryBonus = this.percent.format(Math.min(Repair.repairMasteryMaxBonus / (double)Repair.repairMasteryMaxBonusLevel * (double)skillValue, Repair.repairMasteryMaxBonus) / 100.0);
        }
        if (this.canSuperRepair) {
            String[] superRepairStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.SUPER_REPAIR, isLucky);
            this.superRepairChance = superRepairStrings[0];
            this.superRepairChanceLucky = superRepairStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canSuperRepair = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.SUPER_REPAIR);
        this.canMasterRepair = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.REPAIR_MASTERY);
        this.canArcaneForge = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.ARCANE_FORGING);
        this.canSalvage = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.SALVAGE);
        this.canRepairDiamond = Permissions.repairDiamond((Permissible)player);
        this.canRepairGold = Permissions.repairGold((Permissible)player);
        this.canRepairIron = Permissions.repairIron((Permissible)player);
        this.canRepairStone = Permissions.repairStone((Permissible)player);
        this.canRepairString = Permissions.repairString((Permissible)player);
        this.canRepairLeather = Permissions.repairLeather((Permissible)player);
        this.canRepairWood = Permissions.repairWood((Permissible)player);
        this.arcaneBypass = Permissions.arcaneBypass((Permissible)player);
    }

    @Override
    protected List<String> effectsDisplay() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canRepairLeather || this.canRepairString || this.canRepairWood || this.canRepairStone || this.canRepairIron || this.canRepairGold || this.canRepairDiamond) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Repair.Effect.0"), LocaleLoader.getString("Repair.Effect.1")));
        }
        if (this.canMasterRepair) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Repair.Effect.2"), LocaleLoader.getString("Repair.Effect.3")));
        }
        if (this.canSuperRepair) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Repair.Effect.4"), LocaleLoader.getString("Repair.Effect.5")));
        }
        if (this.canRepairStone && this.stoneLevel > 0) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Repair.Effect.14", this.stoneLevel), LocaleLoader.getString("Repair.Effect.15")));
        }
        if (this.canRepairIron && this.ironLevel > 0) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Repair.Effect.12", this.ironLevel), LocaleLoader.getString("Repair.Effect.13")));
        }
        if (this.canRepairGold && this.goldLevel > 0) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Repair.Effect.10", this.goldLevel), LocaleLoader.getString("Repair.Effect.11")));
        }
        if (this.canRepairDiamond && this.diamondLevel > 0) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Repair.Effect.6", this.diamondLevel), LocaleLoader.getString("Repair.Effect.7")));
        }
        if (this.canSalvage && Repair.salvageUnlockLevel > 0) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Repair.Effect.16", Repair.salvageUnlockLevel), LocaleLoader.getString("Repair.Effect.17")));
        }
        if (this.canArcaneForge) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Repair.Effect.8"), LocaleLoader.getString("Repair.Effect.9")));
        }
        return messages;
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canMasterRepair) {
            messages.add(LocaleLoader.getString("Repair.Skills.Mastery", this.repairMasteryBonus));
        }
        if (this.canSuperRepair) {
            messages.add(LocaleLoader.getString("Repair.Skills.Super.Chance", this.superRepairChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.superRepairChanceLucky) : ""));
        }
        if (this.canArcaneForge) {
            RepairManager repairManager = UserManager.getPlayer(player).getRepairManager();
            messages.add(LocaleLoader.getString("Repair.Arcane.Rank", repairManager.getArcaneForgingRank(), ArcaneForging.Tier.values().length));
            if (ArcaneForging.arcaneForgingEnchantLoss) {
                messages.add(LocaleLoader.getString("Repair.Arcane.Chance.Success", this.arcaneBypass ? 100.0 : repairManager.getKeepEnchantChance()));
            }
            if (ArcaneForging.arcaneForgingDowngrades) {
                messages.add(LocaleLoader.getString("Repair.Arcane.Chance.Downgrade", this.arcaneBypass ? 0.0 : repairManager.getDowngradeEnchantChance()));
            }
        }
        return messages;
    }
}

