/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.taming.Taming;
import com.gmail.nossr50.util.Permissions;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class TamingCommand
extends SkillCommand {
    private String goreChance;
    private String goreChanceLucky;
    private boolean canBeastLore;
    private boolean canGore;
    private boolean canSharpenedClaws;
    private boolean canEnvironmentallyAware;
    private boolean canThickFur;
    private boolean canShockProof;
    private boolean canCallWild;
    private boolean canFastFood;
    private boolean canHolyHound;

    public TamingCommand() {
        super(SkillType.TAMING);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue, boolean isLucky) {
        if (this.canGore) {
            String[] goreStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.GORE, isLucky);
            this.goreChance = goreStrings[0];
            this.goreChanceLucky = goreStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canBeastLore = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.BEAST_LORE);
        this.canCallWild = Permissions.callOfTheWild((Permissible)player, EntityType.HORSE) || Permissions.callOfTheWild((Permissible)player, EntityType.WOLF) || Permissions.callOfTheWild((Permissible)player, EntityType.OCELOT);
        this.canEnvironmentallyAware = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.ENVIROMENTALLY_AWARE);
        this.canFastFood = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.FAST_FOOD);
        this.canGore = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.GORE);
        this.canSharpenedClaws = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.SHARPENED_CLAWS);
        this.canShockProof = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.SHOCK_PROOF);
        this.canThickFur = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.THICK_FUR);
        this.canHolyHound = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.HOLY_HOUND);
    }

    @Override
    protected List<String> effectsDisplay() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canBeastLore) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Taming.Effect.0"), LocaleLoader.getString("Taming.Effect.1")));
        }
        if (this.canGore) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Taming.Effect.2"), LocaleLoader.getString("Taming.Effect.3")));
        }
        if (this.canSharpenedClaws) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Taming.Effect.4"), LocaleLoader.getString("Taming.Effect.5")));
        }
        if (this.canEnvironmentallyAware) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Taming.Effect.6"), LocaleLoader.getString("Taming.Effect.7")));
        }
        if (this.canThickFur) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Taming.Effect.8"), LocaleLoader.getString("Taming.Effect.9")));
        }
        if (this.canShockProof) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Taming.Effect.10"), LocaleLoader.getString("Taming.Effect.11")));
        }
        if (this.canFastFood) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Taming.Effect.16"), LocaleLoader.getString("Taming.Effect.17")));
        }
        if (this.canHolyHound) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Taming.Effect.18"), LocaleLoader.getString("Taming.Effect.19")));
        }
        if (this.canCallWild) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Taming.Effect.12"), LocaleLoader.getString("Taming.Effect.13")));
            messages.add(LocaleLoader.getString("Taming.Effect.14", Config.getInstance().getTamingCOTWCost(EntityType.OCELOT)));
            messages.add(LocaleLoader.getString("Taming.Effect.15", Config.getInstance().getTamingCOTWCost(EntityType.WOLF)));
            messages.add(LocaleLoader.getString("Taming.Effect.20", Config.getInstance().getTamingCOTWCost(EntityType.HORSE)));
        }
        return messages;
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canFastFood) {
            if (skillValue < (float)Taming.fastFoodServiceUnlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Taming.Ability.Locked.4", Taming.fastFoodServiceUnlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Taming.Ability.Bonus.8"), LocaleLoader.getString("Taming.Ability.Bonus.9", this.percent.format(Taming.fastFoodServiceActivationChance / 100.0))));
            }
        }
        if (this.canEnvironmentallyAware) {
            if (skillValue < (float)Taming.environmentallyAwareUnlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Taming.Ability.Locked.0", Taming.environmentallyAwareUnlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Taming.Ability.Bonus.0"), LocaleLoader.getString("Taming.Ability.Bonus.1")));
            }
        }
        if (this.canThickFur) {
            if (skillValue < (float)Taming.thickFurUnlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Taming.Ability.Locked.1", Taming.thickFurUnlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Taming.Ability.Bonus.2"), LocaleLoader.getString("Taming.Ability.Bonus.3", Taming.thickFurModifier)));
            }
        }
        if (this.canHolyHound) {
            if (skillValue < (float)Taming.holyHoundUnlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Taming.Ability.Locked.5", Taming.holyHoundUnlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Taming.Ability.Bonus.10"), LocaleLoader.getString("Taming.Ability.Bonus.11")));
            }
        }
        if (this.canShockProof) {
            if (skillValue < (float)Taming.shockProofUnlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Taming.Ability.Locked.2", Taming.shockProofUnlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Taming.Ability.Bonus.4"), LocaleLoader.getString("Taming.Ability.Bonus.5", Taming.shockProofModifier)));
            }
        }
        if (this.canSharpenedClaws) {
            if (skillValue < (float)Taming.sharpenedClawsUnlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Taming.Ability.Locked.3", Taming.sharpenedClawsUnlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Taming.Ability.Bonus.6"), LocaleLoader.getString("Taming.Ability.Bonus.7", Taming.sharpenedClawsBonusDamage)));
            }
        }
        if (this.canGore) {
            messages.add(LocaleLoader.getString("Taming.Combat.Chance.Gore", this.goreChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.goreChanceLucky) : ""));
        }
        return messages;
    }
}

