/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.config.AutoUpdateConfigLoader;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.skills.alchemy.Alchemy;
import com.gmail.nossr50.skills.fishing.Fishing;
import com.gmail.nossr50.skills.mining.BlastMining;
import com.gmail.nossr50.skills.repair.ArcaneForging;
import com.gmail.nossr50.skills.smelting.Smelting;
import com.gmail.nossr50.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AdvancedConfig
extends AutoUpdateConfigLoader {
    private static AdvancedConfig instance;

    private AdvancedConfig() {
        super("advanced.yml");
        this.validate();
    }

    public static AdvancedConfig getInstance() {
        if (instance == null) {
            instance = new AdvancedConfig();
        }
        return instance;
    }

    @Override
    protected boolean validateKeys() {
        ArrayList<String> reason = new ArrayList<String>();
        if (this.getAbilityLength() < 1) {
            reason.add("Skills.General.Ability.IncreaseLevel should be at least 1!");
        }
        if (this.getEnchantBuff() < 1) {
            reason.add("Skills.General.Ability.EnchantBuff should be at least 1!");
        }
        if (this.getMaxChance(SecondaryAbility.DODGE) < 1.0) {
            reason.add("Skills.Acrobatics.Dodge.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.DODGE) < 1) {
            reason.add("Skills.Acrobatics.Dodge.MaxBonusLevel should be at least 1!");
        }
        if (this.getDodgeDamageModifier() <= 1.0) {
            reason.add("Skills.Acrobatics.Dodge.DamageModifier should be greater than 1!");
        }
        if (this.getMaxChance(SecondaryAbility.ROLL) < 1.0) {
            reason.add("Skills.Acrobatics.Roll.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.ROLL) < 1) {
            reason.add("Skills.Acrobatics.Roll.MaxBonusLevel should be at least 1!");
        }
        if (this.getRollDamageThreshold() < 0.0) {
            reason.add("Skills.Acrobatics.Roll.DamageThreshold should be at least 0!");
        }
        if (this.getMaxChance(SecondaryAbility.GRACEFUL_ROLL) < 1.0) {
            reason.add("Skills.Acrobatics.GracefulRoll.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.GRACEFUL_ROLL) < 1) {
            reason.add("Skills.Acrobatics.GracefulRoll.MaxBonusLevel should be at least 1!");
        }
        if (this.getGracefulRollDamageThreshold() < 0.0) {
            reason.add("Skills.Acrobatics.GracefulRoll.DamageThreshold should be at least 0!");
        }
        if (this.getCatalysisUnlockLevel() < 0) {
            reason.add("Skills.Alchemy.Catalysis.UnlockLevel should be at least 0!");
        }
        if (this.getCatalysisMaxBonusLevel() <= this.getCatalysisUnlockLevel()) {
            reason.add("Skills.Alchemy.Catalysis.MaxBonusLevel should be greater than Skills.Alchemy.Catalysis.UnlockLevel!");
        }
        if (this.getCatalysisMinSpeed() <= 0.0) {
            reason.add("Skills.Alchemy.Catalysis.MinSpeed must be greater than 0!");
        }
        if (this.getCatalysisMaxSpeed() < this.getCatalysisMinSpeed()) {
            reason.add("Skills.Alchemy.Catalysis.MaxSpeed should be at least Skills.Alchemy.Catalysis.MinSpeed!");
        }
        List<Alchemy.Tier> alchemyTierList = Arrays.asList(Alchemy.Tier.values());
        for (Alchemy.Tier tier : alchemyTierList) {
            if (this.getConcoctionsTierLevel(tier) < 0) {
                reason.add("Skills.Alchemy.Rank_Levels.Rank_" + tier.toNumerical() + " should be at least 0!");
            }
            if (tier == Alchemy.Tier.fromNumerical(Alchemy.Tier.values().length)) continue;
            Alchemy.Tier nextTier = alchemyTierList.get(alchemyTierList.indexOf((Object)tier) - 1);
            if (this.getConcoctionsTierLevel(tier) <= this.getConcoctionsTierLevel(nextTier)) continue;
            reason.add("Skills.Alchemy.Rank_Levels.Rank_" + tier.toNumerical() + " should be less than or equal to Skills.Alchemy.Rank_Levels.Rank_" + nextTier.toNumerical() + "!");
        }
        if (this.getSkillShotIncreaseLevel() < 1) {
            reason.add("Skills.Archery.SkillShot.IncreaseLevel should be at least 1!");
        }
        if (this.getSkillShotIncreasePercentage() <= 0.0) {
            reason.add("Skills.Archery.SkillShot.IncreasePercentage should be greater than 0!");
        }
        if (this.getSkillShotBonusMax() < 0.0) {
            reason.add("Skills.Archery.SkillShot.MaxBonus should be at least 0!");
        }
        if (this.getMaxChance(SecondaryAbility.DAZE) < 1.0) {
            reason.add("Skills.Acrobatics.Daze.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.DAZE) < 1) {
            reason.add("Skills.Acrobatics.Daze.MaxBonusLevel should be at least 1!");
        }
        if (this.getDazeModifier() < 0.0) {
            reason.add("Skills.Acrobatics.Daze.BonusDamage should be at least 0!");
        }
        if (this.getMaxChance(SecondaryAbility.RETRIEVE) < 1.0) {
            reason.add("Skills.Acrobatics.Retrieve.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.RETRIEVE) < 1) {
            reason.add("Skills.Acrobatics.Retrieve.MaxBonusLevel should be at least 1!");
        }
        if (this.getForceMultiplier() < 0.0) {
            reason.add("Skills.Acrobatics.ForceMultiplier should be at least 0!");
        }
        if (this.getAxeMasteryBonusMax() < 1.0) {
            reason.add("Skills.Axes.AxeMastery.MaxBonus should be at least 1!");
        }
        if (this.getAxeMasteryMaxBonusLevel() < 1) {
            reason.add("Skills.Axes.AxeMastery.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaxChance(SecondaryAbility.CRITICAL_HIT) < 1.0) {
            reason.add("Skills.Axes.CriticalHit.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.CRITICAL_HIT) < 1) {
            reason.add("Skills.Axes.CriticalHit.MaxBonusLevel should be at least 1!");
        }
        if (this.getCriticalHitPVPModifier() < 1.0) {
            reason.add("Skills.Axes.CriticalHit.PVP_Modifier should be at least 1!");
        }
        if (this.getCriticalHitPVEModifier() < 1.0) {
            reason.add("Skills.Axes.CriticalHit.PVE_Modifier should be at least 1!");
        }
        if (this.getGreaterImpactChance() < 1.0) {
            reason.add("Skills.Axes.GreaterImpact.Chance should be at least 1!");
        }
        if (this.getGreaterImpactModifier() < 1.0) {
            reason.add("Skills.Axes.GreaterImpact.KnockbackModifier should be at least 1!");
        }
        if (this.getGreaterImpactBonusDamage() < 1.0) {
            reason.add("Skills.Axes.GreaterImpact.BonusDamage should be at least 1!");
        }
        if (this.getArmorImpactIncreaseLevel() < 1) {
            reason.add("Skills.Axes.ArmorImpact.IncreaseLevel should be at least 1!");
        }
        if (this.getImpactChance() < 1.0) {
            reason.add("Skills.Axes.ArmorImpact.Chance should be at least 1!");
        }
        if (this.getArmorImpactMaxDurabilityDamage() < 1.0) {
            reason.add("Skills.Axes.ArmorImpact.MaxPercentageDurabilityDamage should be at least 1!");
        }
        if (this.getSkullSplitterModifier() < 1.0) {
            reason.add("Skills.Axes.SkullSplitter.DamagerModifier should be at least 1!");
        }
        List<Fishing.Tier> fishingTierList = Arrays.asList(Fishing.Tier.values());
        for (Fishing.Tier tier : fishingTierList) {
            if (this.getFishingTierLevel(tier) < 0) {
                reason.add("Skills.Fishing.Rank_Levels.Rank_" + tier.toNumerical() + " should be at least 0!");
            }
            if (this.getShakeChance(tier) < 0.0) {
                reason.add("Skills.Fishing.Shake_Chance.Rank_" + tier.toNumerical() + " should be at least 0!");
            }
            if (this.getFishingVanillaXPModifier(tier) < 0) {
                reason.add("Skills.Fishing.VanillaXPMultiplier.Rank_" + tier.toNumerical() + " should be at least 0!");
            }
            if (tier == Fishing.Tier.EIGHT) continue;
            Fishing.Tier nextTier = fishingTierList.get(fishingTierList.indexOf((Object)tier) - 1);
            if (this.getFishingTierLevel(tier) > this.getFishingTierLevel(nextTier)) {
                reason.add("Skills.Fishing.Rank_Levels.Rank_" + tier.toNumerical() + " should be less than or equal to Skills.Fishing.Rank_Levels.Rank_" + nextTier.toNumerical() + "!");
            }
            if (this.getShakeChance(tier) > this.getShakeChance(nextTier)) {
                reason.add("Skills.Fishing.Shake_Chance.Rank_" + tier.toNumerical() + " should be less than or equal to Skills.Fishing.Shake_Chance.Rank_" + nextTier.toNumerical() + "!");
            }
            if (this.getFishingVanillaXPModifier(tier) <= this.getFishingVanillaXPModifier(nextTier)) continue;
            reason.add("Skills.Fishing.VanillaXPMultiplier.Rank_" + tier.toNumerical() + " should be less than or equal to Skills.Fishing.VanillaXPMultiplier.Rank_" + nextTier.toNumerical() + "!");
        }
        if (this.getFishermanDietRankChange() < 1) {
            reason.add("Skills.Fishing.FishermansDiet.RankChange should be at least 1!");
        }
        if (this.getIceFishingUnlockLevel() < 0) {
            reason.add("Skills.Fishing.IceFishing.UnlockLevel should be at least 0!");
        }
        if (this.getMasterAnglerUnlockLevel() < 0) {
            reason.add("Skills.Fishing.MasterAngler.UnlockLevel should be at least 0!");
        }
        if (this.getMasterAnglerBoatModifier() < 1.0) {
            reason.add("Skills.Fishing.MasterAngler.BoatModifier should be at least 1!");
        }
        if (this.getMasterAnglerBiomeModifier() < 1.0) {
            reason.add("Skills.Fishing.MasterAngler.BiomeModifier should be at least 1!");
        }
        if (this.getFarmerDietRankChange() < 1) {
            reason.add("Skills.Herbalism.FarmersDiet.RankChange should be at least 1!");
        }
        if (this.getGreenThumbStageChange() < 1) {
            reason.add("Skills.Herbalism.GreenThumb.StageChange should be at least 1!");
        }
        if (this.getMaxChance(SecondaryAbility.GREEN_THUMB_PLANT) < 1.0) {
            reason.add("Skills.Herbalism.GreenThumb.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.GREEN_THUMB_PLANT) < 1) {
            reason.add("Skills.Herbalism.GreenThumb.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaxChance(SecondaryAbility.HERBALISM_DOUBLE_DROPS) < 1.0) {
            reason.add("Skills.Herbalism.DoubleDrops.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.HERBALISM_DOUBLE_DROPS) < 1) {
            reason.add("Skills.Herbalism.DoubleDrops.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaxChance(SecondaryAbility.HYLIAN_LUCK) < 1.0) {
            reason.add("Skills.Herbalism.HylianLuck.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.HYLIAN_LUCK) < 1) {
            reason.add("Skills.Herbalism.HylianLuck.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaxChance(SecondaryAbility.SHROOM_THUMB) < 1.0) {
            reason.add("Skills.Herbalism.ShroomThumb.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.SHROOM_THUMB) < 1) {
            reason.add("Skills.Herbalism.ShroomThumb.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaxChance(SecondaryAbility.MINING_DOUBLE_DROPS) < 1.0) {
            reason.add("Skills.Mining.DoubleDrops.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.MINING_DOUBLE_DROPS) < 1) {
            reason.add("Skills.Mining.DoubleDrops.MaxBonusLevel should be at least 1!");
        }
        List<BlastMining.Tier> blastMiningTierList = Arrays.asList(BlastMining.Tier.values());
        for (BlastMining.Tier tier : blastMiningTierList) {
            if (this.getBlastMiningRankLevel(tier) < 0) {
                reason.add("Skills.Mining.BlastMining.Rank_Levels.Rank_" + tier.toNumerical() + " should be at least 0!");
            }
            if (this.getBlastDamageDecrease(tier) < 0.0) {
                reason.add("Skills.Mining.BlastMining.BlastDamageDecrease.Rank_" + tier.toNumerical() + " should be at least 0!");
            }
            if (this.getOreBonus(tier) < 0.0) {
                reason.add("Skills.Mining.BlastMining.OreBonus.Rank_" + tier.toNumerical() + " should be at least 0!");
            }
            if (this.getDebrisReduction(tier) < 0.0) {
                reason.add("Skills.Mining.BlastMining.DebrisReduction.Rank_" + tier.toNumerical() + " should be at least 0!");
            }
            if (this.getDropMultiplier(tier) < 0) {
                reason.add("Skills.Mining.BlastMining.DropMultiplier.Rank_" + tier.toNumerical() + " should be at least 0!");
            }
            if (this.getBlastRadiusModifier(tier) < 0.0) {
                reason.add("Skills.Mining.BlastMining.BlastRadiusModifier.Rank_" + tier.toNumerical() + " should be at least 0!");
            }
            if (tier == BlastMining.Tier.EIGHT) continue;
            BlastMining.Tier nextTier = blastMiningTierList.get(blastMiningTierList.indexOf((Object)tier) - 1);
            if (this.getBlastMiningRankLevel(tier) > this.getBlastMiningRankLevel(nextTier)) {
                reason.add("Skills.Mining.BlastMining.Rank_Levels.Rank_" + tier.toNumerical() + " should be less than or equal to Skills.Mining.BlastMining.Rank_Levels.Rank_" + nextTier.toNumerical() + "!");
            }
            if (this.getBlastDamageDecrease(tier) > this.getBlastDamageDecrease(nextTier)) {
                reason.add("Skills.Mining.BlastMining.BlastDamageDecrease.Rank_" + tier.toNumerical() + " should be less than or equal to Skills.Mining.BlastMining.BlastDamageDecrease.Rank_" + nextTier.toNumerical() + "!");
            }
            if (this.getOreBonus(tier) > this.getOreBonus(nextTier)) {
                reason.add("Skills.Mining.BlastMining.OreBonus.Rank_" + tier.toNumerical() + " should be less than or equal to Skills.Mining.BlastMining.OreBonus.Rank_" + nextTier.toNumerical() + "!");
            }
            if (this.getDebrisReduction(tier) > this.getDebrisReduction(nextTier)) {
                reason.add("Skills.Mining.BlastMining.DebrisReduction.Rank_" + tier.toNumerical() + " should be less than or equal to Skills.Mining.BlastMining.DebrisReduction.Rank_" + nextTier.toNumerical() + "!");
            }
            if (this.getDropMultiplier(tier) > this.getDropMultiplier(nextTier)) {
                reason.add("Skills.Mining.BlastMining.DropMultiplier.Rank_" + tier.toNumerical() + " should be less than or equal to Skills.Mining.BlastMining.DropMultiplier.Rank_" + nextTier.toNumerical() + "!");
            }
            if (!(this.getBlastRadiusModifier(tier) > this.getBlastRadiusModifier(nextTier))) continue;
            reason.add("Skills.Mining.BlastMining.BlastRadiusModifier.Rank_" + tier.toNumerical() + " should be less than or equal to Skills.Mining.BlastMining.BlastRadiusModifier.Rank_" + nextTier.toNumerical() + "!");
        }
        if (this.getRepairMasteryMaxBonus() < 1.0) {
            reason.add("Skills.Repair.RepairMastery.MaxBonusPercentage should be at least 1!");
        }
        if (this.getRepairMasteryMaxLevel() < 1) {
            reason.add("Skills.Repair.RepairMastery.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaxChance(SecondaryAbility.SUPER_REPAIR) < 1.0) {
            reason.add("Skills.Repair.SuperRepair.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.SUPER_REPAIR) < 1) {
            reason.add("Skills.Repair.SuperRepair.MaxBonusLevel should be at least 1!");
        }
        if (this.getSalvageUnlockLevel() < 0) {
            reason.add("Skills.Repair.Salvage.UnlockLevel should be at least 0!");
        }
        List<ArcaneForging.Tier> arcaneForgingTierList = Arrays.asList(ArcaneForging.Tier.values());
        for (ArcaneForging.Tier tier : arcaneForgingTierList) {
            if (this.getArcaneForgingRankLevel(tier) < 0) {
                reason.add("Skills.Repair.ArcaneForging.Rank_Levels.Rank_" + tier.toNumerical() + " should be at least 0!");
            }
            if (this.getArcaneForgingDowngradeChance(tier) < 0.0 || this.getArcaneForgingDowngradeChance(tier) > 100.0) {
                reason.add("Skills.Repair.ArcaneForging.Downgrades.Chance.Rank_" + tier.toNumerical() + " only accepts values from 0 to 100!");
            }
            if (this.getArcaneForgingKeepEnchantsChance(tier) < 0.0 || this.getArcaneForgingKeepEnchantsChance(tier) > 100.0) {
                reason.add("Skills.Repair.ArcaneForging.Keep_Enchants.Chance.Rank_" + tier.toNumerical() + " only accepts values from 0 to 100!");
            }
            if (tier == ArcaneForging.Tier.EIGHT) continue;
            ArcaneForging.Tier nextTier = arcaneForgingTierList.get(arcaneForgingTierList.indexOf((Object)tier) - 1);
            if (this.getArcaneForgingRankLevel(tier) > this.getArcaneForgingRankLevel(nextTier)) {
                reason.add("Skills.Repair.ArcaneForging.Rank_Levels.Rank_" + tier.toNumerical() + " should be less than or equal to Skills.Repair.ArcaneForging.Rank_Levels.Rank_" + nextTier.toNumerical() + "!");
            }
            if (this.getArcaneForgingDowngradeChance(nextTier) > this.getArcaneForgingDowngradeChance(tier)) {
                reason.add("Skills.Repair.ArcaneForging.Downgrades.Chance.Rank_" + nextTier.toNumerical() + " should be less than or equal to Skills.Repair.ArcaneForging.Downgrades.Chance.Rank_" + tier.toNumerical() + "!");
            }
            if (!(this.getArcaneForgingKeepEnchantsChance(tier) > this.getArcaneForgingKeepEnchantsChance(nextTier))) continue;
            reason.add("Skills.Repair.ArcaneForging.Keep_Enchants.Chance.Rank_" + tier.toNumerical() + " should be less than or equal to Skills.Repair.ArcaneForging.Keep_Enchants.Chance.Rank_" + nextTier.toNumerical() + "!");
        }
        if (this.getBurnModifierMaxLevel() < 1) {
            reason.add("Skills.Smelting.FuelEfficiency.MaxBonusLevel should be at least 1!");
        }
        if (this.getBurnTimeMultiplier() < 1.0) {
            reason.add("Skills.Smelting.FuelEfficiency.Multiplier should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.SECOND_SMELT) < 1) {
            reason.add("Skills.Smelting.SecondSmelt.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaxChance(SecondaryAbility.SECOND_SMELT) < 1.0) {
            reason.add("Skills.Smelting.SecondSmelt.ChanceMax should be at least 1!");
        }
        if (this.getFluxMiningUnlockLevel() < 0) {
            reason.add("Skills.Smelting.FluxMining.UnlockLevel should be at least 0!");
        }
        if (this.getFluxMiningChance() < 1.0) {
            reason.add("Skills.Smelting.FluxMining.Chance should be at least 1!");
        }
        List<Smelting.Tier> smeltingTierList = Arrays.asList(Smelting.Tier.values());
        for (Smelting.Tier tier : smeltingTierList) {
            if (this.getSmeltingRankLevel(tier) < 0) {
                reason.add("Skills.Smelting.Rank_Levels.Rank_" + tier.toNumerical() + " should be at least 0!");
            }
            if (this.getSmeltingVanillaXPBoostMultiplier(tier) < 1) {
                reason.add("Skills.Smelting.VanillaXPMultiplier.Rank_" + tier.toNumerical() + " should be at least 1!");
            }
            if (tier == Smelting.Tier.EIGHT) continue;
            Smelting.Tier nextTier = smeltingTierList.get(smeltingTierList.indexOf((Object)tier) - 1);
            if (this.getSmeltingRankLevel(tier) > this.getSmeltingRankLevel(nextTier)) {
                reason.add("Skills.Smelting.Rank_Levels.Rank_" + tier.toNumerical() + " should be less than or equal to Skills.Smelting.Rank_Levels.Rank_" + nextTier.toNumerical() + "!");
            }
            if (this.getSmeltingVanillaXPBoostMultiplier(tier) <= this.getSmeltingVanillaXPBoostMultiplier(nextTier)) continue;
            reason.add("Skills.Smelting.VanillaXPMultiplier.Rank_" + tier.toNumerical() + " should be less than or equal to Skills.Smelting.VanillaXPMultiplier.Rank_" + nextTier.toNumerical() + "!");
        }
        if (this.getMaxChance(SecondaryAbility.BLEED) < 1.0) {
            reason.add("Skills.Swords.Bleed.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.BLEED) < 1) {
            reason.add("Skills.Swords.Bleed.MaxBonusLevel should be at least 1!");
        }
        if (this.getBleedMaxTicks() < 1) {
            reason.add("Skills.Swords.Bleed.MaxTicks should be at least 1!");
        }
        if (this.getBleedMaxTicks() < this.getBleedBaseTicks()) {
            reason.add("Skills.Swords.Bleed.MaxTicks should be at least Skills.Swords.Bleed.BaseTicks!");
        }
        if (this.getBleedBaseTicks() < 1) {
            reason.add("Skills.Swords.Bleed.BaseTicks should be at least 1!");
        }
        if (this.getMaxChance(SecondaryAbility.COUNTER) < 1.0) {
            reason.add("Skills.Swords.Counter.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.COUNTER) < 1) {
            reason.add("Skills.Swords.Counter.MaxBonusLevel should be at least 1!");
        }
        if (this.getCounterModifier() < 1.0) {
            reason.add("Skills.Swords.Counter.DamageModifier should be at least 1!");
        }
        if (this.getSerratedStrikesModifier() < 1.0) {
            reason.add("Skills.Swords.SerratedStrikes.DamageModifier should be at least 1!");
        }
        if (this.getSerratedStrikesTicks() < 1) {
            reason.add("Skills.Swords.SerratedStrikes.BleedTicks should be at least 1!");
        }
        if (this.getMaxChance(SecondaryAbility.GORE) < 1.0) {
            reason.add("Skills.Taming.Gore.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.GORE) < 1) {
            reason.add("Skills.Taming.Gore.MaxBonusLevel should be at least 1!");
        }
        if (this.getGoreBleedTicks() < 1) {
            reason.add("Skills.Taming.Gore.BleedTicks should be at least 1!");
        }
        if (this.getGoreModifier() < 1.0) {
            reason.add("Skills.Taming.Gore.Modifier should be at least 1!");
        }
        if (this.getFastFoodUnlock() < 0) {
            reason.add("Skills.Taming.FastFood.UnlockLevel should be at least 0!");
        }
        if (this.getFastFoodChance() < 1.0) {
            reason.add("Skills.Taming.FastFood.Chance should be at least 1!");
        }
        if (this.getEnviromentallyAwareUnlock() < 0) {
            reason.add("Skills.Taming.EnvironmentallyAware.UnlockLevel should be at least 0!");
        }
        if (this.getThickFurUnlock() < 0) {
            reason.add("Skills.Taming.ThickFur.UnlockLevel should be at least 0!");
        }
        if (this.getThickFurModifier() < 1.0) {
            reason.add("Skills.Taming.ThickFur.Modifier should be at least 1!");
        }
        if (this.getHolyHoundUnlock() < 0) {
            reason.add("Skills.Taming.HolyHound.UnlockLevel should be at least 0!");
        }
        if (this.getShockProofUnlock() < 0) {
            reason.add("Skills.Taming.ShockProof.UnlockLevel should be at least 0!");
        }
        if (this.getShockProofModifier() < 1.0) {
            reason.add("Skills.Taming.ShockProof.Modifier should be at least 1!");
        }
        if (this.getSharpenedClawsUnlock() < 0) {
            reason.add("Skills.Taming.SharpenedClaws.UnlockLevel should be at least 0!");
        }
        if (this.getSharpenedClawsBonus() < 1.0) {
            reason.add("Skills.Taming.SharpenedClaws.Bonus should be at least 1!");
        }
        if (this.getMaxHorseJumpStrength() < 0.0 || this.getMaxHorseJumpStrength() > 2.0) {
            reason.add("Skills.Taming.CallOfTheWild.MaxHorseJumpStrength should be between 0 and 2!");
        }
        if (this.getMaxChance(SecondaryAbility.DISARM) < 1.0) {
            reason.add("Skills.Unarmed.Disarm.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.DISARM) < 1) {
            reason.add("Skills.Unarmed.Disarm.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaxChance(SecondaryAbility.DEFLECT) < 1.0) {
            reason.add("Skills.Unarmed.Deflect.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.DEFLECT) < 1) {
            reason.add("Skills.Unarmed.Deflect.MaxBonusLevel should be at least 1!");
        }
        if (this.getMaxChance(SecondaryAbility.IRON_GRIP) < 1.0) {
            reason.add("Skills.Unarmed.IronGrip.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.IRON_GRIP) < 1) {
            reason.add("Skills.Unarmed.IronGrip.MaxBonusLevel should be at least 1!");
        }
        if (this.getIronArmMinBonus() < 0.0) {
            reason.add("Skills.Unarmed.IronArm.BonusMin should be at least 0!");
        }
        if (this.getIronArmMaxBonus() < 0.0) {
            reason.add("Skills.Unarmed.IronArm.BonusMax should be at least 0!");
        }
        if (this.getIronArmMaxBonus() < this.getIronArmMinBonus()) {
            reason.add("Skills.Unarmed.IronArm.BonusMax should be greater than or equal to Skills.Unarmed.IronArm.BonusMin!");
        }
        if (this.getIronArmIncreaseLevel() < 1) {
            reason.add("Skills.Unarmed.IronArm.IncreaseLevel should be at least 1!");
        }
        if (this.getLeafBlowUnlockLevel() < 0) {
            reason.add("Skills.Woodcutting.LeafBlower.UnlockLevel should be at least 0!");
        }
        if (this.getMaxChance(SecondaryAbility.WOODCUTTING_DOUBLE_DROPS) < 1.0) {
            reason.add("Skills.Woodcutting.DoubleDrops.ChanceMax should be at least 1!");
        }
        if (this.getMaxBonusLevel(SecondaryAbility.WOODCUTTING_DOUBLE_DROPS) < 1) {
            reason.add("Skills.Woodcutting.DoubleDrops.MaxBonusLevel should be at least 1!");
        }
        if (this.getKrakenTriesBeforeRelease() < 1) {
            reason.add("Kraken.Tries_Before_Release should be at least 1!");
        }
        if (this.getKrakenHealth() < 1.0) {
            reason.add("Kraken.Health should be at least 1!");
        }
        if (this.getKrakenAttackInterval() < 1) {
            reason.add("Kraken.Attack_Interval_Seconds should be at least 1!");
        }
        if (this.getKrakenAttackDamage() < 1.0) {
            reason.add("Kraken.Attack_Damage should be at least 1!");
        }
        return this.noErrorsInConfig(reason);
    }

    @Override
    protected void loadKeys() {
    }

    public int getAbilityLength() {
        return this.config.getInt("Skills.General.Ability.IncreaseLevel", 50);
    }

    public int getEnchantBuff() {
        return this.config.getInt("Skills.General.Ability.EnchantBuff", 5);
    }

    public int getMaxBonusLevel(SecondaryAbility skillAbility) {
        return this.config.getInt("Skills." + StringUtils.getCapitalized(SkillType.bySecondaryAbility(skillAbility).toString()) + "." + StringUtils.getPrettySecondaryAbilityString(skillAbility).replace(" ", "") + ".MaxBonusLevel");
    }

    public double getMaxChance(SecondaryAbility skillAbility) {
        return this.config.getDouble("Skills." + StringUtils.getCapitalized(SkillType.bySecondaryAbility(skillAbility).toString()) + "." + StringUtils.getPrettySecondaryAbilityString(skillAbility).replace(" ", "") + ".ChanceMax", 100.0);
    }

    public double getDodgeDamageModifier() {
        return this.config.getDouble("Skills.Acrobatics.Dodge.DamageModifier", 2.0);
    }

    public double getRollDamageThreshold() {
        return this.config.getDouble("Skills.Acrobatics.Roll.DamageThreshold", 7.0);
    }

    public double getGracefulRollDamageThreshold() {
        return this.config.getDouble("Skills.Acrobatics.GracefulRoll.DamageThreshold", 14.0);
    }

    public int getCatalysisUnlockLevel() {
        return this.config.getInt("Skills.Alchemy.Catalysis.UnlockLevel", 100);
    }

    public int getCatalysisMaxBonusLevel() {
        return this.config.getInt("Skills.Alchemy.Catalysis.MaxBonusLevel", 1000);
    }

    public double getCatalysisMinSpeed() {
        return this.config.getDouble("Skills.Alchemy.Catalysis.MinSpeed", 1.0);
    }

    public double getCatalysisMaxSpeed() {
        return this.config.getDouble("Skills.Alchemy.Catalysis.MaxSpeed", 4.0);
    }

    public int getConcoctionsTierLevel(Alchemy.Tier tier) {
        return this.config.getInt("Skills.Alchemy.Rank_Levels.Rank_" + tier.toNumerical());
    }

    public int getSkillShotIncreaseLevel() {
        return this.config.getInt("Skills.Archery.SkillShot.IncreaseLevel", 50);
    }

    public double getSkillShotIncreasePercentage() {
        return this.config.getDouble("Skills.Archery.SkillShot.IncreasePercentage", 0.1);
    }

    public double getSkillShotBonusMax() {
        return this.config.getDouble("Skills.Archery.SkillShot.MaxBonus", 2.0);
    }

    public double getSkillShotDamageMax() {
        return this.config.getDouble("Skills.Archery.SkillShot.MaxDamage", 9.0);
    }

    public double getDazeModifier() {
        return this.config.getDouble("Skills.Archery.Daze.BonusDamage", 4.0);
    }

    public double getForceMultiplier() {
        return this.config.getDouble("Skills.Archery.ForceMultiplier", 2.0);
    }

    public double getAxeMasteryBonusMax() {
        return this.config.getDouble("Skills.Axes.AxeMastery.MaxBonus", 4.0);
    }

    public int getAxeMasteryMaxBonusLevel() {
        return this.config.getInt("Skills.Axes.AxeMastery.MaxBonusLevel", 200);
    }

    public double getCriticalHitPVPModifier() {
        return this.config.getDouble("Skills.Axes.CriticalHit.PVP_Modifier", 1.5);
    }

    public double getCriticalHitPVEModifier() {
        return this.config.getDouble("Skills.Axes.CriticalHit.PVE_Modifier", 2.0);
    }

    public double getGreaterImpactChance() {
        return this.config.getDouble("Skills.Axes.GreaterImpact.Chance", 25.0);
    }

    public double getGreaterImpactModifier() {
        return this.config.getDouble("Skills.Axes.GreaterImpact.KnockbackModifier", 1.5);
    }

    public double getGreaterImpactBonusDamage() {
        return this.config.getDouble("Skills.Axes.GreaterImpact.BonusDamage", 2.0);
    }

    public int getArmorImpactIncreaseLevel() {
        return this.config.getInt("Skills.Axes.ArmorImpact.IncreaseLevel", 50);
    }

    public double getImpactChance() {
        return this.config.getDouble("Skills.Axes.ArmorImpact.Chance", 25.0);
    }

    public double getArmorImpactMaxDurabilityDamage() {
        return this.config.getDouble("Skills.Axes.ArmorImpact.MaxPercentageDurabilityDamage", 20.0);
    }

    public double getSkullSplitterModifier() {
        return this.config.getDouble("Skills.Axes.SkullSplitter.DamagerModifier", 2.0);
    }

    public int getFishingTierLevel(Fishing.Tier tier) {
        return this.config.getInt("Skills.Fishing.Rank_Levels.Rank_" + tier.toNumerical());
    }

    public double getShakeChance(Fishing.Tier tier) {
        return this.config.getDouble("Skills.Fishing.ShakeChance.Rank_" + tier.toNumerical());
    }

    public int getFishingVanillaXPModifier(Fishing.Tier tier) {
        return this.config.getInt("Skills.Fishing.VanillaXPMultiplier.Rank_" + tier.toNumerical());
    }

    public int getFishermanDietRankChange() {
        return this.config.getInt("Skills.Fishing.FishermansDiet.RankChange", 200);
    }

    public int getIceFishingUnlockLevel() {
        return this.config.getInt("Skills.Fishing.IceFishing.UnlockLevel", 50);
    }

    public int getMasterAnglerUnlockLevel() {
        return this.config.getInt("Skills.Fishing.MasterAngler.UnlockLevel", 125);
    }

    public double getMasterAnglerBoatModifier() {
        return this.config.getDouble("Skills.Fishing.MasterAngler.BoatModifier", 2.0);
    }

    public double getMasterAnglerBiomeModifier() {
        return this.config.getDouble("Skills.Fishing.MasterAngler.BiomeModifier", 2.0);
    }

    public int getFarmerDietRankChange() {
        return this.config.getInt("Skills.Herbalism.FarmersDiet.RankChange", 200);
    }

    public int getGreenThumbStageChange() {
        return this.config.getInt("Skills.Herbalism.GreenThumb.StageChange", 200);
    }

    public int getBlastMiningRankLevel(BlastMining.Tier tier) {
        return this.config.getInt("Skills.Mining.BlastMining.Rank_Levels.Rank_" + tier.toNumerical());
    }

    public double getBlastDamageDecrease(BlastMining.Tier tier) {
        return this.config.getDouble("Skills.Mining.BlastMining.BlastDamageDecrease.Rank_" + tier.toNumerical());
    }

    public double getOreBonus(BlastMining.Tier tier) {
        return this.config.getDouble("Skills.Mining.BlastMining.OreBonus.Rank_" + tier.toNumerical());
    }

    public double getDebrisReduction(BlastMining.Tier tier) {
        return this.config.getDouble("Skills.Mining.BlastMining.DebrisReduction.Rank_" + tier.toNumerical());
    }

    public int getDropMultiplier(BlastMining.Tier tier) {
        return this.config.getInt("Skills.Mining.BlastMining.DropMultiplier.Rank_" + tier.toNumerical());
    }

    public double getBlastRadiusModifier(BlastMining.Tier tier) {
        return this.config.getDouble("Skills.Mining.BlastMining.BlastRadiusModifier.Rank_" + tier.toNumerical());
    }

    public double getRepairMasteryMaxBonus() {
        return this.config.getDouble("Skills.Repair.RepairMastery.MaxBonusPercentage", 200.0);
    }

    public int getRepairMasteryMaxLevel() {
        return this.config.getInt("Skills.Repair.RepairMastery.MaxBonusLevel", 1000);
    }

    public int getSalvageUnlockLevel() {
        return this.config.getInt("Skills.Repair.Salvage.UnlockLevel", 600);
    }

    public int getArcaneForgingRankLevel(ArcaneForging.Tier tier) {
        return this.config.getInt("Skills.Repair.ArcaneForging.Rank_Levels.Rank_" + tier.toNumerical());
    }

    public boolean getArcaneForgingEnchantLossEnabled() {
        return this.config.getBoolean("Skills.Repair.ArcaneForging.May_Lose_Enchants", true);
    }

    public double getArcaneForgingKeepEnchantsChance(ArcaneForging.Tier tier) {
        return this.config.getDouble("Skills.Repair.ArcaneForging.Keep_Enchants_Chance.Rank_" + tier.toNumerical());
    }

    public boolean getArcaneForgingDowngradeEnabled() {
        return this.config.getBoolean("Skills.Repair.ArcaneForging.Downgrades_Enabled", true);
    }

    public double getArcaneForgingDowngradeChance(ArcaneForging.Tier tier) {
        return this.config.getDouble("Skills.Repair.ArcaneForging.Downgrades_Chance.Rank_" + tier.toNumerical());
    }

    public int getBurnModifierMaxLevel() {
        return this.config.getInt("Skills.Smelting.FuelEfficiency.MaxBonusLevel", 1000);
    }

    public double getBurnTimeMultiplier() {
        return this.config.getDouble("Skills.Smelting.FuelEfficiency.Multiplier", 3.0);
    }

    public int getFluxMiningUnlockLevel() {
        return this.config.getInt("Skills.Smelting.FluxMining.UnlockLevel", 250);
    }

    public double getFluxMiningChance() {
        return this.config.getDouble("Skills.Smelting.FluxMining.Chance", 33.0);
    }

    public int getSmeltingRankLevel(Smelting.Tier tier) {
        return this.config.getInt("Skills.Smelting.Rank_Levels.Rank_" + tier.toNumerical());
    }

    public int getSmeltingVanillaXPBoostMultiplier(Smelting.Tier tier) {
        return this.config.getInt("Skills.Smelting.VanillaXPMultiplier.Rank_" + tier.toNumerical());
    }

    public int getBleedMaxTicks() {
        return this.config.getInt("Skills.Swords.Bleed.MaxTicks", 3);
    }

    public int getBleedBaseTicks() {
        return this.config.getInt("Skills.Swords.Bleed.BaseTicks", 2);
    }

    public boolean getCounterRequiresBlock() {
        return this.config.getBoolean("Skills.Swords.Counter.RequiresBlock");
    }

    public double getCounterModifier() {
        return this.config.getDouble("Skills.Swords.Counter.DamageModifier", 2.0);
    }

    public double getSerratedStrikesModifier() {
        return this.config.getDouble("Skills.Swords.SerratedStrikes.DamageModifier", 4.0);
    }

    public int getSerratedStrikesTicks() {
        return this.config.getInt("Skills.Swords.SerratedStrikes.BleedTicks", 5);
    }

    public int getGoreBleedTicks() {
        return this.config.getInt("Skills.Taming.Gore.BleedTicks", 2);
    }

    public double getGoreModifier() {
        return this.config.getDouble("Skills.Taming.Gore.Modifier", 2.0);
    }

    public int getFastFoodUnlock() {
        return this.config.getInt("Skills.Taming.FastFood.UnlockLevel", 50);
    }

    public double getFastFoodChance() {
        return this.config.getDouble("Skills.Taming.FastFood.Chance", 50.0);
    }

    public int getEnviromentallyAwareUnlock() {
        return this.config.getInt("Skills.Taming.EnvironmentallyAware.UnlockLevel", 100);
    }

    public int getThickFurUnlock() {
        return this.config.getInt("Skills.Taming.ThickFur.UnlockLevel", 250);
    }

    public double getThickFurModifier() {
        return this.config.getDouble("Skills.Taming.ThickFur.Modifier", 2.0);
    }

    public int getHolyHoundUnlock() {
        return this.config.getInt("Skills.Taming.HolyHound.UnlockLevel", 375);
    }

    public int getShockProofUnlock() {
        return this.config.getInt("Skills.Taming.ShockProof.UnlockLevel", 500);
    }

    public double getShockProofModifier() {
        return this.config.getDouble("Skills.Taming.ShockProof.Modifier", 6.0);
    }

    public int getSharpenedClawsUnlock() {
        return this.config.getInt("Skills.Taming.SharpenedClaws.UnlockLevel", 750);
    }

    public double getSharpenedClawsBonus() {
        return this.config.getDouble("Skills.Taming.SharpenedClaws.Bonus", 2.0);
    }

    public double getMinHorseJumpStrength() {
        return this.config.getDouble("Skills.Taming.CallOfTheWild.MinHorseJumpStrength", 0.7);
    }

    public double getMaxHorseJumpStrength() {
        return this.config.getDouble("Skills.Taming.CallOfTheWild.MaxHorseJumpStrength", 2.0);
    }

    public double getIronArmMinBonus() {
        return this.config.getDouble("Skills.Unarmed.IronArm.BonusMin", 3.0);
    }

    public double getIronArmMaxBonus() {
        return this.config.getDouble("Skills.Unarmed.IronArm.BonusMax", 8.0);
    }

    public int getIronArmIncreaseLevel() {
        return this.config.getInt("Skills.Unarmed.IronArm.IncreaseLevel", 50);
    }

    public boolean getDisarmProtected() {
        return this.config.getBoolean("Skills.Unarmed.Disarm.AntiTheft", false);
    }

    public int getLeafBlowUnlockLevel() {
        return this.config.getInt("Skills.Woodcutting.LeafBlower.UnlockLevel", 100);
    }

    public boolean getKrakenEnabled() {
        return this.config.getBoolean("Kraken.Enabled", true);
    }

    public int getKrakenTriesBeforeRelease() {
        return this.config.getInt("Kraken.Tries_Before_Release", 50);
    }

    public double getKrakenHealth() {
        return this.config.getDouble("Kraken.Health", 50.0);
    }

    public String getKrakenName() {
        return this.config.getString("Kraken.Name", "The Kraken");
    }

    public int getKrakenAttackInterval() {
        return this.config.getInt("Kraken.Attack_Interval_Seconds", 1);
    }

    public double getKrakenAttackDamage() {
        return this.config.getDouble("Kraken.Attack_Damage", 1.0);
    }

    public boolean getKrakenGlobalEffectsEnabled() {
        return this.config.getBoolean("Kraken.Global_Effects", false);
    }

    public boolean getKrakenEscapeAllowed() {
        return this.config.getBoolean("Kraken.Allow_Escaping", false);
    }

    public String getServerUnleashMessage() {
        return this.config.getString("Kraken.Unleashed_Message.Server", "");
    }

    public String getPlayerUnleashMessage() {
        return this.config.getString("Kraken.Unleashed_Message.Player", "");
    }

    public String getPlayerDefeatMessage() {
        return this.config.getString("Kraken.Defeated_Message.Killed", "");
    }

    public String getPlayerEscapeMessage() {
        return this.config.getString("Kraken.Defeated_Message.Escape", "");
    }
}

