/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.config.ConfigLoader;
import com.gmail.nossr50.metrics.MetricsManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class AutoUpdateConfigLoader
extends ConfigLoader {
    public AutoUpdateConfigLoader(String relativePath, String fileName) {
        super(relativePath, fileName);
    }

    public AutoUpdateConfigLoader(String fileName) {
        super(fileName);
    }

    @Override
    protected void loadFile() {
        super.loadFile();
        YamlConfiguration internalConfig = YamlConfiguration.loadConfiguration((InputStream)plugin.getResource(this.fileName));
        Set configKeys = this.config.getKeys(true);
        Set internalConfigKeys = internalConfig.getKeys(true);
        boolean needSave = false;
        HashSet oldKeys = new HashSet(configKeys);
        oldKeys.removeAll(internalConfigKeys);
        HashSet newKeys = new HashSet(internalConfigKeys);
        newKeys.removeAll(configKeys);
        if (!newKeys.isEmpty() || !oldKeys.isEmpty()) {
            needSave = true;
        }
        for (String key : oldKeys) {
            plugin.debug("Removing unused key: " + key);
            this.config.set(key, null);
        }
        for (String key : newKeys) {
            plugin.debug("Adding new key: " + key + " = " + internalConfig.get(key));
            this.config.set(key, internalConfig.get(key));
        }
        if (needSave) {
            String output = this.config.saveToString();
            output = output.replace("  ", "    ");
            while (output.replaceAll("[//s]", "").startsWith("#")) {
                output = output.substring(output.indexOf(10, output.indexOf(35)) + 1);
            }
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(plugin.getResource(this.fileName)));
                HashMap<String, String> comments = new HashMap<String, String>();
                String temp = "";
                while ((line = reader.readLine()) != null) {
                    if (line.contains("#")) {
                        temp = temp + line + "\n";
                        continue;
                    }
                    if (!line.contains(":")) continue;
                    line = line.substring(0, line.indexOf(":") + 1);
                    if (temp.isEmpty()) continue;
                    comments.put(line, temp);
                    temp = "";
                }
                for (String key : comments.keySet()) {
                    if (!output.contains(key)) continue;
                    output = output.substring(0, output.indexOf(key)) + (String)comments.get(key) + output.substring(output.indexOf(key));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                String saveName = this.fileName;
                if (!plugin.getConfig().getBoolean("General.Config_Update_Overwrite", true)) {
                    saveName = saveName + ".new";
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(plugin.getDataFolder(), saveName)));
                writer.write(output);
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            for (String key : configKeys) {
                if (this.config.isConfigurationSection(key) || this.config.get(key).equals(internalConfig.get(key))) continue;
                MetricsManager.customConfig();
                break;
            }
        }
    }
}

