/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.player;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.chat.ChatMode;
import com.gmail.nossr50.datatypes.mods.CustomTool;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyTeleportRecord;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.party.ShareHandler;
import com.gmail.nossr50.runnables.skills.AbilityDisableTask;
import com.gmail.nossr50.runnables.skills.ToolLowerTask;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.acrobatics.AcrobaticsManager;
import com.gmail.nossr50.skills.alchemy.AlchemyManager;
import com.gmail.nossr50.skills.archery.ArcheryManager;
import com.gmail.nossr50.skills.axes.AxesManager;
import com.gmail.nossr50.skills.child.FamilyTree;
import com.gmail.nossr50.skills.excavation.ExcavationManager;
import com.gmail.nossr50.skills.fishing.FishingManager;
import com.gmail.nossr50.skills.herbalism.HerbalismManager;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.skills.repair.RepairManager;
import com.gmail.nossr50.skills.smelting.SmeltingManager;
import com.gmail.nossr50.skills.swords.SwordsManager;
import com.gmail.nossr50.skills.taming.TamingManager;
import com.gmail.nossr50.skills.unarmed.UnarmedManager;
import com.gmail.nossr50.skills.woodcutting.WoodcuttingManager;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.gmail.nossr50.util.skills.PerksUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class McMMOPlayer {
    private Player player;
    private PlayerProfile profile;
    private final Map<SkillType, SkillManager> skillManagers = new HashMap<SkillType, SkillManager>();
    private Party party;
    private Party invite;
    private Party allianceInvite;
    private int itemShareModifier;
    private PartyTeleportRecord ptpRecord;
    private boolean partyChatMode;
    private boolean adminChatMode;
    private boolean displaySkillNotifications = true;
    private boolean abilityUse = true;
    private boolean godMode;
    private final Map<AbilityType, Boolean> abilityMode = new HashMap<AbilityType, Boolean>();
    private final Map<AbilityType, Boolean> abilityInformed = new HashMap<AbilityType, Boolean>();
    private final Map<ToolType, Boolean> toolMode = new HashMap<ToolType, Boolean>();
    private int recentlyHurt;
    private int respawnATS;
    private int teleportATS;
    private long databaseATS;
    private int chimeraWingLastUse;
    private Location teleportCommence;
    private boolean isUsingUnarmed;
    private final FixedMetadataValue playerMetadata;

    public McMMOPlayer(Player player) {
        String playerName = player.getName();
        this.player = player;
        this.playerMetadata = new FixedMetadataValue((Plugin)mcMMO.p, (Object)playerName);
        this.profile = mcMMO.getDatabaseManager().loadPlayerProfile(playerName, true);
        this.party = PartyManager.getPlayerParty(playerName);
        this.ptpRecord = new PartyTeleportRecord();
        try {
            for (Enum enum_ : SkillType.values()) {
                this.skillManagers.put((SkillType)enum_, ((SkillType)enum_).getManagerClass().getConstructor(McMMOPlayer.class).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mcMMO.p.getPluginLoader().disablePlugin((Plugin)mcMMO.p);
        }
        for (Enum enum_ : AbilityType.values()) {
            this.abilityMode.put((AbilityType)enum_, false);
            this.abilityInformed.put((AbilityType)enum_, true);
        }
        for (Enum enum_ : ToolType.values()) {
            this.toolMode.put((ToolType)enum_, false);
        }
        if (!this.profile.isLoaded()) {
            mcMMO.p.getLogger().warning("Unable to load the PlayerProfile for " + playerName + ". Will retry over the next several seconds.");
            new RetryProfileLoadingTask().runTaskTimerAsynchronously((Plugin)mcMMO.p, 11L, 31L);
        }
    }

    public AcrobaticsManager getAcrobaticsManager() {
        return (AcrobaticsManager)this.skillManagers.get((Object)SkillType.ACROBATICS);
    }

    public AlchemyManager getAlchemyManager() {
        return (AlchemyManager)this.skillManagers.get((Object)SkillType.ALCHEMY);
    }

    public ArcheryManager getArcheryManager() {
        return (ArcheryManager)this.skillManagers.get((Object)SkillType.ARCHERY);
    }

    public AxesManager getAxesManager() {
        return (AxesManager)this.skillManagers.get((Object)SkillType.AXES);
    }

    public ExcavationManager getExcavationManager() {
        return (ExcavationManager)this.skillManagers.get((Object)SkillType.EXCAVATION);
    }

    public FishingManager getFishingManager() {
        return (FishingManager)this.skillManagers.get((Object)SkillType.FISHING);
    }

    public HerbalismManager getHerbalismManager() {
        return (HerbalismManager)this.skillManagers.get((Object)SkillType.HERBALISM);
    }

    public MiningManager getMiningManager() {
        return (MiningManager)this.skillManagers.get((Object)SkillType.MINING);
    }

    public RepairManager getRepairManager() {
        return (RepairManager)this.skillManagers.get((Object)SkillType.REPAIR);
    }

    public SmeltingManager getSmeltingManager() {
        return (SmeltingManager)this.skillManagers.get((Object)SkillType.SMELTING);
    }

    public SwordsManager getSwordsManager() {
        return (SwordsManager)this.skillManagers.get((Object)SkillType.SWORDS);
    }

    public TamingManager getTamingManager() {
        return (TamingManager)this.skillManagers.get((Object)SkillType.TAMING);
    }

    public UnarmedManager getUnarmedManager() {
        return (UnarmedManager)this.skillManagers.get((Object)SkillType.UNARMED);
    }

    public WoodcuttingManager getWoodcuttingManager() {
        return (WoodcuttingManager)this.skillManagers.get((Object)SkillType.WOODCUTTING);
    }

    public void resetAbilityMode() {
        for (AbilityType ability : AbilityType.values()) {
            new AbilityDisableTask(this, ability).run();
        }
    }

    public boolean getAbilityMode(AbilityType ability) {
        return this.abilityMode.get((Object)ability);
    }

    public void setAbilityMode(AbilityType ability, boolean isActive) {
        this.abilityMode.put(ability, isActive);
    }

    public boolean getAbilityInformed(AbilityType ability) {
        return this.abilityInformed.get((Object)ability);
    }

    public void setAbilityInformed(AbilityType ability, boolean isInformed) {
        this.abilityInformed.put(ability, isInformed);
    }

    public boolean getToolPreparationMode(ToolType tool) {
        return this.toolMode.get((Object)tool);
    }

    public boolean getAbilityUse() {
        return this.abilityUse;
    }

    public void toggleAbilityUse() {
        this.abilityUse = !this.abilityUse;
    }

    public void resetToolPrepMode() {
        for (ToolType tool : ToolType.values()) {
            this.setToolPreparationMode(tool, false);
        }
    }

    public void setToolPreparationMode(ToolType tool, boolean isPrepared) {
        this.toolMode.put(tool, isPrepared);
    }

    public int getRecentlyHurt() {
        return this.recentlyHurt;
    }

    public void setRecentlyHurt(int value) {
        this.recentlyHurt = value;
    }

    public void actualizeRecentlyHurt() {
        this.recentlyHurt = (int)(System.currentTimeMillis() / 1000L);
    }

    public int getChimeraWingLastUse() {
        return this.chimeraWingLastUse;
    }

    public void actualizeChimeraWingLastUse() {
        this.chimeraWingLastUse = (int)(System.currentTimeMillis() / 1000L);
    }

    public Location getTeleportCommenceLocation() {
        return this.teleportCommence;
    }

    public void setTeleportCommenceLocation(Location location) {
        this.teleportCommence = location;
    }

    public void actualizeTeleportCommenceLocation(Player player) {
        this.teleportCommence = player.getLocation();
    }

    public int getRespawnATS() {
        return this.respawnATS;
    }

    public void actualizeRespawnATS() {
        this.respawnATS = (int)(System.currentTimeMillis() / 1000L);
    }

    public int getTeleportATS() {
        return this.teleportATS;
    }

    public void actualizeTeleportATS() {
        this.teleportATS = (int)(System.currentTimeMillis() / 1000L);
    }

    public long getDatabaseATS() {
        return this.databaseATS;
    }

    public void actualizeDatabaseATS() {
        this.databaseATS = System.currentTimeMillis();
    }

    public boolean getGodMode() {
        return this.godMode;
    }

    public void toggleGodMode() {
        this.godMode = !this.godMode;
    }

    public boolean useChatNotifications() {
        return this.displaySkillNotifications;
    }

    public void toggleChatNotifications() {
        this.displaySkillNotifications = !this.displaySkillNotifications;
    }

    public int getPowerLevel() {
        int powerLevel = 0;
        for (SkillType type : SkillType.NON_CHILD_SKILLS) {
            if (!type.getPermissions(this.player)) continue;
            powerLevel += this.getSkillLevel(type);
        }
        return powerLevel;
    }

    public void beginXpGain(SkillType skill, float xp) {
        Validate.isTrue(((double)xp >= 0.0 ? 1 : 0) != 0, (String)"XP gained should be greater than or equal to zero.");
        if ((double)xp <= 0.0) {
            return;
        }
        if (skill.isChildSkill()) {
            Set<SkillType> parentSkills = FamilyTree.getParents(skill);
            float splitXp = xp / (float)parentSkills.size();
            for (SkillType parentSkill : parentSkills) {
                if (!parentSkill.getPermissions(this.player)) continue;
                this.beginXpGain(parentSkill, splitXp);
            }
            return;
        }
        if (this.party != null && ShareHandler.handleXpShare(xp, this, skill)) {
            return;
        }
        this.beginUnsharedXpGain(skill, xp);
    }

    public void beginUnsharedXpGain(SkillType skill, float xp) {
        this.applyXpGain(skill, this.modifyXpGain(skill, xp));
        if (this.party == null) {
            return;
        }
        if (!Config.getInstance().getPartyXpNearMembersNeeded() || !PartyManager.getNearMembers(this).isEmpty()) {
            this.party.applyXpGain(this.modifyXpGain(skill, xp));
        }
    }

    public void applyXpGain(SkillType skillType, float xp) {
        if (!skillType.getPermissions(this.player)) {
            return;
        }
        if (skillType.isChildSkill()) {
            Set<SkillType> parentSkills = FamilyTree.getParents(skillType);
            for (SkillType parentSkill : parentSkills) {
                this.applyXpGain(parentSkill, xp / (float)parentSkills.size());
            }
            return;
        }
        if (!EventUtils.handleXpGainEvent(this.player, skillType, xp)) {
            return;
        }
        this.isUsingUnarmed = skillType == SkillType.UNARMED;
        this.checkXp(skillType);
    }

    private void checkXp(SkillType skillType) {
        if (this.getSkillXpLevelRaw(skillType) < (float)this.getXpToLevel(skillType)) {
            return;
        }
        int levelsGained = 0;
        float xpRemoved = 0.0f;
        while (this.getSkillXpLevelRaw(skillType) >= (float)this.getXpToLevel(skillType)) {
            if (this.hasReachedLevelCap(skillType)) {
                this.setSkillXpLevel(skillType, 0.0f);
                break;
            }
            xpRemoved += this.profile.levelUp(skillType);
            ++levelsGained;
        }
        if (!EventUtils.handleLevelChangeEvent(this.player, skillType, levelsGained, xpRemoved, true)) {
            return;
        }
        if (Config.getInstance().getLevelUpSoundsEnabled()) {
            this.player.playSound(this.player.getLocation(), Sound.LEVEL_UP, 0.75f, 0.5f);
        }
        this.player.sendMessage(LocaleLoader.getString(StringUtils.getCapitalized(skillType.toString()) + ".Skillup", levelsGained, this.getSkillLevel(skillType)));
    }

    public Player getPlayer() {
        return this.player;
    }

    public PlayerProfile getProfile() {
        return this.profile;
    }

    public void setPartyInvite(Party invite) {
        this.invite = invite;
    }

    public Party getPartyInvite() {
        return this.invite;
    }

    public boolean hasPartyInvite() {
        return this.invite != null;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public Party getParty() {
        return this.party;
    }

    public boolean inParty() {
        return this.party != null;
    }

    public void removeParty() {
        this.party = null;
    }

    public void removePartyInvite() {
        this.invite = null;
    }

    public PartyTeleportRecord getPartyTeleportRecord() {
        return this.ptpRecord;
    }

    public void setPartyAllianceInvite(Party allianceInvite) {
        this.allianceInvite = allianceInvite;
    }

    public Party getPartyAllianceInvite() {
        return this.allianceInvite;
    }

    public boolean hasPartyAllianceInvite() {
        return this.allianceInvite != null;
    }

    public void removePartyAllianceInvite() {
        this.allianceInvite = null;
    }

    public int getItemShareModifier() {
        if (this.itemShareModifier < 10) {
            this.setItemShareModifier(10);
        }
        return this.itemShareModifier;
    }

    public void setItemShareModifier(int modifier) {
        this.itemShareModifier = Math.max(10, modifier);
    }

    public boolean isChatEnabled(ChatMode mode) {
        switch (mode) {
            case ADMIN: {
                return this.adminChatMode;
            }
            case PARTY: {
                return this.partyChatMode;
            }
        }
        return false;
    }

    public void disableChat(ChatMode mode) {
        switch (mode) {
            case ADMIN: {
                this.adminChatMode = false;
                return;
            }
            case PARTY: {
                this.partyChatMode = false;
                return;
            }
        }
    }

    public void enableChat(ChatMode mode) {
        switch (mode) {
            case ADMIN: {
                this.adminChatMode = true;
                this.partyChatMode = false;
                return;
            }
            case PARTY: {
                this.partyChatMode = true;
                this.adminChatMode = false;
                return;
            }
        }
    }

    public void toggleChat(ChatMode mode) {
        switch (mode) {
            case ADMIN: {
                this.adminChatMode = !this.adminChatMode;
                this.partyChatMode = !this.adminChatMode && this.partyChatMode;
                return;
            }
            case PARTY: {
                this.partyChatMode = !this.partyChatMode;
                this.adminChatMode = !this.partyChatMode && this.adminChatMode;
                return;
            }
        }
    }

    public boolean isUsingUnarmed() {
        return this.isUsingUnarmed;
    }

    private float modifyXpGain(SkillType skillType, float xp) {
        CustomTool tool;
        if (this.player.getGameMode() == GameMode.CREATIVE || skillType.getMaxLevel() <= this.getSkillLevel(skillType) || Config.getInstance().getPowerLevelCap() <= this.getPowerLevel()) {
            return 0.0f;
        }
        xp = (float)((double)xp / skillType.getXpModifier() * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier());
        if (Config.getInstance().getToolModsEnabled() && (tool = mcMMO.getModManager().getTool(this.player.getItemInHand())) != null) {
            xp = (float)((double)xp * tool.getXpMultiplier());
        }
        return PerksUtils.handleXpPerks(this.player, xp, skillType);
    }

    public void checkGodMode() {
        if (this.godMode && !Permissions.mcgod((Permissible)this.player)) {
            this.toggleGodMode();
            this.player.sendMessage(LocaleLoader.getString("Commands.GodMode.Forbidden"));
        }
    }

    public void checkParty() {
        if (this.inParty() && !Permissions.party((Permissible)this.player)) {
            this.removeParty();
            this.player.sendMessage(LocaleLoader.getString("Party.Forbidden"));
        }
    }

    public void checkAbilityActivation(SkillType skill) {
        ToolType tool = skill.getTool();
        AbilityType ability = skill.getAbility();
        this.setToolPreparationMode(tool, false);
        if (this.getAbilityMode(ability)) {
            return;
        }
        int timeRemaining = this.calculateTimeRemaining(ability);
        if (timeRemaining > 0) {
            if (skill == SkillType.WOODCUTTING || skill == SkillType.AXES) {
                this.player.sendMessage(LocaleLoader.getString("Skills.TooTired", timeRemaining));
            }
            return;
        }
        if (EventUtils.callPlayerAbilityActivateEvent(this.player, skill).isCancelled()) {
            return;
        }
        int ticks = PerksUtils.handleActivationPerks(this.player, 2 + this.getSkillLevel(skill) / AdvancedConfig.getInstance().getAbilityLength(), ability.getMaxLength());
        ParticleEffectUtils.playAbilityEnabledEffect(this.player);
        if (this.useChatNotifications()) {
            this.player.sendMessage(ability.getAbilityOn());
        }
        SkillUtils.sendSkillMessage(this.player, ability.getAbilityPlayer(this.player));
        this.profile.setAbilityDATS(ability, System.currentTimeMillis() + (long)(ticks * 1000));
        this.setAbilityMode(ability, true);
        if (ability == AbilityType.SUPER_BREAKER || ability == AbilityType.GIGA_DRILL_BREAKER) {
            SkillUtils.handleAbilitySpeedIncrease(this.player);
        }
        new AbilityDisableTask(this, ability).runTaskLater((Plugin)mcMMO.p, ticks * 20);
    }

    public void processAbilityActivation(SkillType skill) {
        if (Config.getInstance().getAbilitiesOnlyActivateWhenSneaking() && !this.player.isSneaking()) {
            return;
        }
        ItemStack inHand = this.player.getItemInHand();
        if (mcMMO.getModManager().isCustomTool(inHand) && !mcMMO.getModManager().getTool(inHand).isAbilityEnabled()) {
            return;
        }
        if (!this.getAbilityUse()) {
            return;
        }
        for (AbilityType abilityType : AbilityType.values()) {
            if (!this.getAbilityMode(abilityType)) continue;
            return;
        }
        AbilityType ability = skill.getAbility();
        ToolType tool = skill.getTool();
        if (ability.getPermissions(this.player) && tool.inHand(inHand) && !this.getToolPreparationMode(tool)) {
            if (skill != SkillType.WOODCUTTING && skill != SkillType.AXES) {
                int timeRemaining = this.calculateTimeRemaining(ability);
                if (!this.getAbilityMode(ability) && timeRemaining > 0) {
                    this.player.sendMessage(LocaleLoader.getString("Skills.TooTired", timeRemaining));
                    return;
                }
            }
            if (Config.getInstance().getAbilityMessagesEnabled()) {
                this.player.sendMessage(tool.getRaiseTool());
            }
            this.setToolPreparationMode(tool, true);
            new ToolLowerTask(this, tool).runTaskLaterAsynchronously((Plugin)mcMMO.p, 80L);
        }
    }

    public int calculateTimeRemaining(AbilityType ability) {
        long deactivatedTimestamp = this.profile.getAbilityDATS(ability) * 1000L;
        return (int)((deactivatedTimestamp + (long)(PerksUtils.handleCooldownPerks(this.player, ability.getCooldown()) * 1000) - System.currentTimeMillis()) / 1000L);
    }

    private boolean hasReachedLevelCap(SkillType skill) {
        return skill.getMaxLevel() < this.getSkillLevel(skill) + 1 || Config.getInstance().getPowerLevelCap() < this.getPowerLevel() + 1;
    }

    public int getSkillLevel(SkillType skill) {
        return this.profile.getSkillLevel(skill);
    }

    public float getSkillXpLevelRaw(SkillType skill) {
        return this.profile.getSkillXpLevelRaw(skill);
    }

    public int getSkillXpLevel(SkillType skill) {
        return this.profile.getSkillXpLevel(skill);
    }

    public void setSkillXpLevel(SkillType skill, float xpLevel) {
        this.profile.setSkillXpLevel(skill, xpLevel);
    }

    public int getXpToLevel(SkillType skill) {
        return this.profile.getXpToLevel(skill);
    }

    public void removeXp(SkillType skill, int xp) {
        this.profile.removeXp(skill, xp);
    }

    public void modifySkill(SkillType skill, int level) {
        this.profile.modifySkill(skill, level);
    }

    public void addLevels(SkillType skill, int levels) {
        this.profile.addLevels(skill, levels);
    }

    public void addXp(SkillType skill, float xp) {
        this.profile.addXp(skill, xp);
    }

    public void setAbilityDATS(AbilityType ability, long DATS) {
        this.profile.setAbilityDATS(ability, DATS);
    }

    public void resetCooldowns() {
        this.profile.resetCooldowns();
    }

    public FixedMetadataValue getPlayerMetadata() {
        return this.playerMetadata;
    }

    private class ApplySuccessfulProfile
    extends BukkitRunnable {
        private final PlayerProfile profile;

        private ApplySuccessfulProfile(PlayerProfile profile) {
            this.profile = profile;
        }

        public void run() {
            McMMOPlayer.this.profile = this.profile;
        }
    }

    private class RetryProfileLoadingTask
    extends BukkitRunnable {
        private static final int MAX_TRIES = 5;
        private final String playerName;
        private int attempt;

        private RetryProfileLoadingTask() {
            this.playerName = McMMOPlayer.this.player.getName();
            this.attempt = 0;
        }

        public void run() {
            if (!McMMOPlayer.this.player.isOnline()) {
                mcMMO.p.getLogger().info("Aborting profile loading recovery for " + this.playerName + " - player logged out");
                this.cancel();
                return;
            }
            if (this.attempt == 0) {
                McMMOPlayer.this.player.sendMessage(LocaleLoader.getString("Recovery.Notice"));
            }
            ++this.attempt;
            PlayerProfile profile = mcMMO.getDatabaseManager().loadPlayerProfile(this.playerName, true);
            if (profile.isLoaded()) {
                new ApplySuccessfulProfile(profile).runTask((Plugin)mcMMO.p);
                McMMOPlayer.this.player.sendMessage(LocaleLoader.getString("Recovery.Success"));
                this.cancel();
                return;
            }
            if (this.attempt >= 5) {
                mcMMO.p.getLogger().severe("Giving up on attempting to load the PlayerProfile for " + this.playerName);
                mcMMO.p.getServer().broadcast(LocaleLoader.getString("Recovery.AdminFailureNotice", this.playerName), "bukkit.broadcast.admin");
                McMMOPlayer.this.player.sendMessage(LocaleLoader.getString("Recovery.Failure").split("\n"));
                this.cancel();
                return;
            }
        }
    }
}

