/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.metrics.mcstats;

import com.gmail.nossr50.metrics.mcstats.EMetricsPlugin;
import com.gmail.nossr50.metrics.mcstats.GraphType;
import com.gmail.nossr50.metrics.mcstats.Metrics;
import com.gmail.nossr50.metrics.mcstats.TrackerList;
import com.gmail.nossr50.metrics.mcstats.TrackerType;
import com.gmail.nossr50.metrics.mcstats.data.DataTracker;
import com.gmail.nossr50.metrics.mcstats.tracker.BasicTracker;
import com.gmail.nossr50.metrics.mcstats.tracker.EnabledTracker;
import com.gmail.nossr50.metrics.mcstats.tracker.FixedTracker;
import com.gmail.nossr50.metrics.mcstats.tracker.Tracker;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;

public class EMetrics
implements Listener {
    public static final String API_VERSION = "0.0.4";
    private boolean metricsStarted = false;
    private final Metrics metrics;
    private final TrackerList trackers = new TrackerList();
    private final Plugin plugin;
    private final HashMap<String, Metrics.Graph> graphs = new HashMap();
    static EMetrics self;

    public static EnabledTracker createEnabledTracker(String graphName, String columnName) {
        return new EnabledTracker(graphName, columnName);
    }

    public static FixedTracker createFixedTracker(String graphName, String columnName, int defaultValue) {
        return new FixedTracker(graphName, columnName, defaultValue);
    }

    public static BasicTracker createBasicTracker(String graphName, String columnName) {
        return new BasicTracker(graphName, columnName);
    }

    public static void log(String message, Plugin plugin, Level level) {
        if (message == null || plugin == null) {
            throw new IllegalArgumentException("Null arguments are bad");
        }
        Bukkit.getLogger().log(level == null ? Level.INFO : level, "[" + plugin.getName() + "] [EMetrics Debug] " + message);
    }

    public EMetrics(Plugin plugin) throws IOException {
        this(plugin, null, null);
    }

    @Deprecated
    public EMetrics(Plugin plugin, File configFile, File emetricsConfigFile) throws IOException {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin cannot be null");
        }
        this.metrics = new Metrics(plugin, configFile, emetricsConfigFile);
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
        if (self == null) {
            EMetricsPlugin emetrics = new EMetricsPlugin(plugin);
            self = new EMetrics(emetrics, plugin);
            emetrics.setupMetrics(self);
        }
    }

    EMetrics(EMetricsPlugin emetrics, Plugin host) throws IOException {
        this.metrics = new Metrics((Plugin)emetrics, null, null);
        this.plugin = emetrics;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, host);
    }

    boolean isSelf() {
        return this.plugin instanceof EMetricsPlugin;
    }

    void shutdown() {
        if (this.isSelf()) {
            this.metrics.flush();
            this.metricsStarted = false;
        }
    }

    void addPostTime(long time) {
        EMetricsPlugin plugin = (EMetricsPlugin)EMetrics.self.plugin;
        plugin.maxPOST.increment((int)time);
        plugin.minPOST.increment((int)time);
        plugin.rngPOST.increment((int)time);
    }

    void countTracker(Tracker tracker) {
        if (tracker == null || self == null) {
            return;
        }
        EMetricsPlugin plugin = (EMetricsPlugin)EMetrics.self.plugin;
        TrackerType type = TrackerType.forClass(tracker.getClass());
        plugin.trackersUsed.increment(type);
    }

    void countGraph(Metrics.Graph graph) {
        if (graph == null || self == null) {
            return;
        }
        EMetricsPlugin plugin = (EMetricsPlugin)EMetrics.self.plugin;
        GraphType type = GraphType.forClass(graph.getClass());
        plugin.graphsUsed.increment(type);
    }

    public void setReportURL(String url) throws MalformedURLException {
        try {
            URL urlObj = new URL("http://www.yoursite.com/");
            URLConnection conn = urlObj.openConnection();
            conn.connect();
            this.metrics.BASE_URL = url;
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (IOException e) {
            throw new MalformedURLException();
        }
    }

    public void addGraph(Metrics.Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph cannot be null");
        }
        if (this.metricsStarted) {
            throw new IllegalAccessError("Graph cannot be added once Metrics has started");
        }
        if (!this.isSelf()) {
            this.countGraph(graph);
        }
        this.metrics.addGraph(graph);
    }

    public void addTracker(Tracker tracker) {
        Metrics.Graph graph;
        if (tracker == null) {
            throw new IllegalArgumentException("Tracker cannot be null");
        }
        if (this.metricsStarted) {
            throw new IllegalAccessError("Tracker cannot be added once Metrics has started");
        }
        if (!tracker.hasGraph()) {
            throw new IllegalArgumentException("Cannot add a tracker that has no specified graph");
        }
        if (!this.isSelf()) {
            this.countTracker(tracker);
        }
        Metrics.Graph graph2 = graph = tracker.getGraphName() == null ? this.metrics.defaultGraph : this.graphs.get(tracker.getGraphName());
        if (graph == null) {
            graph = this.metrics.createGraph(tracker.getGraphName());
            this.graphs.put(tracker.getGraphName(), graph);
        }
        graph.addPlotter(tracker);
    }

    public boolean isOptOut() {
        return this.metrics.isOptOut();
    }

    public void startMetrics() {
        this.metricsStarted = this.metrics.start();
    }

    public boolean isMetricsStarted() {
        return this.metricsStarted;
    }

    public void setDebugMode(boolean debug) {
        this.metrics.pluginDebug = debug;
    }

    public boolean isNaturalDebug() {
        return this.metrics.naturalDebug;
    }

    public boolean isDebugMode() {
        return this.metrics.pluginDebug || this.metrics.naturalDebug;
    }

    public Tracker getTracker(String trackerName) {
        return this.trackers.getByName(trackerName);
    }

    public List<Tracker> getTrackersForGraph(String graphName) {
        return this.trackers.getTrackersForGraph(graphName);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPluginDisable(PluginDisableEvent event) {
        if (event != null && event.getPlugin().getName().equals(this.plugin.getName())) {
            this.metrics.flush();
            this.metricsStarted = false;
            if (!this.isSelf()) {
                self.shutdown();
            }
        }
    }

    public boolean isLogging() {
        return this.metrics.pluginLog || this.metrics.naturalLog;
    }

    public boolean isNaturalLogging() {
        return this.metrics.naturalLog;
    }

    public void setLogging(boolean doLogging) {
        this.metrics.pluginLog = doLogging;
    }

    @Deprecated
    public boolean setConfigFile(File file) {
        if (file != null) {
            this.metrics.configFile = file;
            return true;
        }
        return false;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public DataTracker getDataTracker() {
        return this.metrics.dataTracker;
    }

    public int getRevisionNumber() {
        return 7;
    }

    public String getReportURL() {
        return this.metrics.BASE_URL;
    }

    public int getPingInterval() {
        return Metrics.PING_INTERVAL;
    }

    public void setPingInterval(int ping) {
        if (ping < 1 || ping >= 30) {
            throw new IllegalArgumentException("Ping interval not in range. Valid range: 1 <= interval < 30");
        }
        Metrics.PING_INTERVAL = ping;
    }
}

