/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.metrics.mcstats.graph;

import com.gmail.nossr50.metrics.mcstats.Metrics;
import com.gmail.nossr50.metrics.mcstats.tracker.BasicTracker;
import com.gmail.nossr50.metrics.mcstats.tracker.LinkedTracker;
import com.gmail.nossr50.metrics.mcstats.tracker.Tracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DonutGraph<T>
extends Metrics.Graph {
    private Map<T, List<DonutSlice<T>>> slices = new HashMap<T, List<DonutSlice<T>>>();

    public DonutGraph(String name) {
        super(name);
    }

    public DonutSlice<T> addSlice(T object, String majorName, String minorName) {
        if (object == null || majorName == null || minorName == null) {
            throw new IllegalArgumentException("Null arguments are not allowed");
        }
        DonutSlice<T> slice = new DonutSlice<T>(object, majorName, minorName);
        ArrayList<DonutSlice<T>> list = new ArrayList<DonutSlice<T>>();
        list.add(slice);
        if (this.slices.containsKey(object)) {
            list.addAll((Collection)this.slices.get(object));
        }
        this.slices.put(object, list);
        this.addPlotter(((DonutSlice)slice).tracker);
        return slice;
    }

    public void removeSlice(T object) {
        if (object == null) {
            throw new IllegalArgumentException("Null arguments are not allowed");
        }
        List<DonutSlice<T>> last = this.slices.remove(object);
        if (last != null) {
            for (DonutSlice<T> slice : last) {
                this.removePlotter(((DonutSlice)slice).tracker);
            }
        }
    }

    public void removeSlice(String majorName, String minorName) {
        if (majorName == null || minorName == null) {
            throw new IllegalArgumentException("Null arguments are not allowed");
        }
        for (T object : this.slices.keySet()) {
            List<DonutSlice<T>> list = this.slices.get(object);
            if (list == null) continue;
            ArrayList<DonutSlice<T>> keep = new ArrayList<DonutSlice<T>>();
            for (DonutSlice<T> slice : list) {
                if (((DonutSlice)slice).majorName.equalsIgnoreCase(majorName) && ((DonutSlice)slice).minorName.equalsIgnoreCase(minorName)) {
                    this.removePlotter(((DonutSlice)slice).tracker);
                    continue;
                }
                keep.add(slice);
            }
            if (list.size() == keep.size()) continue;
            this.slices.put(object, keep);
            return;
        }
    }

    public DonutSlice<T> getSlice(String majorName, String minorName) {
        if (majorName == null || minorName == null) {
            throw new IllegalArgumentException("Null arguments are not allowed");
        }
        for (T object : this.slices.keySet()) {
            List<DonutSlice<T>> list = this.slices.get(object);
            if (list == null) continue;
            for (DonutSlice<T> slice : list) {
                if (slice == null) {
                    throw new IllegalArgumentException("Null slice found. Did you add the type?");
                }
                if (!((DonutSlice)slice).majorName.equalsIgnoreCase(majorName) || !((DonutSlice)slice).minorName.equalsIgnoreCase(minorName)) continue;
                return slice;
            }
        }
        return null;
    }

    public DonutSlice<T> getSlice(T object, String minorName) {
        if (object == null || minorName == null) {
            throw new IllegalArgumentException("Null arguments are not allowed");
        }
        List<DonutSlice<T>> list = this.slices.get(object);
        if (list != null) {
            for (DonutSlice<T> slice : list) {
                if (slice == null) {
                    throw new IllegalArgumentException("Null slice found. Did you add the type?");
                }
                if (!((DonutSlice)slice).minorName.equalsIgnoreCase(minorName)) continue;
                return slice;
            }
        }
        return null;
    }

    public void increment(String majorName, String minorName) {
        if (majorName == null || minorName == null) {
            throw new IllegalArgumentException("Null arguments are not allowed");
        }
        DonutSlice<String> slice = this.getSlice((T)majorName, minorName);
        if (slice == null) {
            throw new IllegalArgumentException("Null slice found. Did you add the type?");
        }
        ((DonutSlice)slice).tracker.increment();
    }

    public void increment(T object, String minorName) {
        if (object == null || minorName == null) {
            throw new IllegalArgumentException("Null arguments are not allowed");
        }
        DonutSlice<T> slice = this.getSlice(object, minorName);
        if (slice == null) {
            throw new IllegalArgumentException("Null slice found. Did you add the type?");
        }
        ((DonutSlice)slice).tracker.increment();
    }

    public static class DonutSlice<T> {
        private LinkedTracker tracker;
        private T object;
        private String majorName;
        private String minorName;

        DonutSlice(T object, String majorName, String minorName) {
            this.tracker = new LinkedTracker(majorName + "~=~" + minorName, new BasicTracker("", majorName + "~=~" + minorName));
            this.object = object;
            this.majorName = majorName;
            this.minorName = minorName;
        }

        public String getMajorName() {
            return this.majorName;
        }

        public String getMinorName() {
            return this.minorName;
        }

        public void convertTracker(Tracker tracker) {
            if (tracker == null) {
                throw new IllegalArgumentException("Cannot convert null trackers");
            }
            tracker.setValue(this.tracker.getValue());
            this.tracker.setLink(tracker);
        }

        public void replaceTracker(Tracker tracker) {
            if (tracker == null) {
                throw new IllegalArgumentException("Cannot replace null trackers");
            }
            this.tracker.setLink(tracker);
        }

        public T getObject() {
            return this.object;
        }
    }
}

