/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.commands;

import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.commands.McrankCommandDisplayTask;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class McrankCommandAsyncTask
extends BukkitRunnable {
    private final String playerName;
    private final CommandSender sender;
    private final boolean useBoard;
    private final boolean useChat;

    public McrankCommandAsyncTask(String playerName, CommandSender sender, boolean useBoard, boolean useChat) {
        Validate.isTrue((useBoard || useChat ? 1 : 0) != 0, (String)"Attempted to start a rank retrieval with both board and chat off");
        Validate.notNull((Object)sender, (String)"Attempted to start a rank retrieval with no recipient");
        if (useBoard) {
            Validate.isTrue((boolean)(sender instanceof Player), (String)"Attempted to start a rank retrieval displaying scoreboard to a non-player");
        }
        this.playerName = playerName;
        this.sender = sender;
        this.useBoard = useBoard;
        this.useChat = useChat;
    }

    public void run() {
        Map<SkillType, Integer> skills = mcMMO.getDatabaseManager().readRank(this.playerName);
        new McrankCommandDisplayTask(skills, this.sender, this.playerName, this.useBoard, this.useChat).runTaskLater((Plugin)mcMMO.p, 1L);
    }
}

