/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.alchemy;

import com.gmail.nossr50.config.skills.alchemy.PotionConfig;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.alchemy.AlchemyPotion;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.PlayerUpdateInventoryTask;
import com.gmail.nossr50.runnables.skills.AlchemyBrewCheckTask;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public final class AlchemyPotionBrewer {
    public static boolean isValidBrew(Player player, ItemStack[] contents) {
        if (!AlchemyPotionBrewer.isValidIngredient(player, contents[3])) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (contents[i] == null || contents[i].getType() != Material.POTION || AlchemyPotionBrewer.getChildPotion(PotionConfig.getInstance().getPotion(contents[i].getDurability()), contents[3]) == null) continue;
            return true;
        }
        return false;
    }

    private static AlchemyPotion getChildPotion(AlchemyPotion potion, ItemStack ingredient) {
        if (potion != null && potion.getChildDataValue(ingredient) != -1) {
            return PotionConfig.getInstance().getPotion(potion.getChildDataValue(ingredient));
        }
        return null;
    }

    public static boolean isEmpty(ItemStack item) {
        return item == null || item.getType() == Material.AIR || item.getAmount() == 0;
    }

    private static boolean removeIngredient(BrewerInventory inventory, Player player) {
        ItemStack ingredient;
        ItemStack itemStack = ingredient = inventory.getIngredient() == null ? null : inventory.getIngredient().clone();
        if (AlchemyPotionBrewer.isEmpty(ingredient) || !AlchemyPotionBrewer.isValidIngredient(player, ingredient)) {
            return false;
        }
        if (ingredient.getAmount() <= 1) {
            inventory.setIngredient(null);
            return true;
        }
        ingredient.setAmount(ingredient.getAmount() - 1);
        inventory.setIngredient(ingredient);
        return true;
    }

    public static boolean isValidIngredient(Player player, ItemStack item) {
        if (AlchemyPotionBrewer.isEmpty(item)) {
            return false;
        }
        for (ItemStack ingredient : AlchemyPotionBrewer.getValidIngredients(player)) {
            if (!item.isSimilar(ingredient)) continue;
            return true;
        }
        return false;
    }

    private static List<ItemStack> getValidIngredients(Player player) {
        return PotionConfig.getInstance().getIngredients(player == null || !Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.CONCOCTIONS) ? 1 : UserManager.getPlayer(player).getAlchemyManager().getTier());
    }

    public static void finishBrewing(BlockState brewingStand, Player player, boolean forced) {
        ItemStack ingredient;
        if (!(brewingStand instanceof BrewingStand)) {
            return;
        }
        BrewerInventory inventory = ((BrewingStand)brewingStand).getInventory();
        ItemStack itemStack = ingredient = inventory.getIngredient() == null ? null : inventory.getIngredient().clone();
        if (!AlchemyPotionBrewer.removeIngredient(inventory, player)) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack item = inventory.getItem(i);
            if (AlchemyPotionBrewer.isEmpty(item) || item.getType() == Material.GLASS_BOTTLE || !PotionConfig.getInstance().isValidPotion(item)) continue;
            AlchemyPotion input = PotionConfig.getInstance().getPotion(item.getDurability());
            AlchemyPotion output = PotionConfig.getInstance().getPotion(input.getChildDataValue(ingredient));
            if (output == null) continue;
            inventory.setItem(i, output.toItemStack(item.getAmount()).clone());
            if (player == null) continue;
            UserManager.getPlayer(player).getAlchemyManager().handlePotionBrewSuccesses(1);
        }
        if (!forced) {
            AlchemyPotionBrewer.scheduleUpdate((Inventory)inventory);
        }
    }

    public static boolean transferItems(InventoryView view, int fromSlot, ClickType click) {
        boolean success = false;
        if (click.isLeftClick()) {
            success = AlchemyPotionBrewer.transferItems(view, fromSlot);
        } else if (click.isRightClick()) {
            success = AlchemyPotionBrewer.transferOneItem(view, fromSlot);
        }
        return success;
    }

    private static boolean transferOneItem(InventoryView view, int fromSlot) {
        ItemStack from = view.getItem(fromSlot).clone();
        ItemStack to = view.getItem(3).clone();
        if (AlchemyPotionBrewer.isEmpty(from)) {
            return false;
        }
        boolean emptyTo = AlchemyPotionBrewer.isEmpty(to);
        int fromAmount = from.getAmount();
        if (!emptyTo && fromAmount >= from.getType().getMaxStackSize()) {
            return false;
        }
        if (emptyTo || from.isSimilar(to)) {
            if (emptyTo) {
                to = from.clone();
                to.setAmount(1);
            } else {
                to.setAmount(to.getAmount() + 1);
            }
            from.setAmount(fromAmount - 1);
            view.setItem(3, to);
            view.setItem(fromSlot, from);
            return true;
        }
        return false;
    }

    private static boolean transferItems(InventoryView view, int fromSlot) {
        ItemStack from = view.getItem(fromSlot).clone();
        ItemStack to = view.getItem(3).clone();
        if (AlchemyPotionBrewer.isEmpty(from)) {
            return false;
        }
        if (AlchemyPotionBrewer.isEmpty(to)) {
            view.setItem(3, from);
            view.setItem(fromSlot, null);
            return true;
        }
        if (from.isSimilar(to)) {
            int maxSize;
            int toAmount;
            int fromAmount = from.getAmount();
            if (fromAmount + (toAmount = to.getAmount()) > (maxSize = to.getType().getMaxStackSize())) {
                int left = fromAmount + toAmount - maxSize;
                to.setAmount(maxSize);
                view.setItem(3, to);
                from.setAmount(left);
                view.setItem(fromSlot, from);
                return true;
            }
            to.setAmount(fromAmount + toAmount);
            view.setItem(fromSlot, null);
            view.setItem(3, to);
            return true;
        }
        return false;
    }

    public static void scheduleCheck(Player player, BrewingStand brewingStand) {
        new AlchemyBrewCheckTask(player, brewingStand).runTask((Plugin)mcMMO.p);
    }

    public static void scheduleUpdate(Inventory inventory) {
        for (HumanEntity humanEntity : inventory.getViewers()) {
            if (!(humanEntity instanceof Player)) continue;
            new PlayerUpdateInventoryTask((Player)humanEntity).runTask((Plugin)mcMMO.p);
        }
    }
}

