/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.child;

import com.gmail.nossr50.config.AutoUpdateConfigLoader;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.skills.child.FamilyTree;
import com.gmail.nossr50.util.StringUtils;
import java.io.InputStream;
import java.util.EnumSet;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ChildConfig
extends AutoUpdateConfigLoader {
    public ChildConfig() {
        super("child.yml");
        this.loadKeys();
    }

    @Override
    protected void loadKeys() {
        this.config.setDefaults((Configuration)YamlConfiguration.loadConfiguration((InputStream)plugin.getResource("child.yml")));
        FamilyTree.clearRegistrations();
        for (SkillType skill : SkillType.CHILD_SKILLS) {
            plugin.debug("Finding parents of " + skill.name());
            EnumSet<SkillType> parentSkills = EnumSet.noneOf(SkillType.class);
            boolean useDefaults = false;
            for (String name : this.config.getStringList(StringUtils.getCapitalized(skill.name()))) {
                try {
                    SkillType parentSkill = SkillType.valueOf(name.toUpperCase());
                    FamilyTree.enforceNotChildSkill(parentSkill);
                    parentSkills.add(parentSkill);
                }
                catch (IllegalArgumentException ex) {
                    plugin.getLogger().warning(name + " is not a valid skill type, or is a child skill!");
                    useDefaults = true;
                    break;
                }
            }
            if (useDefaults) {
                parentSkills.clear();
                for (String name : this.config.getDefaults().getStringList(StringUtils.getCapitalized(skill.name()))) {
                    parentSkills.add(SkillType.valueOf(name.toUpperCase()));
                }
            }
            for (SkillType parentSkill : parentSkills) {
                plugin.debug("Registering " + parentSkill.name() + " as parent of " + skill.name());
                FamilyTree.registerParent(skill, parentSkill);
            }
        }
        FamilyTree.closeRegistration();
    }
}

