/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.child;

import com.gmail.nossr50.datatypes.skills.SkillType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;

public class FamilyTree {
    private static HashMap<SkillType, Set<SkillType>> tree = new HashMap();

    public static Set<SkillType> getParents(SkillType childSkill) {
        FamilyTree.enforceChildSkill(childSkill);
        return tree.get((Object)childSkill);
    }

    protected static void registerParent(SkillType childSkill, SkillType parentSkill) {
        FamilyTree.enforceChildSkill(childSkill);
        FamilyTree.enforceNotChildSkill(parentSkill);
        if (!tree.containsKey((Object)childSkill)) {
            tree.put(childSkill, EnumSet.noneOf(SkillType.class));
        }
        tree.get((Object)childSkill).add(parentSkill);
    }

    protected static void closeRegistration() {
        for (SkillType childSkill : tree.keySet()) {
            Set<SkillType> immutableSet = Collections.unmodifiableSet(tree.get((Object)childSkill));
            tree.put(childSkill, immutableSet);
        }
    }

    protected static void clearRegistrations() {
        tree.clear();
    }

    protected static void enforceChildSkill(SkillType skill) {
        if (!skill.isChildSkill()) {
            throw new IllegalArgumentException(skill.name() + " is not a child skill!");
        }
    }

    protected static void enforceNotChildSkill(SkillType skill) {
        if (skill.isChildSkill()) {
            throw new IllegalArgumentException(skill.name() + " is a child skill!");
        }
    }
}

