/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.mining;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.AbilityCooldownTask;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.mining.BlastMining;
import com.gmail.nossr50.skills.mining.Mining;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class MiningManager
extends SkillManager {
    public MiningManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, SkillType.MINING);
    }

    public boolean canUseDemolitionsExpertise() {
        return this.getSkillLevel() >= BlastMining.Tier.FOUR.getLevel() && Permissions.demolitionsExpertise((Permissible)this.getPlayer());
    }

    public boolean canDetonate() {
        Player player = this.getPlayer();
        return this.canUseBlastMining() && player.isSneaking() && player.getItemInHand().getType() == BlastMining.detonator && Permissions.remoteDetonation((Permissible)player);
    }

    public boolean canUseBlastMining() {
        return this.getSkillLevel() >= BlastMining.Tier.ONE.getLevel();
    }

    public boolean canUseBiggerBombs() {
        return this.getSkillLevel() >= BlastMining.Tier.TWO.getLevel() && Permissions.biggerBombs((Permissible)this.getPlayer());
    }

    public void miningBlockCheck(BlockState blockState) {
        int i;
        Player player = this.getPlayer();
        this.applyXpGain(Mining.getBlockXp(blockState));
        if (!Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.MINING_DOUBLE_DROPS)) {
            return;
        }
        Material material = blockState.getType();
        if (this.mcMMOPlayer.getAbilityMode(this.skill.getAbility())) {
            SkillUtils.handleDurabilityChange(this.getPlayer().getItemInHand(), Config.getInstance().getAbilityToolDamage());
        }
        if (mcMMO.getModManager().isCustomMiningBlock(blockState) && !mcMMO.getModManager().getBlock(blockState).isDoubleDropEnabled() || material != Material.GLOWING_REDSTONE_ORE && !Config.getInstance().getDoubleDropsEnabled(this.skill, material)) {
            return;
        }
        boolean silkTouch = player.getItemInHand().containsEnchantment(Enchantment.SILK_TOUCH);
        int n = i = this.mcMMOPlayer.getAbilityMode(this.skill.getAbility()) ? 2 : 1;
        while (i != 0) {
            if (SkillUtils.activationSuccessful(SecondaryAbility.MINING_DOUBLE_DROPS, this.getPlayer(), this.getSkillLevel(), this.activationChance)) {
                if (silkTouch) {
                    Mining.handleSilkTouchDrops(blockState);
                } else {
                    Mining.handleMiningDrops(blockState);
                }
            }
            --i;
        }
    }

    public void remoteDetonation() {
        Player player = this.getPlayer();
        Block targetBlock = player.getTargetBlock(BlockUtils.getTransparentBlocks(), 100);
        if (targetBlock.getType() != Material.TNT || !EventUtils.simulateBlockBreak(targetBlock, player, true) || !this.blastMiningCooldownOver()) {
            return;
        }
        TNTPrimed tnt = (TNTPrimed)player.getWorld().spawn(targetBlock.getLocation(), TNTPrimed.class);
        SkillUtils.sendSkillMessage(player, AbilityType.BLAST_MINING.getAbilityPlayer(player));
        player.sendMessage(LocaleLoader.getString("Mining.Blast.Boom"));
        tnt.setMetadata("mcMMO: Tracked TNT", (MetadataValue)this.mcMMOPlayer.getPlayerMetadata());
        tnt.setFuseTicks(0);
        targetBlock.setType(Material.AIR);
        this.mcMMOPlayer.setAbilityDATS(AbilityType.BLAST_MINING, System.currentTimeMillis());
        this.mcMMOPlayer.setAbilityInformed(AbilityType.BLAST_MINING, false);
        new AbilityCooldownTask(this.mcMMOPlayer, AbilityType.BLAST_MINING).runTaskLaterAsynchronously((Plugin)mcMMO.p, AbilityType.BLAST_MINING.getCooldown() * 20);
    }

    public void blastMiningDropProcessing(float yield, List<Block> blockList) {
        ArrayList<BlockState> ores = new ArrayList<BlockState>();
        ArrayList<BlockState> debris = new ArrayList<BlockState>();
        int xp = 0;
        float oreBonus = (float)(this.getOreBonus() / 100.0);
        float debrisReduction = (float)(this.getDebrisReduction() / 100.0);
        int dropMultiplier = this.getDropMultiplier();
        float debrisYield = yield - debrisReduction;
        for (Block block : blockList) {
            BlockState blockState = block.getState();
            if (BlockUtils.isOre(blockState)) {
                ores.add(blockState);
                continue;
            }
            debris.add(blockState);
        }
        for (BlockState blockState : ores) {
            if (!(Misc.getRandom().nextFloat() < yield + oreBonus)) continue;
            if (!mcMMO.getPlaceStore().isTrue(blockState)) {
                xp += Mining.getBlockXp(blockState);
            }
            Misc.dropItem(blockState.getLocation(), blockState.getData().toItemStack(1));
            if (mcMMO.getPlaceStore().isTrue(blockState)) continue;
            for (int i = 1; i < dropMultiplier; ++i) {
                Mining.handleSilkTouchDrops(blockState);
            }
        }
        if (debrisYield > 0.0f) {
            for (BlockState blockState : debris) {
                if (!(Misc.getRandom().nextFloat() < debrisYield)) continue;
                Misc.dropItems(blockState.getLocation(), blockState.getBlock().getDrops());
            }
        }
        this.applyXpGain(xp);
    }

    public float biggerBombs(float radius) {
        return (float)((double)radius + this.getBlastRadiusModifier());
    }

    public double processDemolitionsExpertise(double damage) {
        return damage * ((100.0 - this.getBlastDamageModifier()) / 100.0);
    }

    public int getBlastMiningTier() {
        int skillLevel = this.getSkillLevel();
        for (BlastMining.Tier tier : BlastMining.Tier.values()) {
            if (skillLevel < tier.getLevel()) continue;
            return tier.toNumerical();
        }
        return 0;
    }

    public double getOreBonus() {
        int skillLevel = this.getSkillLevel();
        for (BlastMining.Tier tier : BlastMining.Tier.values()) {
            if (skillLevel < tier.getLevel()) continue;
            return tier.getOreBonus();
        }
        return 0.0;
    }

    public double getDebrisReduction() {
        int skillLevel = this.getSkillLevel();
        for (BlastMining.Tier tier : BlastMining.Tier.values()) {
            if (skillLevel < tier.getLevel()) continue;
            return tier.getDebrisReduction();
        }
        return 0.0;
    }

    public int getDropMultiplier() {
        int skillLevel = this.getSkillLevel();
        for (BlastMining.Tier tier : BlastMining.Tier.values()) {
            if (skillLevel < tier.getLevel()) continue;
            return tier.getDropMultiplier();
        }
        return 0;
    }

    public double getBlastRadiusModifier() {
        int skillLevel = this.getSkillLevel();
        for (BlastMining.Tier tier : BlastMining.Tier.values()) {
            if (skillLevel < tier.getLevel()) continue;
            return tier.getBlastRadiusModifier();
        }
        return 0.0;
    }

    public double getBlastDamageModifier() {
        int skillLevel = this.getSkillLevel();
        for (BlastMining.Tier tier : BlastMining.Tier.values()) {
            if (skillLevel < tier.getLevel()) continue;
            return tier.getBlastDamageDecrease();
        }
        return 0.0;
    }

    private boolean blastMiningCooldownOver() {
        int timeRemaining = this.mcMMOPlayer.calculateTimeRemaining(AbilityType.BLAST_MINING);
        if (timeRemaining > 0) {
            this.getPlayer().sendMessage(LocaleLoader.getString("Skills.TooTired", timeRemaining));
            return false;
        }
        return true;
    }
}

