/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.woodcutting;

import com.gmail.nossr50.datatypes.mods.CustomBlock;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.woodcutting.Woodcutting;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Tree;
import org.bukkit.permissions.Permissible;

public class WoodcuttingManager
extends SkillManager {
    public WoodcuttingManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, SkillType.WOODCUTTING);
    }

    public boolean canUseLeafBlower(ItemStack heldItem) {
        return Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.LEAF_BLOWER) && this.getSkillLevel() >= Woodcutting.leafBlowerUnlockLevel && ItemUtils.isAxe(heldItem);
    }

    public boolean canUseTreeFeller(ItemStack heldItem) {
        return this.mcMMOPlayer.getAbilityMode(AbilityType.TREE_FELLER) && Permissions.treeFeller((Permissible)this.getPlayer()) && ItemUtils.isAxe(heldItem);
    }

    protected boolean canGetDoubleDrops() {
        return Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.WOODCUTTING_DOUBLE_DROPS) && SkillUtils.activationSuccessful(SecondaryAbility.WOODCUTTING_DOUBLE_DROPS, this.getPlayer(), this.getSkillLevel(), this.activationChance);
    }

    public void woodcuttingBlockCheck(BlockState blockState) {
        int xp = Woodcutting.getExperienceFromLog(blockState, Woodcutting.ExperienceGainMethod.DEFAULT);
        switch (blockState.getType()) {
            case HUGE_MUSHROOM_1: 
            case HUGE_MUSHROOM_2: {
                break;
            }
            default: {
                if (!this.canGetDoubleDrops()) break;
                Woodcutting.checkForDoubleDrop(blockState);
            }
        }
        this.applyXpGain(xp);
    }

    public void processTreeFeller(BlockState blockState) {
        Player player = this.getPlayer();
        HashSet<BlockState> treeFellerBlocks = new HashSet<BlockState>();
        Woodcutting.treeFellerReachedThreshold = false;
        Woodcutting.processTree(blockState, treeFellerBlocks);
        if (Woodcutting.treeFellerReachedThreshold) {
            Woodcutting.treeFellerReachedThreshold = false;
            player.sendMessage(LocaleLoader.getString("Woodcutting.Skills.TreeFellerThreshold"));
            return;
        }
        if (!Woodcutting.handleDurabilityLoss(treeFellerBlocks, player.getItemInHand())) {
            player.sendMessage(LocaleLoader.getString("Woodcutting.Skills.TreeFeller.Splinter"));
            double health = player.getHealth();
            if (health > 1.0) {
                CombatUtils.dealDamage((LivingEntity)player, Misc.getRandom().nextInt((int)(health - 1.0)));
            }
            return;
        }
        this.dropBlocks(treeFellerBlocks);
        Woodcutting.treeFellerReachedThreshold = false;
    }

    private void dropBlocks(Set<BlockState> treeFellerBlocks) {
        BlockState blockState;
        Block block;
        Player player = this.getPlayer();
        int xp = 0;
        Iterator<BlockState> i$ = treeFellerBlocks.iterator();
        while (i$.hasNext() && EventUtils.simulateBlockBreak(block = (blockState = i$.next()).getBlock(), player, true)) {
            Material material = blockState.getType();
            if (material == Material.HUGE_MUSHROOM_1 || material == Material.HUGE_MUSHROOM_2) {
                xp += Woodcutting.getExperienceFromLog(blockState, Woodcutting.ExperienceGainMethod.TREE_FELLER);
                Misc.dropItems(blockState.getLocation(), block.getDrops());
            } else if (mcMMO.getModManager().isCustomLog(blockState)) {
                if (this.canGetDoubleDrops()) {
                    Woodcutting.checkForDoubleDrop(blockState);
                }
                CustomBlock customBlock = mcMMO.getModManager().getBlock(blockState);
                xp = customBlock.getXpGain();
                Misc.dropItems(blockState.getLocation(), block.getDrops());
            } else if (mcMMO.getModManager().isCustomLeaf(blockState)) {
                Misc.dropItems(blockState.getLocation(), block.getDrops());
            } else {
                if (blockState.getData() instanceof Tree) {
                    Tree tree = (Tree)blockState.getData();
                    tree.setDirection(BlockFace.UP);
                }
                switch (material) {
                    case LOG: 
                    case LOG_2: {
                        if (this.canGetDoubleDrops()) {
                            Woodcutting.checkForDoubleDrop(blockState);
                        }
                        xp += Woodcutting.getExperienceFromLog(blockState, Woodcutting.ExperienceGainMethod.TREE_FELLER);
                        Misc.dropItems(blockState.getLocation(), block.getDrops());
                        break;
                    }
                    case LEAVES: 
                    case LEAVES_2: {
                        Misc.dropItems(blockState.getLocation(), block.getDrops());
                        break;
                    }
                }
            }
            blockState.setType(Material.AIR);
            blockState.update(true);
        }
        this.applyXpGain(xp);
    }
}

