/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.MobHealthbarType;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.MobHealthDisplayUpdaterTask;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.ChatColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public final class MobHealthbarUtils {
    private MobHealthbarUtils() {
    }

    public static String fixDeathMessage(String deathMessage, Player player) {
        EntityDamageEvent lastDamageCause = player.getLastDamageCause();
        String replaceString = lastDamageCause instanceof EntityDamageByEntityEvent ? StringUtils.getPrettyEntityTypeString(((EntityDamageByEntityEvent)lastDamageCause).getDamager().getType()) : "a mob";
        return deathMessage.replaceAll("(?:\u00a7(?:[0-9A-FK-ORa-fk-or]){1}(?:[\u2764\u25a0]{1,10})){1,2}", replaceString);
    }

    public static void handleMobHealthbars(Player player, LivingEntity target, double damage) {
        if (mcMMO.isHealthBarPluginEnabled() || !Permissions.mobHealthDisplay((Permissible)player)) {
            return;
        }
        if (MobHealthbarUtils.isBoss(target)) {
            return;
        }
        PlayerProfile profile = UserManager.getPlayer(player).getProfile();
        if (profile.getMobHealthbarType() == null) {
            profile.setMobHealthbarType(Config.getInstance().getMobHealthbarDefault());
        }
        if (profile.getMobHealthbarType() == MobHealthbarType.DISABLED) {
            return;
        }
        String oldName = target.getCustomName();
        if (oldName == null) {
            oldName = "";
        } else if (oldName.equalsIgnoreCase(AdvancedConfig.getInstance().getKrakenName())) {
            return;
        }
        boolean oldNameVisible = target.isCustomNameVisible();
        String newName = MobHealthbarUtils.createHealthDisplay(profile, target, damage);
        target.setCustomName(newName);
        target.setCustomNameVisible(true);
        int displayTime = Config.getInstance().getMobHealthbarTime();
        if (displayTime != -1) {
            boolean updateName;
            boolean bl = updateName = !ChatColor.stripColor((String)oldName).equalsIgnoreCase(ChatColor.stripColor((String)newName));
            if (updateName) {
                target.setMetadata("mcMMO: Custom Name", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)oldName));
                target.setMetadata("mcMMO: Name Visibility", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)oldNameVisible));
            } else if (!target.hasMetadata("mcMMO: Custom Name")) {
                target.setMetadata("mcMMO: Custom Name", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)""));
                target.setMetadata("mcMMO: Name Visibility", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)false));
            }
            new MobHealthDisplayUpdaterTask(target).runTaskLater((Plugin)mcMMO.p, displayTime * 20);
        }
    }

    private static String createHealthDisplay(PlayerProfile profile, LivingEntity entity, double damage) {
        int i;
        String symbol;
        int fullDisplay;
        double maxHealth = entity.getMaxHealth();
        double currentHealth = Math.max(entity.getHealth() - damage, 0.0);
        double healthPercentage = currentHealth / maxHealth * 100.0;
        ChatColor color = ChatColor.BLACK;
        switch (profile.getMobHealthbarType()) {
            case HEARTS: {
                fullDisplay = Math.min((int)(maxHealth / 2.0), 10);
                color = ChatColor.DARK_RED;
                symbol = "\u2764";
                break;
            }
            case BAR: {
                fullDisplay = 10;
                if (healthPercentage >= 85.0) {
                    color = ChatColor.DARK_GREEN;
                } else if (healthPercentage >= 70.0) {
                    color = ChatColor.GREEN;
                } else if (healthPercentage >= 55.0) {
                    color = ChatColor.GOLD;
                } else if (healthPercentage >= 40.0) {
                    color = ChatColor.YELLOW;
                } else if (healthPercentage >= 25.0) {
                    color = ChatColor.RED;
                } else if (healthPercentage >= 0.0) {
                    color = ChatColor.DARK_RED;
                }
                symbol = "\u25a0";
                break;
            }
            default: {
                return null;
            }
        }
        int coloredDisplay = (int)Math.ceil((double)fullDisplay * (healthPercentage / 100.0));
        int grayDisplay = fullDisplay - coloredDisplay;
        String healthbar = color + "";
        for (i = 0; i < coloredDisplay; ++i) {
            healthbar = healthbar + symbol;
        }
        healthbar = healthbar + ChatColor.GRAY;
        for (i = 0; i < grayDisplay; ++i) {
            healthbar = healthbar + symbol;
        }
        return healthbar;
    }

    private static boolean isBoss(LivingEntity livingEntity) {
        switch (livingEntity.getType()) {
            case ENDER_DRAGON: 
            case WITHER: {
                return true;
            }
        }
        return false;
    }
}

