/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.experience;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.mcMMO;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;

public class FormulaManager {
    private static File formulaFile = new File(mcMMO.getFlatFileDirectory() + "formula.yml");
    private final Map<Integer, Integer> experienceNeededLinear = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> experienceNeededExponential = new HashMap<Integer, Integer>();
    private FormulaType previousFormula;

    public FormulaManager() {
        this.loadFormula();
    }

    public FormulaType getPreviousFormulaType() {
        return this.previousFormula;
    }

    public void setPreviousFormulaType(FormulaType previousFormulaType) {
        this.previousFormula = previousFormulaType;
    }

    public int calculateTotalExperience(int skillLevel, int skillXPLevel) {
        int totalXP = 0;
        for (int level = 0; level < skillLevel; ++level) {
            totalXP += this.getCachedXpToLevel(level, this.previousFormula);
        }
        return totalXP += skillXPLevel;
    }

    public int[] calculateNewLevel(SkillType skillType, int experience, FormulaType formulaType) {
        int experienceToNextLevel;
        int newLevel;
        int remainder = 0;
        int maxLevel = Config.getInstance().getLevelCap(skillType);
        for (newLevel = 0; experience > 0 && newLevel < maxLevel; ++newLevel, experience -= experienceToNextLevel) {
            experienceToNextLevel = this.getCachedXpToLevel(newLevel, formulaType);
            if (experience - experienceToNextLevel >= 0) continue;
            remainder = experience;
            break;
        }
        return new int[]{newLevel, remainder};
    }

    public int getCachedXpToLevel(int level, FormulaType formulaType) {
        if (formulaType == FormulaType.UNKNOWN) {
            formulaType = FormulaType.LINEAR;
        }
        int base = ExperienceConfig.getInstance().getBase(formulaType);
        double multiplier = ExperienceConfig.getInstance().getMultiplier(formulaType);
        double exponent = ExperienceConfig.getInstance().getExponent(formulaType);
        switch (formulaType) {
            case LINEAR: {
                if (!this.experienceNeededLinear.containsKey(level)) {
                    int experience = (int)Math.floor((double)base + (double)level * multiplier);
                    this.experienceNeededLinear.put(level, experience);
                }
                return this.experienceNeededLinear.get(level);
            }
            case EXPONENTIAL: {
                if (!this.experienceNeededExponential.containsKey(level)) {
                    int experience = (int)Math.floor(multiplier * Math.pow(level, exponent) + (double)base);
                    this.experienceNeededExponential.put(level, experience);
                }
                return this.experienceNeededExponential.get(level);
            }
        }
        return 0;
    }

    public void loadFormula() {
        if (!formulaFile.exists()) {
            this.previousFormula = FormulaType.UNKNOWN;
            return;
        }
        this.previousFormula = FormulaType.getFormulaType(YamlConfiguration.loadConfiguration((File)formulaFile).getString("Previous_Formula", "UNKNOWN"));
    }

    public void saveFormula() {
        mcMMO.p.debug("Saving previous XP formula type...");
        YamlConfiguration formulasFile = new YamlConfiguration();
        formulasFile.set("Previous_Formula", (Object)this.previousFormula.toString());
        try {
            formulasFile.save(formulaFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

