/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.api;

import com.gmail.nossr50.api.exceptions.InvalidPlayerException;
import com.gmail.nossr50.api.exceptions.InvalidSkillException;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.child.FamilyTree;
import com.gmail.nossr50.util.player.UserManager;
import java.util.Set;
import org.bukkit.entity.Player;

public final class ExperienceAPI {
    private ExperienceAPI() {
    }

    public static boolean isValidSkillType(String skillType) {
        return SkillType.getSkill(skillType) != null;
    }

    public static boolean isNonChildSkill(String skillType) {
        SkillType skill = SkillType.getSkill(skillType);
        return skill != null && !skill.isChildSkill();
    }

    @Deprecated
    public static void addRawXP(Player player, String skillType, int XP) {
        ExperienceAPI.addRawXP(player, skillType, (float)XP);
    }

    public static void addRawXP(Player player, String skillType, float XP) {
        UserManager.getPlayer(player).applyXpGain(ExperienceAPI.getSkillType(skillType), XP);
    }

    @Deprecated
    public static void addRawXPOffline(String playerName, String skillType, int XP) {
        ExperienceAPI.addRawXPOffline(playerName, skillType, (float)XP);
    }

    public static void addRawXPOffline(String playerName, String skillType, float XP) {
        ExperienceAPI.addOfflineXP(playerName, ExperienceAPI.getSkillType(skillType), (int)Math.floor(XP));
    }

    public static void addMultipliedXP(Player player, String skillType, int XP) {
        UserManager.getPlayer(player).applyXpGain(ExperienceAPI.getSkillType(skillType), (int)((double)XP * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()));
    }

    public static void addMultipliedXPOffline(String playerName, String skillType, int XP) {
        ExperienceAPI.addOfflineXP(playerName, ExperienceAPI.getSkillType(skillType), (int)((double)XP * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()));
    }

    public static void addModifiedXP(Player player, String skillType, int XP) {
        SkillType skill = ExperienceAPI.getSkillType(skillType);
        UserManager.getPlayer(player).applyXpGain(skill, (int)((double)XP / skill.getXpModifier() * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()));
    }

    public static void addModifiedXPOffline(String playerName, String skillType, int XP) {
        SkillType skill = ExperienceAPI.getSkillType(skillType);
        ExperienceAPI.addOfflineXP(playerName, skill, (int)((double)XP / skill.getXpModifier() * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()));
    }

    public static void addXP(Player player, String skillType, int XP) {
        UserManager.getPlayer(player).beginXpGain(ExperienceAPI.getSkillType(skillType), XP);
    }

    public static int getXP(Player player, String skillType) {
        return UserManager.getPlayer(player).getSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static int getOfflineXP(String playerName, String skillType) {
        return ExperienceAPI.getOfflineProfile(playerName).getSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static float getXPRaw(Player player, String skillType) {
        return UserManager.getPlayer(player).getSkillXpLevelRaw(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static float getOfflineXPRaw(String playerName, String skillType) {
        return ExperienceAPI.getOfflineProfile(playerName).getSkillXpLevelRaw(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static int getXPToNextLevel(Player player, String skillType) {
        return UserManager.getPlayer(player).getXpToLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static int getOfflineXPToNextLevel(String playerName, String skillType) {
        return ExperienceAPI.getOfflineProfile(playerName).getXpToLevel(ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static int getXPRemaining(Player player, String skillType) {
        SkillType skill = ExperienceAPI.getNonChildSkillType(skillType);
        PlayerProfile profile = UserManager.getPlayer(player).getProfile();
        return profile.getXpToLevel(skill) - profile.getSkillXpLevel(skill);
    }

    public static int getOfflineXPRemaining(String playerName, String skillType) {
        SkillType skill = ExperienceAPI.getNonChildSkillType(skillType);
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(playerName);
        return profile.getXpToLevel(skill) - profile.getSkillXpLevel(skill);
    }

    public static void addLevel(Player player, String skillType, int levels) {
        UserManager.getPlayer(player).addLevels(ExperienceAPI.getSkillType(skillType), levels);
    }

    public static void addLevelOffline(String playerName, String skillType, int levels) {
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(playerName);
        SkillType skill = ExperienceAPI.getSkillType(skillType);
        if (skill.isChildSkill()) {
            Set<SkillType> parentSkills = FamilyTree.getParents(skill);
            for (SkillType parentSkill : parentSkills) {
                profile.addLevels(parentSkill, levels / parentSkills.size());
            }
            profile.save();
            return;
        }
        profile.addLevels(skill, levels);
        profile.save();
    }

    public static int getLevel(Player player, String skillType) {
        return UserManager.getPlayer(player).getSkillLevel(ExperienceAPI.getSkillType(skillType));
    }

    public static int getLevelOffline(String playerName, String skillType) {
        return ExperienceAPI.getOfflineProfile(playerName).getSkillLevel(ExperienceAPI.getSkillType(skillType));
    }

    public static int getPowerLevel(Player player) {
        return UserManager.getPlayer(player).getPowerLevel();
    }

    public static int getPowerLevelOffline(String playerName) {
        int powerLevel = 0;
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(playerName);
        for (SkillType type : SkillType.NON_CHILD_SKILLS) {
            powerLevel += profile.getSkillLevel(type);
        }
        return powerLevel;
    }

    public static int getLevelCap(String skillType) {
        return Config.getInstance().getLevelCap(ExperienceAPI.getSkillType(skillType));
    }

    public static int getPowerLevelCap() {
        return Config.getInstance().getPowerLevelCap();
    }

    public static int getPlayerRankSkill(String playerName, String skillType) {
        return mcMMO.getDatabaseManager().readRank(ExperienceAPI.getOfflineProfile(playerName).getPlayerName()).get((Object)ExperienceAPI.getNonChildSkillType(skillType));
    }

    public static int getPlayerRankOverall(String playerName) {
        return mcMMO.getDatabaseManager().readRank(ExperienceAPI.getOfflineProfile(playerName).getPlayerName()).get(null);
    }

    public static void setLevel(Player player, String skillType, int skillLevel) {
        UserManager.getPlayer(player).modifySkill(ExperienceAPI.getSkillType(skillType), skillLevel);
    }

    public static void setLevelOffline(String playerName, String skillType, int skillLevel) {
        ExperienceAPI.getOfflineProfile(playerName).modifySkill(ExperienceAPI.getSkillType(skillType), skillLevel);
    }

    public static void setXP(Player player, String skillType, int newValue) {
        UserManager.getPlayer(player).setSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType), newValue);
    }

    public static void setXPOffline(String playerName, String skillType, int newValue) {
        ExperienceAPI.getOfflineProfile(playerName).setSkillXpLevel(ExperienceAPI.getNonChildSkillType(skillType), newValue);
    }

    public static void removeXP(Player player, String skillType, int xp) {
        UserManager.getPlayer(player).removeXp(ExperienceAPI.getNonChildSkillType(skillType), xp);
    }

    public static void removeXPOffline(String playerName, String skillType, int xp) {
        ExperienceAPI.getOfflineProfile(playerName).removeXp(ExperienceAPI.getNonChildSkillType(skillType), xp);
    }

    private static void addOfflineXP(String playerName, SkillType skill, int XP) {
        PlayerProfile profile = ExperienceAPI.getOfflineProfile(playerName);
        profile.addXp(skill, XP);
        profile.save();
    }

    private static PlayerProfile getOfflineProfile(String playerName) {
        PlayerProfile profile = mcMMO.getDatabaseManager().loadPlayerProfile(playerName, false);
        if (!profile.isLoaded()) {
            throw new InvalidPlayerException();
        }
        return profile;
    }

    private static SkillType getSkillType(String skillType) throws InvalidSkillException {
        SkillType skill = SkillType.getSkill(skillType);
        if (skill == null) {
            throw new InvalidSkillException();
        }
        return skill;
    }

    private static SkillType getNonChildSkillType(String skillType) throws InvalidSkillException, UnsupportedOperationException {
        SkillType skill = ExperienceAPI.getSkillType(skillType);
        if (skill.isChildSkill()) {
            throw new UnsupportedOperationException("Child skills do not have XP");
        }
        return skill;
    }
}

