/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.api;

import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.player.UserManager;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public final class PartyAPI {
    private PartyAPI() {
    }

    public static String getPartyName(Player player) {
        if (!PartyAPI.inParty(player)) {
            return null;
        }
        return UserManager.getPlayer(player).getParty().getName();
    }

    public static boolean inParty(Player player) {
        return UserManager.getPlayer(player).inParty();
    }

    public static boolean inSameParty(Player playera, Player playerb) {
        return PartyManager.inSameParty(playera, playerb);
    }

    public static List<Party> getParties() {
        return PartyManager.getParties();
    }

    public static void addToParty(Player player, String partyName) {
        Party party = PartyManager.getParty(partyName);
        if (party == null) {
            party = new Party(player.getName(), partyName);
        }
        PartyManager.addToParty(UserManager.getPlayer(player), party);
    }

    public static void removeFromParty(Player player) {
        PartyManager.removeFromParty(UserManager.getPlayer(player));
    }

    public static String getPartyLeader(String partyName) {
        return PartyManager.getPartyLeader(partyName);
    }

    public static void setPartyLeader(String partyName, String player) {
        PartyManager.setPartyLeader(player, PartyManager.getParty(partyName));
    }

    @Deprecated
    public static List<OfflinePlayer> getOnlineAndOfflineMembers(Player player) {
        ArrayList<OfflinePlayer> members = new ArrayList<OfflinePlayer>();
        for (String memberName : PartyManager.getAllMembers(player)) {
            OfflinePlayer member = mcMMO.p.getServer().getOfflinePlayer(memberName);
            members.add(member);
        }
        return members;
    }

    public static LinkedHashSet<String> getMembers(Player player) {
        return PartyManager.getAllMembers(player);
    }

    public static List<Player> getOnlineMembers(String partyName) {
        return PartyManager.getOnlineMembers(partyName);
    }

    public static List<Player> getOnlineMembers(Player player) {
        return PartyManager.getOnlineMembers(player);
    }

    public static boolean hasAlly(String partyName) {
        return PartyManager.getParty(partyName).getAlly() != null;
    }

    public static String getAllyName(String partyName) {
        Party ally = PartyManager.getParty(partyName).getAlly();
        if (ally != null) {
            return ally.getName();
        }
        return null;
    }
}

