/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.hardcore;

import com.gmail.nossr50.commands.hardcore.HardcoreModeCommand;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Permissions;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;

public class VampirismCommand
extends HardcoreModeCommand {
    @Override
    protected boolean checkTogglePermissions(CommandSender sender) {
        return Permissions.vampirismToggle((Permissible)sender);
    }

    @Override
    protected boolean checkModifyPermissions(CommandSender sender) {
        return Permissions.vampirismModify((Permissible)sender);
    }

    @Override
    protected boolean checkEnabled(SkillType skill) {
        if (skill == null) {
            for (SkillType skillType : SkillType.values()) {
                if (skillType.getHardcoreVampirismEnabled()) continue;
                return false;
            }
            return true;
        }
        return skill.getHardcoreVampirismEnabled();
    }

    @Override
    protected void enable(SkillType skill) {
        this.toggle(true, skill);
    }

    @Override
    protected void disable(SkillType skill) {
        this.toggle(false, skill);
    }

    @Override
    protected void modify(CommandSender sender, double newPercentage) {
        Config.getInstance().setHardcoreVampirismStatLeechPercentage(newPercentage);
        sender.sendMessage(LocaleLoader.getString("Hardcore.Vampirism.PercentageChanged", this.percent.format(newPercentage / 100.0)));
    }

    private void toggle(boolean enable, SkillType skill) {
        if (skill == null) {
            for (SkillType skillType : SkillType.NON_CHILD_SKILLS) {
                skillType.setHardcoreVampirismEnabled(enable);
            }
        } else {
            skill.setHardcoreVampirismEnabled(enable);
        }
        mcMMO.p.getServer().broadcastMessage(LocaleLoader.getString("Hardcore.Mode." + (enable ? "Enabled" : "Disabled"), LocaleLoader.getString("Hardcore.Vampirism.Name"), skill == null ? "all skills" : skill));
    }
}

