/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party;

import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.events.party.McMMOPartyChangeEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyKickCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (args.length) {
            case 2: {
                Party playerParty = UserManager.getPlayer((Player)sender).getParty();
                String targetName = CommandUtils.getMatchedPlayerName(args[1]);
                if (!playerParty.getMembers().contains(targetName)) {
                    sender.sendMessage(LocaleLoader.getString("Party.NotInYourParty", targetName));
                    return true;
                }
                OfflinePlayer target = mcMMO.p.getServer().getOfflinePlayer(targetName);
                if (target.isOnline()) {
                    String partyName;
                    Player onlineTarget = target.getPlayer();
                    if (!PartyManager.handlePartyChangeEvent(onlineTarget, partyName = playerParty.getName(), null, McMMOPartyChangeEvent.EventReason.KICKED_FROM_PARTY)) {
                        return true;
                    }
                    PartyManager.processPartyLeaving(UserManager.getPlayer(onlineTarget));
                    onlineTarget.sendMessage(LocaleLoader.getString("Commands.Party.Kick", partyName));
                }
                PartyManager.removeFromParty(target, playerParty);
                return true;
            }
        }
        sender.sendMessage(LocaleLoader.getString("Commands.Usage.2", "party", "kick", "<" + LocaleLoader.getString("Commands.Usage.Player") + ">"));
        return true;
    }
}

