/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.player;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.commands.MctopCommandAsyncTask;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;

public class MctopCommand
implements TabExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        SkillType skill = null;
        switch (args.length) {
            case 0: {
                this.display(1, skill, sender, command);
                return true;
            }
            case 1: {
                if (StringUtils.isInt(args[0])) {
                    this.display(Math.abs(Integer.parseInt(args[0])), skill, sender, command);
                    return true;
                }
                skill = this.extractSkill(sender, args[0]);
                if (skill == null) {
                    return true;
                }
                this.display(1, skill, sender, command);
                return true;
            }
            case 2: {
                if (CommandUtils.isInvalidInteger(sender, args[1])) {
                    return true;
                }
                skill = this.extractSkill(sender, args[0]);
                if (skill == null) {
                    return true;
                }
                this.display(Math.abs(Integer.parseInt(args[1])), skill, sender, command);
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        switch (args.length) {
            case 1: {
                return (List)StringUtil.copyPartialMatches((String)args[0], SkillType.SKILL_NAMES, new ArrayList(SkillType.SKILL_NAMES.size()));
            }
        }
        return ImmutableList.of();
    }

    private void display(int page, SkillType skill, CommandSender sender, Command command) {
        if (skill != null && !Permissions.mctop((Permissible)sender, skill)) {
            sender.sendMessage(command.getPermissionMessage());
            return;
        }
        if (sender instanceof Player) {
            McMMOPlayer mcMMOPlayer = UserManager.getPlayer(sender.getName());
            long cooldownMillis = Math.max(Config.getInstance().getDatabasePlayerCooldown(), 1750L);
            if (mcMMOPlayer.getDatabaseATS() + cooldownMillis > System.currentTimeMillis()) {
                sender.sendMessage(LocaleLoader.getString("Commands.Database.Cooldown"));
                return;
            }
            mcMMOPlayer.actualizeDatabaseATS();
        }
        this.display(page, skill, sender);
    }

    private void display(int page, SkillType skill, CommandSender sender) {
        boolean useBoard = sender instanceof Player && Config.getInstance().getTopUseBoard();
        boolean useChat = !useBoard || Config.getInstance().getTopUseChat();
        new MctopCommandAsyncTask(page, skill, sender, useBoard, useChat).runTaskAsynchronously((Plugin)mcMMO.p);
    }

    private SkillType extractSkill(CommandSender sender, String skillName) {
        if (CommandUtils.isInvalidSkill(sender, skillName)) {
            return null;
        }
        SkillType skill = SkillType.getSkill(skillName);
        if (CommandUtils.isChildSkill(sender, skill)) {
            return null;
        }
        return skill;
    }
}

