/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class AcrobaticsCommand
extends SkillCommand {
    private String dodgeChance;
    private String dodgeChanceLucky;
    private String rollChance;
    private String rollChanceLucky;
    private String gracefulRollChance;
    private String gracefulRollChanceLucky;
    private boolean canDodge;
    private boolean canRoll;
    private boolean canGracefulRoll;

    public AcrobaticsCommand() {
        super(SkillType.ACROBATICS);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue, boolean isLucky) {
        if (this.canDodge) {
            String[] dodgeStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.DODGE, isLucky);
            this.dodgeChance = dodgeStrings[0];
            this.dodgeChanceLucky = dodgeStrings[1];
        }
        if (this.canRoll) {
            String[] rollStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.ROLL, isLucky);
            this.rollChance = rollStrings[0];
            this.rollChanceLucky = rollStrings[1];
        }
        if (this.canGracefulRoll) {
            String[] gracefulRollStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.GRACEFUL_ROLL, isLucky);
            this.gracefulRollChance = gracefulRollStrings[0];
            this.gracefulRollChanceLucky = gracefulRollStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canDodge = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.DODGE);
        this.canRoll = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.ROLL);
        this.canGracefulRoll = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.GRACEFUL_ROLL);
    }

    @Override
    protected List<String> effectsDisplay() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canRoll) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Acrobatics.Effect.0"), LocaleLoader.getString("Acrobatics.Effect.1")));
        }
        if (this.canGracefulRoll) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Acrobatics.Effect.2"), LocaleLoader.getString("Acrobatics.Effect.3")));
        }
        if (this.canDodge) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Acrobatics.Effect.4"), LocaleLoader.getString("Acrobatics.Effect.5")));
        }
        return messages;
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canRoll) {
            messages.add(LocaleLoader.getString("Acrobatics.Roll.Chance", this.rollChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.rollChanceLucky) : ""));
        }
        if (this.canGracefulRoll) {
            messages.add(LocaleLoader.getString("Acrobatics.Roll.GraceChance", this.gracefulRollChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.gracefulRollChanceLucky) : ""));
        }
        if (this.canDodge) {
            messages.add(LocaleLoader.getString("Acrobatics.DodgeChance", this.dodgeChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.dodgeChanceLucky) : ""));
        }
        return messages;
    }
}

