/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.alchemy.Alchemy;
import com.gmail.nossr50.skills.alchemy.AlchemyManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class AlchemyCommand
extends SkillCommand {
    private String brewSpeed;
    private String brewSpeedLucky;
    private int tier;
    private int ingredientCount;
    private String ingredientList;
    private boolean canCatalysis;
    private boolean canConcoctions;

    public AlchemyCommand() {
        super(SkillType.ALCHEMY);
    }

    protected String[] calculateAbilityDisplayValues(Player player, boolean isLucky) {
        AlchemyManager alchemyManager = UserManager.getPlayer(player).getAlchemyManager();
        String[] displayValues = new String[]{this.decimal.format(alchemyManager.calculateBrewSpeed(false)) + "x", isLucky ? this.decimal.format(alchemyManager.calculateBrewSpeed(true)) + "x" : null};
        return displayValues;
    }

    @Override
    protected void dataCalculations(Player player, float skillValue, boolean isLucky) {
        if (this.canCatalysis) {
            String[] catalysisStrings = this.calculateAbilityDisplayValues(player, isLucky);
            this.brewSpeed = catalysisStrings[0];
            this.brewSpeedLucky = catalysisStrings[1];
        }
        if (this.canConcoctions) {
            AlchemyManager alchemyManager = UserManager.getPlayer(player).getAlchemyManager();
            this.tier = alchemyManager.getTier();
            this.ingredientCount = alchemyManager.getIngredients().size();
            this.ingredientList = alchemyManager.getIngredientList();
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canCatalysis = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.CATALYSIS);
        this.canConcoctions = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.CONCOCTIONS);
    }

    @Override
    protected List<String> effectsDisplay() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canCatalysis) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Alchemy.Effect.0"), LocaleLoader.getString("Alchemy.Effect.1")));
        }
        if (this.canConcoctions) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Alchemy.Effect.2"), LocaleLoader.getString("Alchemy.Effect.3")));
        }
        return messages;
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canCatalysis) {
            int unlockLevel = AdvancedConfig.getInstance().getCatalysisUnlockLevel();
            if (skillValue < (float)unlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Alchemy.Ability.Locked.0", unlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Alchemy.Catalysis.Speed", this.brewSpeed) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.brewSpeedLucky) : ""));
            }
        }
        if (this.canConcoctions) {
            messages.add(LocaleLoader.getString("Alchemy.Concoctions.Rank", this.tier, Alchemy.Tier.values().length));
            messages.add(LocaleLoader.getString("Alchemy.Concoctions.Ingredients", this.ingredientCount, this.ingredientList));
        }
        return messages;
    }
}

