/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.treasure.TreasureConfig;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.datatypes.treasure.Rarity;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.fishing.Fishing;
import com.gmail.nossr50.skills.fishing.FishingManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class FishingCommand
extends SkillCommand {
    private int lootTier;
    private String shakeChance;
    private String shakeChanceLucky;
    private int fishermansDietRank;
    private String biteChance;
    private String trapTreasure;
    private String commonTreasure;
    private String uncommonTreasure;
    private String rareTreasure;
    private String epicTreasure;
    private String legendaryTreasure;
    private String recordTreasure;
    private String magicChance;
    private boolean canTreasureHunt;
    private boolean canMagicHunt;
    private boolean canShake;
    private boolean canFishermansDiet;
    private boolean canMasterAngler;
    private boolean canIceFish;

    public FishingCommand() {
        super(SkillType.FISHING);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue, boolean isLucky) {
        FishingManager fishingManager = UserManager.getPlayer(player).getFishingManager();
        if (this.canTreasureHunt) {
            this.lootTier = fishingManager.getLootTier();
            this.trapTreasure = this.percent.format(TreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.TRAP) / 100.0);
            this.commonTreasure = this.percent.format(TreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.COMMON) / 100.0);
            this.uncommonTreasure = this.percent.format(TreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.UNCOMMON) / 100.0);
            this.rareTreasure = this.percent.format(TreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.RARE) / 100.0);
            this.epicTreasure = this.percent.format(TreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.EPIC) / 100.0);
            this.legendaryTreasure = this.percent.format(TreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.LEGENDARY) / 100.0);
            this.recordTreasure = this.percent.format(TreasureConfig.getInstance().getItemDropRate(this.lootTier, Rarity.RECORD) / 100.0);
            double totalEnchantChance = 0.0;
            for (Rarity rarity : Rarity.values()) {
                if (rarity == Rarity.TRAP || rarity == Rarity.RECORD) continue;
                totalEnchantChance += TreasureConfig.getInstance().getEnchantmentDropRate(this.lootTier, rarity);
            }
            this.magicChance = this.percent.format(totalEnchantChance / 100.0);
        }
        if (this.canShake) {
            String[] shakeStrings = this.calculateAbilityDisplayValues(UserManager.getPlayer(player).getFishingManager().getShakeProbability(), isLucky);
            this.shakeChance = shakeStrings[0];
            this.shakeChanceLucky = shakeStrings[1];
        }
        if (this.canFishermansDiet) {
            this.fishermansDietRank = this.calculateRank(skillValue, Fishing.fishermansDietMaxLevel, Fishing.fishermansDietRankLevel1);
        }
        if (this.canMasterAngler) {
            double rawBiteChance = 1.0 / (double)(player.getWorld().hasStorm() ? 300 : 500);
            Location location = fishingManager.getHookLocation();
            if (location == null) {
                location = player.getLocation();
            }
            if (Fishing.masterAnglerBiomes.contains(location.getBlock().getBiome())) {
                rawBiteChance *= AdvancedConfig.getInstance().getMasterAnglerBiomeModifier();
            }
            if (player.isInsideVehicle() && player.getVehicle().getType() == EntityType.BOAT) {
                rawBiteChance *= AdvancedConfig.getInstance().getMasterAnglerBoatModifier();
            }
            this.biteChance = this.calculateAbilityDisplayValues(rawBiteChance * 100.0, isLucky)[0];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canTreasureHunt = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.FISHING_TREASURE_HUNTER);
        this.canMagicHunt = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.MAGIC_HUNTER);
        this.canShake = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.SHAKE);
        this.canFishermansDiet = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.FISHERMANS_DIET);
        this.canMasterAngler = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.MASTER_ANGLER);
        this.canIceFish = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.ICE_FISHING);
    }

    @Override
    protected List<String> effectsDisplay() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canTreasureHunt) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Fishing.Effect.0"), LocaleLoader.getString("Fishing.Effect.1")));
        }
        if (this.canMagicHunt) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Fishing.Effect.2"), LocaleLoader.getString("Fishing.Effect.3")));
        }
        if (this.canIceFish) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Fishing.Effect.10"), LocaleLoader.getString("Fishing.Effect.11")));
        }
        if (this.canMasterAngler) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Fishing.Effect.8"), LocaleLoader.getString("Fishing.Effect.9")));
        }
        if (this.canShake) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Fishing.Effect.4"), LocaleLoader.getString("Fishing.Effect.5")));
        }
        if (this.canFishermansDiet) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Fishing.Effect.6"), LocaleLoader.getString("Fishing.Effect.7")));
        }
        return messages;
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        int unlockLevel;
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canTreasureHunt) {
            messages.add(LocaleLoader.getString("Fishing.Ability.Rank", this.lootTier, Fishing.Tier.values().length));
            messages.add(LocaleLoader.getString("Fishing.Ability.TH.DropRate", this.trapTreasure, this.commonTreasure, this.uncommonTreasure, this.rareTreasure, this.epicTreasure, this.legendaryTreasure, this.recordTreasure));
        }
        if (this.canMagicHunt) {
            messages.add(LocaleLoader.getString("Fishing.Ability.TH.MagicRate", this.magicChance));
        }
        if (this.canIceFish) {
            unlockLevel = AdvancedConfig.getInstance().getIceFishingUnlockLevel();
            if (skillValue < (float)unlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Fishing.Ability.Locked.1", unlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Fishing.Ability.IceFishing"));
            }
        }
        if (this.canMasterAngler) {
            unlockLevel = AdvancedConfig.getInstance().getMasterAnglerUnlockLevel();
            if (skillValue < (float)unlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Fishing.Ability.Locked.2", unlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Fishing.Ability.Chance", this.biteChance));
            }
        }
        if (this.canShake) {
            unlockLevel = AdvancedConfig.getInstance().getFishingTierLevel(Fishing.Tier.ONE);
            if (skillValue < (float)unlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Fishing.Ability.Locked.0", unlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Fishing.Ability.Shake", this.shakeChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.shakeChanceLucky) : ""));
            }
        }
        if (this.canFishermansDiet) {
            messages.add(LocaleLoader.getString("Fishing.Ability.FD", this.fishermansDietRank));
        }
        return messages;
    }
}

