/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class SkillGuideCommand
implements CommandExecutor {
    private String header;
    private ArrayList<String> guide;
    private String invalidPage = LocaleLoader.getString("Guides.Page.Invalid");

    public SkillGuideCommand(SkillType skill) {
        this.header = LocaleLoader.getString("Guides.Header", skill.getName());
        this.guide = this.getGuide(skill);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (args.length) {
            case 1: {
                if (!args[0].equals("?")) {
                    return false;
                }
                this.sendGuide(sender, 1);
                return true;
            }
            case 2: {
                int totalPages = this.getTotalPageNumber();
                if (!StringUtils.isInt(args[1])) {
                    sender.sendMessage(this.invalidPage);
                    return true;
                }
                int pageNumber = Integer.parseInt(args[1]);
                if (pageNumber > totalPages || pageNumber <= 0) {
                    sender.sendMessage(LocaleLoader.getString("Guides.Page.OutOfRange", totalPages));
                    return true;
                }
                this.sendGuide(sender, pageNumber);
                return true;
            }
        }
        return false;
    }

    private int getTotalPageNumber() {
        return (int)Math.ceil((double)this.guide.size() / 8.0);
    }

    private void sendGuide(CommandSender sender, int pageNumber) {
        for (String target : this.grabPageContents(pageNumber)) {
            sender.sendMessage(target);
        }
    }

    private ArrayList<String> grabPageContents(int page) {
        int pageIndexStart = 8 * (page - 1);
        ArrayList<String> allStrings = new ArrayList<String>();
        allStrings.add(this.header);
        while (allStrings.size() < 9) {
            if (pageIndexStart + allStrings.size() > this.guide.size()) {
                allStrings.add("");
                continue;
            }
            allStrings.add(this.guide.get(pageIndexStart + (allStrings.size() - 1)));
        }
        allStrings.add("Page " + page + " of " + this.getTotalPageNumber());
        return allStrings;
    }

    private ArrayList<String> getGuide(SkillType skill) {
        String[] section;
        ArrayList<String> guide = new ArrayList<String>();
        for (int i = 0; i < 10 && !(section = LocaleLoader.getString("Guides." + StringUtils.getCapitalized(skill.toString()) + ".Section." + i).split("\n"))[0].startsWith("!"); ++i) {
            guide.addAll(Arrays.asList(section));
            if (section.length >= 8) continue;
            for (int blankLine = 8 - section.length; blankLine > 0; --blankLine) {
                guide.add("");
            }
        }
        return guide;
    }
}

