/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.smelting.Smelting;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class SmeltingCommand
extends SkillCommand {
    private String burnTimeModifier;
    private String secondSmeltChance;
    private String secondSmeltChanceLucky;
    private String fluxMiningChance;
    private String fluxMiningChanceLucky;
    private boolean canFuelEfficiency;
    private boolean canSecondSmelt;
    private boolean canFluxMine;
    private boolean canVanillaXPBoost;

    public SmeltingCommand() {
        super(SkillType.SMELTING);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue, boolean isLucky) {
        if (this.canFuelEfficiency) {
            this.burnTimeModifier = this.decimal.format(1.0 + (double)(skillValue / (float)Smelting.burnModifierMaxLevel) * Smelting.burnTimeMultiplier);
        }
        if (this.canSecondSmelt) {
            String[] secondSmeltStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.SECOND_SMELT, isLucky);
            this.secondSmeltChance = secondSmeltStrings[0];
            this.secondSmeltChanceLucky = secondSmeltStrings[1];
        }
        if (this.canFluxMine) {
            String[] fluxMiningStrings = this.calculateAbilityDisplayValues(Smelting.fluxMiningChance, isLucky);
            this.fluxMiningChance = fluxMiningStrings[0];
            this.fluxMiningChanceLucky = fluxMiningStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canFuelEfficiency = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.FUEL_EFFICIENCY);
        this.canSecondSmelt = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.SECOND_SMELT);
        this.canFluxMine = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.FLUX_MINING);
        this.canVanillaXPBoost = Permissions.vanillaXpBoost((Permissible)player, this.skill);
    }

    @Override
    protected List<String> effectsDisplay() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canFuelEfficiency) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Smelting.Effect.0"), LocaleLoader.getString("Smelting.Effect.1")));
        }
        if (this.canSecondSmelt) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Smelting.Effect.2"), LocaleLoader.getString("Smelting.Effect.3")));
        }
        if (this.canVanillaXPBoost) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Smelting.Effect.4"), LocaleLoader.getString("Smelting.Effect.5")));
        }
        if (this.canFluxMine) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Smelting.Effect.6"), LocaleLoader.getString("Smelting.Effect.7")));
        }
        return messages;
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canFuelEfficiency) {
            messages.add(LocaleLoader.getString("Smelting.Ability.FuelEfficiency", this.burnTimeModifier));
        }
        if (this.canSecondSmelt) {
            messages.add(LocaleLoader.getString("Smelting.Ability.SecondSmelt", this.secondSmeltChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.secondSmeltChanceLucky) : ""));
        }
        if (this.canVanillaXPBoost) {
            int unlockLevel = AdvancedConfig.getInstance().getSmeltingRankLevel(Smelting.Tier.ONE);
            if (skillValue < (float)unlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Smelting.Ability.Locked.0", unlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Smelting.Ability.VanillaXPBoost", UserManager.getPlayer(player).getSmeltingManager().getVanillaXpMultiplier()));
            }
        }
        if (this.canFluxMine) {
            if (skillValue < (float)Smelting.fluxMiningUnlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Smelting.Ability.Locked.1", Smelting.fluxMiningUnlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Smelting.Ability.FluxMining", this.fluxMiningChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.fluxMiningChanceLucky) : ""));
            }
        }
        return messages;
    }
}

