/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.swords.Swords;
import com.gmail.nossr50.util.Permissions;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class SwordsCommand
extends SkillCommand {
    private String counterChance;
    private String counterChanceLucky;
    private int bleedLength;
    private String bleedChance;
    private String bleedChanceLucky;
    private String serratedStrikesLength;
    private String serratedStrikesLengthEndurance;
    private boolean canCounter;
    private boolean canSerratedStrike;
    private boolean canBleed;

    public SwordsCommand() {
        super(SkillType.SWORDS);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue, boolean isLucky) {
        if (this.canSerratedStrike) {
            String[] serratedStrikesStrings = this.calculateLengthDisplayValues(player, skillValue);
            this.serratedStrikesLength = serratedStrikesStrings[0];
            this.serratedStrikesLengthEndurance = serratedStrikesStrings[1];
        }
        if (this.canBleed) {
            this.bleedLength = skillValue >= (float)AdvancedConfig.getInstance().getMaxBonusLevel(SecondaryAbility.BLEED) ? Swords.bleedMaxTicks : Swords.bleedBaseTicks;
            String[] bleedStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.BLEED, isLucky);
            this.bleedChance = bleedStrings[0];
            this.bleedChanceLucky = bleedStrings[1];
        }
        if (this.canCounter) {
            String[] counterStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.COUNTER, isLucky);
            this.counterChance = counterStrings[0];
            this.counterChanceLucky = counterStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canBleed = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.BLEED);
        this.canCounter = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.COUNTER);
        this.canSerratedStrike = Permissions.serratedStrikes((Permissible)player);
    }

    @Override
    protected List<String> effectsDisplay() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canCounter) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Swords.Effect.0"), LocaleLoader.getString("Swords.Effect.1", this.percent.format(1.0 / Swords.counterAttackModifier))));
        }
        if (this.canSerratedStrike) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Swords.Effect.2"), LocaleLoader.getString("Swords.Effect.3", this.percent.format(1.0 / Swords.serratedStrikesModifier))));
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Swords.Effect.4"), LocaleLoader.getString("Swords.Effect.5", Swords.serratedStrikesBleedTicks)));
        }
        if (this.canBleed) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Swords.Effect.6"), LocaleLoader.getString("Swords.Effect.7")));
        }
        return messages;
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canCounter) {
            messages.add(LocaleLoader.getString("Swords.Combat.Counter.Chance", this.counterChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.counterChanceLucky) : ""));
        }
        if (this.canBleed) {
            messages.add(LocaleLoader.getString("Swords.Combat.Bleed.Length", this.bleedLength));
            messages.add(LocaleLoader.getString("Swords.Combat.Bleed.Note"));
            messages.add(LocaleLoader.getString("Swords.Combat.Bleed.Chance", this.bleedChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.bleedChanceLucky) : ""));
        }
        if (this.canSerratedStrike) {
            messages.add(LocaleLoader.getString("Swords.SS.Length", this.serratedStrikesLength) + (hasEndurance ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.serratedStrikesLengthEndurance) : ""));
        }
        return messages;
    }
}

