/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.unarmed.Unarmed;
import com.gmail.nossr50.util.Permissions;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class UnarmedCommand
extends SkillCommand {
    private String berserkLength;
    private String berserkLengthEndurance;
    private String deflectChance;
    private String deflectChanceLucky;
    private String disarmChance;
    private String disarmChanceLucky;
    private String ironGripChance;
    private String ironGripChanceLucky;
    private double ironArmBonus;
    private boolean canBerserk;
    private boolean canDisarm;
    private boolean canIronArm;
    private boolean canDeflect;
    private boolean canIronGrip;

    public UnarmedCommand() {
        super(SkillType.UNARMED);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue, boolean isLucky) {
        if (this.canBerserk) {
            String[] berserkStrings = this.calculateLengthDisplayValues(player, skillValue);
            this.berserkLength = berserkStrings[0];
            this.berserkLengthEndurance = berserkStrings[1];
        }
        if (this.canDisarm) {
            String[] disarmStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.DISARM, isLucky);
            this.disarmChance = disarmStrings[0];
            this.disarmChanceLucky = disarmStrings[1];
        }
        if (this.canDeflect) {
            String[] deflectStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.DEFLECT, isLucky);
            this.deflectChance = deflectStrings[0];
            this.deflectChanceLucky = deflectStrings[1];
        }
        if (this.canIronArm) {
            this.ironArmBonus = Math.min((double)(3 + (int)skillValue / Unarmed.ironArmIncreaseLevel), Unarmed.ironArmMaxBonusDamage);
        }
        if (this.canIronGrip) {
            String[] ironGripStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.IRON_GRIP, isLucky);
            this.ironGripChance = ironGripStrings[0];
            this.ironGripChanceLucky = ironGripStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canBerserk = Permissions.berserk((Permissible)player);
        this.canIronArm = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.IRON_ARM);
        this.canDeflect = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.DEFLECT);
        this.canDisarm = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.DISARM);
        this.canIronGrip = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.IRON_GRIP);
    }

    @Override
    protected List<String> effectsDisplay() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canBerserk) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Unarmed.Effect.0"), LocaleLoader.getString("Unarmed.Effect.1")));
        }
        if (this.canDisarm) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Unarmed.Effect.2"), LocaleLoader.getString("Unarmed.Effect.3")));
        }
        if (this.canIronArm) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Unarmed.Effect.4"), LocaleLoader.getString("Unarmed.Effect.5")));
        }
        if (this.canDeflect) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Unarmed.Effect.6"), LocaleLoader.getString("Unarmed.Effect.7")));
        }
        if (this.canIronGrip) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Unarmed.Effect.8"), LocaleLoader.getString("Unarmed.Effect.9")));
        }
        return messages;
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canIronArm) {
            messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Unarmed.Ability.Bonus.0"), LocaleLoader.getString("Unarmed.Ability.Bonus.1", this.ironArmBonus)));
        }
        if (this.canDeflect) {
            messages.add(LocaleLoader.getString("Unarmed.Ability.Chance.ArrowDeflect", this.deflectChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.deflectChanceLucky) : ""));
        }
        if (this.canDisarm) {
            messages.add(LocaleLoader.getString("Unarmed.Ability.Chance.Disarm", this.disarmChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.disarmChanceLucky) : ""));
        }
        if (this.canIronGrip) {
            messages.add(LocaleLoader.getString("Unarmed.Ability.Chance.IronGrip", this.ironGripChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.ironGripChanceLucky) : ""));
        }
        if (this.canBerserk) {
            messages.add(LocaleLoader.getString("Unarmed.Ability.Berserk.Length", this.berserkLength) + (hasEndurance ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.berserkLengthEndurance) : ""));
        }
        return messages;
    }
}

