/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class WoodcuttingCommand
extends SkillCommand {
    private String treeFellerLength;
    private String treeFellerLengthEndurance;
    private String doubleDropChance;
    private String doubleDropChanceLucky;
    private boolean canTreeFell;
    private boolean canLeafBlow;
    private boolean canDoubleDrop;

    public WoodcuttingCommand() {
        super(SkillType.WOODCUTTING);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue, boolean isLucky) {
        if (this.canTreeFell) {
            String[] treeFellerStrings = this.calculateLengthDisplayValues(player, skillValue);
            this.treeFellerLength = treeFellerStrings[0];
            this.treeFellerLengthEndurance = treeFellerStrings[1];
        }
        if (this.canDoubleDrop) {
            String[] doubleDropStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.WOODCUTTING_DOUBLE_DROPS, isLucky);
            this.doubleDropChance = doubleDropStrings[0];
            this.doubleDropChanceLucky = doubleDropStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canTreeFell = Permissions.treeFeller((Permissible)player);
        this.canDoubleDrop = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.WOODCUTTING_DOUBLE_DROPS) && !this.skill.getDoubleDropsDisabled();
        this.canLeafBlow = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.LEAF_BLOWER);
    }

    @Override
    protected List<String> effectsDisplay() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canTreeFell) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Woodcutting.Effect.0"), LocaleLoader.getString("Woodcutting.Effect.1")));
        }
        if (this.canLeafBlow) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Woodcutting.Effect.2"), LocaleLoader.getString("Woodcutting.Effect.3")));
        }
        if (this.canDoubleDrop) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Woodcutting.Effect.4"), LocaleLoader.getString("Woodcutting.Effect.5")));
        }
        return messages;
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canLeafBlow) {
            int leafBlowerUnlockLevel = AdvancedConfig.getInstance().getLeafBlowUnlockLevel();
            if (skillValue < (float)leafBlowerUnlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Woodcutting.Ability.Locked.0", leafBlowerUnlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Woodcutting.Ability.0"), LocaleLoader.getString("Woodcutting.Ability.1")));
            }
        }
        if (this.canDoubleDrop) {
            messages.add(LocaleLoader.getString("Woodcutting.Ability.Chance.DDrop", this.doubleDropChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.doubleDropChanceLucky) : ""));
        }
        if (this.canTreeFell) {
            messages.add(LocaleLoader.getString("Woodcutting.Ability.Length", this.treeFellerLength) + (hasEndurance ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.treeFellerLengthEndurance) : ""));
        }
        return messages;
    }
}

