/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.mcMMO;
import java.io.File;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public abstract class ConfigLoader {
    protected static final mcMMO plugin = mcMMO.p;
    protected String fileName;
    private File configFile;
    protected FileConfiguration config;

    public ConfigLoader(String relativePath, String fileName) {
        this.fileName = fileName;
        this.configFile = new File(plugin.getDataFolder(), relativePath + File.separator + fileName);
        this.loadFile();
    }

    public ConfigLoader(String fileName) {
        this.fileName = fileName;
        this.configFile = new File(plugin.getDataFolder(), fileName);
        this.loadFile();
    }

    protected void loadFile() {
        if (!this.configFile.exists()) {
            plugin.debug("Creating mcMMO " + this.fileName + " File...");
            try {
                plugin.saveResource(this.fileName, false);
            }
            catch (IllegalArgumentException ex) {
                plugin.saveResource(this.configFile.getParentFile().getName() + File.separator + this.fileName, false);
            }
        } else {
            plugin.debug("Loading mcMMO " + this.fileName + " File...");
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    protected abstract void loadKeys();

    protected boolean validateKeys() {
        return true;
    }

    protected boolean noErrorsInConfig(List<String> issues) {
        for (String issue : issues) {
            plugin.getLogger().warning(issue);
        }
        return issues.isEmpty();
    }

    protected void validate() {
        if (this.validateKeys()) {
            plugin.debug("No errors found in " + this.fileName + "!");
        } else {
            plugin.getLogger().warning("Errors were found in " + this.fileName + "! mcMMO was disabled!");
            plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
            ConfigLoader.plugin.noErrorsInConfigFiles = false;
        }
    }

    public File getFile() {
        return this.configFile;
    }

    public void backup() {
        plugin.getLogger().warning("You are using an old version of the " + this.fileName + " file.");
        plugin.getLogger().warning("Your old file has been renamed to " + this.fileName + ".old and has been replaced by an updated version.");
        this.configFile.renameTo(new File(this.configFile.getPath() + ".old"));
        if (plugin.getResource(this.fileName) != null) {
            plugin.saveResource(this.fileName, true);
        }
        plugin.getLogger().warning("Reloading " + this.fileName + " with new values...");
        this.loadFile();
        this.loadKeys();
    }
}

