/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.mods;

import com.gmail.nossr50.config.ConfigLoader;
import com.gmail.nossr50.datatypes.mods.CustomBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.material.MaterialData;

public class CustomBlockConfig
extends ConfigLoader {
    private boolean needsUpdate = false;
    public List<MaterialData> customExcavationBlocks = new ArrayList<MaterialData>();
    public List<MaterialData> customHerbalismBlocks = new ArrayList<MaterialData>();
    public List<MaterialData> customMiningBlocks = new ArrayList<MaterialData>();
    public List<MaterialData> customOres = new ArrayList<MaterialData>();
    public List<MaterialData> customLogs = new ArrayList<MaterialData>();
    public List<MaterialData> customLeaves = new ArrayList<MaterialData>();
    public List<MaterialData> customAbilityBlocks = new ArrayList<MaterialData>();
    public HashMap<MaterialData, CustomBlock> customBlockMap = new HashMap();

    protected CustomBlockConfig(String fileName) {
        super("mods", fileName);
        this.loadKeys();
    }

    @Override
    protected void loadKeys() {
        this.loadBlocks("Excavation", this.customExcavationBlocks);
        this.loadBlocks("Herbalism", this.customHerbalismBlocks);
        this.loadBlocks("Mining", this.customMiningBlocks);
        this.loadBlocks("Woodcutting", null);
        this.loadBlocks("Ability_Blocks", this.customAbilityBlocks);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.backup();
        }
    }

    private void loadBlocks(String skillType, List<MaterialData> blockList) {
        if (this.needsUpdate) {
            return;
        }
        ConfigurationSection skillSection = this.config.getConfigurationSection(skillType);
        if (skillSection == null) {
            return;
        }
        Set skillConfigSet = skillSection.getKeys(false);
        for (String blockName : skillConfigSet) {
            if (this.config.contains(skillType + "." + blockName + "." + ".Drop_Item")) {
                this.needsUpdate = true;
                return;
            }
            String[] blockInfo = blockName.split("[|]");
            Material blockMaterial = Material.matchMaterial((String)blockInfo[0]);
            if (blockMaterial == null) {
                plugin.getLogger().warning("Invalid material name. This item will be skipped. - " + blockInfo[0]);
                continue;
            }
            byte blockData = blockInfo.length == 2 ? Byte.valueOf(blockInfo[1]) : (byte)0;
            MaterialData blockMaterialData = new MaterialData(blockMaterial, blockData);
            if (blockList != null) {
                blockList.add(blockMaterialData);
            }
            if (skillType.equals("Ability_Blocks")) continue;
            int xp = this.config.getInt(skillType + "." + blockName + ".XP_Gain");
            int smeltingXp = 0;
            if (skillType.equals("Mining") && this.config.getBoolean(skillType + "." + blockName + ".Is_Ore")) {
                this.customOres.add(blockMaterialData);
                smeltingXp = this.config.getInt(skillType + "." + blockName + ".Smelting_XP_Gain", xp / 10);
            } else if (skillType.equals("Woodcutting")) {
                if (this.config.getBoolean(skillType + "." + blockName + ".Is_Log")) {
                    this.customLogs.add(blockMaterialData);
                } else {
                    this.customLeaves.add(blockMaterialData);
                    xp = 0;
                }
            }
            this.customBlockMap.put(blockMaterialData, new CustomBlock(xp, this.config.getBoolean(skillType + "." + blockName + ".Double_Drops_Enabled"), smeltingXp));
        }
    }
}

