/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.skills.repair;

import com.gmail.nossr50.config.skills.repair.RepairConfig;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class RepairConfigManager {
    private final List<Repairable> repairables = new ArrayList<Repairable>();

    public RepairConfigManager(mcMMO plugin) {
        Pattern pattern = Pattern.compile("repair\\.(?:.+)\\.yml");
        File dataFolder = plugin.getDataFolder();
        File vanilla = new File(dataFolder, "repair.vanilla.yml");
        if (!vanilla.exists()) {
            plugin.saveResource("repair.vanilla.yml", false);
        }
        for (String fileName : dataFolder.list()) {
            File file;
            if (!pattern.matcher(fileName).matches() || (file = new File(dataFolder, fileName)).isDirectory()) continue;
            RepairConfig rConfig = new RepairConfig(fileName);
            this.repairables.addAll(rConfig.getLoadedRepairables());
        }
    }

    public List<Repairable> getLoadedRepairables() {
        return this.repairables;
    }
}

