/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.database.DatabaseManager;
import com.gmail.nossr50.datatypes.MobHealthbarType;
import com.gmail.nossr50.datatypes.database.DatabaseType;
import com.gmail.nossr50.datatypes.database.DatabaseUpdateType;
import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.database.SQLDatabaseKeepaliveTask;
import com.gmail.nossr50.runnables.database.SQLReconnectTask;
import com.gmail.nossr50.util.Misc;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.bukkit.plugin.Plugin;

public final class SQLDatabaseManager
implements DatabaseManager {
    private String connectionString;
    private String tablePrefix = Config.getInstance().getMySQLTablePrefix();
    private Connection connection = null;
    private final double SCALING_FACTOR = 40.0;
    private final long MIN_WAIT = 500000000L;
    private final long MAX_WAIT = 300000000000L;
    private final int VALID_TIMEOUT = 3;
    private long nextReconnectTimestamp = 0L;
    private int reconnectAttempt = 0;

    protected SQLDatabaseManager() {
        this.checkStructure();
        new SQLDatabaseKeepaliveTask(this).runTaskTimerAsynchronously((Plugin)mcMMO.p, 10L, 72000L);
    }

    @Override
    public void purgePowerlessUsers() {
        if (!this.checkConnected()) {
            return;
        }
        mcMMO.p.getLogger().info("Purging powerless users...");
        Collection<ArrayList<String>> usernames = this.read("SELECT u.user FROM " + this.tablePrefix + "skills AS s, " + this.tablePrefix + "users AS u WHERE s.user_id = u.id AND (s.taming+s.mining+s.woodcutting+s.repair+s.unarmed+s.herbalism+s.excavation+s.archery+s.swords+s.axes+s.acrobatics+s.fishing) = 0").values();
        this.write("DELETE FROM u, e, h, s, c USING " + this.tablePrefix + "users u " + "JOIN " + this.tablePrefix + "experience e ON (u.id = e.user_id) " + "JOIN " + this.tablePrefix + "huds h ON (u.id = h.user_id) " + "JOIN " + this.tablePrefix + "skills s ON (u.id = s.user_id) " + "JOIN " + this.tablePrefix + "cooldowns c ON (u.id = c.user_id) " + "WHERE (s.taming+s.mining+s.woodcutting+s.repair+s.unarmed+s.herbalism+s.excavation+s.archery+s.swords+s.axes+s.acrobatics+s.fishing) = 0");
        this.processPurge(usernames);
        mcMMO.p.getLogger().info("Purged " + usernames.size() + " users from the database.");
    }

    @Override
    public void purgeOldUsers() {
        if (!this.checkConnected()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        mcMMO.p.getLogger().info("Purging old users...");
        Collection<ArrayList<String>> usernames = this.read("SELECT user FROM " + this.tablePrefix + "users WHERE ((" + currentTime + " - lastlogin * " + 1000 + ") > " + PURGE_TIME + ")").values();
        this.write("DELETE FROM u, e, h, s, c USING " + this.tablePrefix + "users u " + "JOIN " + this.tablePrefix + "experience e ON (u.id = e.user_id) " + "JOIN " + this.tablePrefix + "huds h ON (u.id = h.user_id) " + "JOIN " + this.tablePrefix + "skills s ON (u.id = s.user_id) " + "JOIN " + this.tablePrefix + "cooldowns c ON (u.id = c.user_id) " + "WHERE ((" + currentTime + " - lastlogin * " + 1000 + ") > " + PURGE_TIME + ")");
        this.processPurge(usernames);
        mcMMO.p.getLogger().info("Purged " + usernames.size() + " users from the database.");
    }

    @Override
    public boolean removeUser(String playerName) {
        if (!this.checkConnected()) {
            return false;
        }
        boolean success = this.update("DELETE FROM u, e, h, s, c USING " + this.tablePrefix + "users u " + "JOIN " + this.tablePrefix + "experience e ON (u.id = e.user_id) " + "JOIN " + this.tablePrefix + "huds h ON (u.id = h.user_id) " + "JOIN " + this.tablePrefix + "skills s ON (u.id = s.user_id) " + "JOIN " + this.tablePrefix + "cooldowns c ON (u.id = c.user_id) " + "WHERE u.user = '" + playerName + "'") != 0;
        Misc.profileCleanup(playerName);
        return success;
    }

    @Override
    public boolean saveUser(PlayerProfile profile) {
        if (!this.checkConnected()) {
            return false;
        }
        int userId = this.readId(profile.getPlayerName());
        if (userId == -1) {
            this.newUser(profile.getPlayerName());
            userId = this.readId(profile.getPlayerName());
            if (userId == -1) {
                return false;
            }
        }
        boolean success = true;
        MobHealthbarType mobHealthbarType = profile.getMobHealthbarType();
        success &= this.saveLogin(userId, (int)(System.currentTimeMillis() / 1000L));
        success &= this.saveHuds(userId, mobHealthbarType == null ? Config.getInstance().getMobHealthbarDefault().toString() : mobHealthbarType.toString());
        success &= this.saveLongs("UPDATE " + this.tablePrefix + "cooldowns SET " + "  mining = ?, woodcutting = ?, unarmed = ?" + ", herbalism = ?, excavation = ?, swords = ?" + ", axes = ?, blast_mining = ? WHERE user_id = ?", userId, profile.getAbilityDATS(AbilityType.SUPER_BREAKER), profile.getAbilityDATS(AbilityType.TREE_FELLER), profile.getAbilityDATS(AbilityType.BERSERK), profile.getAbilityDATS(AbilityType.GREEN_TERRA), profile.getAbilityDATS(AbilityType.GIGA_DRILL_BREAKER), profile.getAbilityDATS(AbilityType.SERRATED_STRIKES), profile.getAbilityDATS(AbilityType.SKULL_SPLITTER), profile.getAbilityDATS(AbilityType.BLAST_MINING));
        success &= this.saveIntegers("UPDATE " + this.tablePrefix + "skills SET " + " taming = ?, mining = ?, repair = ?, woodcutting = ?" + ", unarmed = ?, herbalism = ?, excavation = ?" + ", archery = ?, swords = ?, axes = ?, acrobatics = ?" + ", fishing = ?, alchemy = ? WHERE user_id = ?", profile.getSkillLevel(SkillType.TAMING), profile.getSkillLevel(SkillType.MINING), profile.getSkillLevel(SkillType.REPAIR), profile.getSkillLevel(SkillType.WOODCUTTING), profile.getSkillLevel(SkillType.UNARMED), profile.getSkillLevel(SkillType.HERBALISM), profile.getSkillLevel(SkillType.EXCAVATION), profile.getSkillLevel(SkillType.ARCHERY), profile.getSkillLevel(SkillType.SWORDS), profile.getSkillLevel(SkillType.AXES), profile.getSkillLevel(SkillType.ACROBATICS), profile.getSkillLevel(SkillType.FISHING), profile.getSkillLevel(SkillType.ALCHEMY), userId);
        return success &= this.saveIntegers("UPDATE " + this.tablePrefix + "experience SET " + " taming = ?, mining = ?, repair = ?, woodcutting = ?" + ", unarmed = ?, herbalism = ?, excavation = ?" + ", archery = ?, swords = ?, axes = ?, acrobatics = ?" + ", fishing = ?, alchemy = ? WHERE user_id = ?", profile.getSkillXpLevel(SkillType.TAMING), profile.getSkillXpLevel(SkillType.MINING), profile.getSkillXpLevel(SkillType.REPAIR), profile.getSkillXpLevel(SkillType.WOODCUTTING), profile.getSkillXpLevel(SkillType.UNARMED), profile.getSkillXpLevel(SkillType.HERBALISM), profile.getSkillXpLevel(SkillType.EXCAVATION), profile.getSkillXpLevel(SkillType.ARCHERY), profile.getSkillXpLevel(SkillType.SWORDS), profile.getSkillXpLevel(SkillType.AXES), profile.getSkillXpLevel(SkillType.ACROBATICS), profile.getSkillXpLevel(SkillType.FISHING), profile.getSkillXpLevel(SkillType.ALCHEMY), userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PlayerStat> readLeaderboard(SkillType skill, int pageNumber, int statsPerPage) {
        ArrayList<PlayerStat> stats = new ArrayList<PlayerStat>();
        if (this.checkConnected()) {
            String query = skill == null ? "taming+mining+woodcutting+repair+unarmed+herbalism+excavation+archery+swords+axes+acrobatics+fishing+alchemy" : skill.name().toLowerCase();
            Statement statement = null;
            try {
                statement = this.connection.prepareStatement("SELECT " + query + ", user, NOW() FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON (user_id = id) WHERE " + query + " > 0 ORDER BY " + query + " DESC, user LIMIT ?, ?");
                statement.setInt(1, pageNumber * statsPerPage - statsPerPage);
                statement.setInt(2, statsPerPage);
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    ArrayList<String> column = new ArrayList<String>();
                    for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                        column.add(resultSet.getString(i));
                    }
                    stats.add(new PlayerStat((String)column.get(1), Integer.valueOf((String)column.get(0))));
                }
            }
            catch (SQLException ex) {
                this.printErrors(ex);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
        return stats;
    }

    @Override
    public Map<SkillType, Integer> readRank(String playerName) {
        HashMap<SkillType, Integer> skills = new HashMap<SkillType, Integer>();
        if (this.checkConnected()) {
            try {
                ResultSet resultSet;
                for (SkillType skillType : SkillType.NON_CHILD_SKILLS) {
                    String skillName = skillType.name().toLowerCase();
                    String sql = "SELECT COUNT(*) AS rank FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE " + skillName + " > 0 " + "AND " + skillName + " > (SELECT " + skillName + " FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id " + "WHERE user = ?)";
                    PreparedStatement statement = this.connection.prepareStatement(sql);
                    statement.setString(1, playerName);
                    resultSet = statement.executeQuery();
                    resultSet.next();
                    int rank = resultSet.getInt("rank");
                    sql = "SELECT user, " + skillName + " FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE " + skillName + " > 0 " + "AND " + skillName + " = (SELECT " + skillName + " FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id " + "WHERE user = '" + playerName + "') ORDER BY user";
                    statement.close();
                    statement = this.connection.prepareStatement(sql);
                    resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        if (!resultSet.getString("user").equalsIgnoreCase(playerName)) continue;
                        skills.put(skillType, rank + resultSet.getRow());
                        break;
                    }
                    statement.close();
                }
                String sql = "SELECT COUNT(*) AS rank FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id " + "WHERE taming+mining+woodcutting+repair+unarmed+herbalism+excavation+archery+swords+axes+acrobatics+fishing+alchemy > 0 " + "AND taming+mining+woodcutting+repair+unarmed+herbalism+excavation+archery+swords+axes+acrobatics+fishing+alchemy > " + "(SELECT taming+mining+woodcutting+repair+unarmed+herbalism+excavation+archery+swords+axes+acrobatics+fishing+alchemy " + "FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE user = ?)";
                PreparedStatement statement = this.connection.prepareStatement(sql);
                statement.setString(1, playerName);
                resultSet = statement.executeQuery();
                resultSet.next();
                int rank = resultSet.getInt("rank");
                statement.close();
                sql = "SELECT user, taming+mining+woodcutting+repair+unarmed+herbalism+excavation+archery+swords+axes+acrobatics+fishing+alchemy FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id " + "WHERE taming+mining+woodcutting+repair+unarmed+herbalism+excavation+archery+swords+axes+acrobatics+fishing+alchemy > 0 " + "AND taming+mining+woodcutting+repair+unarmed+herbalism+excavation+archery+swords+axes+acrobatics+fishing+alchemy = " + "(SELECT taming+mining+woodcutting+repair+unarmed+herbalism+excavation+archery+swords+axes+acrobatics+fishing+alchemy " + "FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE user = ?) ORDER BY user";
                statement = this.connection.prepareStatement(sql);
                statement.setString(1, playerName);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    if (!resultSet.getString("user").equalsIgnoreCase(playerName)) continue;
                    skills.put(null, rank + resultSet.getRow());
                    break;
                }
                statement.close();
            }
            catch (SQLException ex) {
                this.printErrors(ex);
            }
        }
        return skills;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newUser(String playerName) {
        if (!this.checkConnected()) {
            return;
        }
        Statement statement = null;
        try {
            statement = this.connection.prepareStatement("INSERT INTO " + this.tablePrefix + "users (user, lastlogin) VALUES (?, ?)", 1);
            statement.setString(1, playerName);
            statement.setLong(2, System.currentTimeMillis() / 1000L);
            statement.execute();
            int id = this.readId(playerName);
            this.writeMissingRows(id);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public PlayerProfile loadPlayerProfile(String playerName, boolean create) {
        return this.loadPlayerProfile(playerName, create, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private PlayerProfile loadPlayerProfile(String playerName, boolean create, boolean retry) {
        if (!this.checkConnected()) {
            return new PlayerProfile(playerName, false);
        }
        statement = null;
        try {
            statement = this.connection.prepareStatement("SELECT s.taming, s.mining, s.repair, s.woodcutting, s.unarmed, s.herbalism, s.excavation, s.archery, s.swords, s.axes, s.acrobatics, s.fishing, s.alchemy, e.taming, e.mining, e.repair, e.woodcutting, e.unarmed, e.herbalism, e.excavation, e.archery, e.swords, e.axes, e.acrobatics, e.fishing, e.alchemy, c.taming, c.mining, c.repair, c.woodcutting, c.unarmed, c.herbalism, c.excavation, c.archery, c.swords, c.axes, c.acrobatics, c.blast_mining, h.mobhealthbar FROM " + this.tablePrefix + "users u " + "JOIN " + this.tablePrefix + "skills s ON (u.id = s.user_id) " + "JOIN " + this.tablePrefix + "experience e ON (u.id = e.user_id) " + "JOIN " + this.tablePrefix + "cooldowns c ON (u.id = c.user_id) " + "JOIN " + this.tablePrefix + "huds h ON (u.id = h.user_id) " + "WHERE u.user = ?");
            statement.setString(1, playerName);
            result = statement.executeQuery();
            if (!result.next()) ** GOTO lbl-1000
            try {
                ret = this.loadFromResult(playerName, result);
                result.close();
                var7_12 = ret;
                return var7_12;
            }
            catch (SQLException e) {
                try lbl-1000:
                // 2 sources

                {
                    result.close();
                }
                catch (SQLException ex) {
                    this.printErrors(ex);
                }
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
        if (!retry) {
            return new PlayerProfile(playerName, false);
        }
        id = this.readId(playerName);
        if (id == -1) {
            if (create) {
                this.newUser(playerName);
                return this.loadPlayerProfile(playerName, false, false);
            }
            return new PlayerProfile(playerName, false);
        }
        this.writeMissingRows(id);
        return this.loadPlayerProfile(playerName, create, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convertUsers(DatabaseManager destination) {
        if (!this.checkConnected()) {
            return;
        }
        Statement statement = null;
        try {
            statement = this.connection.prepareStatement("SELECT s.taming, s.mining, s.repair, s.woodcutting, s.unarmed, s.herbalism, s.excavation, s.archery, s.swords, s.axes, s.acrobatics, s.fishing, s.alchemy, e.taming, e.mining, e.repair, e.woodcutting, e.unarmed, e.herbalism, e.excavation, e.archery, e.swords, e.axes, e.acrobatics, e.fishing, e.alchemy, c.taming, c.mining, c.repair, c.woodcutting, c.unarmed, c.herbalism, c.excavation, c.archery, c.swords, c.axes, c.acrobatics, c.blast_mining, h.mobhealthbar FROM " + this.tablePrefix + "users u " + "JOIN " + this.tablePrefix + "skills s ON (u.id = s.user_id) " + "JOIN " + this.tablePrefix + "experience e ON (u.id = e.user_id) " + "JOIN " + this.tablePrefix + "cooldowns c ON (u.id = c.user_id) " + "JOIN " + this.tablePrefix + "huds h ON (u.id = h.user_id) " + "WHERE u.user = ?");
            List<String> usernames = this.getStoredUsers();
            int convertedUsers = 0;
            long startMillis = System.currentTimeMillis();
            for (String playerName : usernames) {
                statement.setString(1, playerName);
                try {
                    ResultSet resultSet = statement.executeQuery();
                    resultSet.next();
                    destination.saveUser(this.loadFromResult(playerName, resultSet));
                    resultSet.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                Misc.printProgress(++convertedUsers, 200, startMillis);
            }
        }
        catch (SQLException e) {
            this.printErrors(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public boolean checkConnected() {
        boolean exists;
        boolean isClosed = true;
        boolean isValid = false;
        boolean bl = exists = this.connection != null;
        if (this.nextReconnectTimestamp > 0L && this.nextReconnectTimestamp > System.nanoTime()) {
            return false;
        }
        if (exists) {
            try {
                isClosed = this.connection.isClosed();
            }
            catch (SQLException e) {
                isClosed = true;
                e.printStackTrace();
                this.printErrors(e);
            }
            if (!isClosed) {
                try {
                    isValid = this.connection.isValid(3);
                }
                catch (SQLException e) {
                    isValid = false;
                }
            }
        }
        if (exists && !isClosed && isValid) {
            this.nextReconnectTimestamp = 0L;
            this.reconnectAttempt = 0;
            return true;
        }
        if (exists && !isClosed) {
            try {
                this.connection.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
        }
        this.connect();
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                if (this.reconnectAttempt > 1) {
                    new SQLReconnectTask().runTaskLater((Plugin)mcMMO.p, 5L);
                }
                this.nextReconnectTimestamp = 0L;
                this.reconnectAttempt = 0;
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.printErrors(e);
        }
        ++this.reconnectAttempt;
        this.nextReconnectTimestamp = (long)((double)System.nanoTime() + Math.min(3.0E11, (double)this.reconnectAttempt * 40.0 * 5.0E8));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getStoredUsers() {
        ArrayList<String> users = new ArrayList<String>();
        if (this.checkConnected()) {
            Statement stmt = null;
            try {
                stmt = this.connection.createStatement();
                ResultSet result = stmt.executeQuery("SELECT user FROM " + this.tablePrefix + "users");
                while (result.next()) {
                    users.add(result.getString("user"));
                }
                result.close();
            }
            catch (SQLException e) {
                this.printErrors(e);
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return users;
    }

    private void connect() {
        block4: {
            this.connectionString = "jdbc:mysql://" + Config.getInstance().getMySQLServerName() + ":" + Config.getInstance().getMySQLServerPort() + "/" + Config.getInstance().getMySQLDatabaseName();
            try {
                mcMMO.p.getLogger().info("Attempting connection to MySQL...");
                Class.forName("com.mysql.jdbc.Driver");
                Properties connectionProperties = new Properties();
                connectionProperties.put("user", Config.getInstance().getMySQLUserName());
                connectionProperties.put("password", Config.getInstance().getMySQLUserPassword());
                connectionProperties.put("autoReconnect", "false");
                connectionProperties.put("maxReconnects", "0");
                this.connection = DriverManager.getConnection(this.connectionString, connectionProperties);
                mcMMO.p.getLogger().info("Connection to MySQL was a success!");
            }
            catch (SQLException ex) {
                this.connection = null;
                if (this.reconnectAttempt == 0 || this.reconnectAttempt >= 11) {
                    mcMMO.p.getLogger().severe("Connection to MySQL failed!");
                    this.printErrors(ex);
                }
            }
            catch (ClassNotFoundException ex) {
                this.connection = null;
                if (this.reconnectAttempt != 0 && this.reconnectAttempt < 11) break block4;
                mcMMO.p.getLogger().severe("MySQL database driver not found!");
            }
        }
    }

    private void checkStructure() {
        if (!this.checkConnected()) {
            return;
        }
        this.write("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "users` (" + "`id` int(10) unsigned NOT NULL AUTO_INCREMENT," + "`user` varchar(40) NOT NULL," + "`lastlogin` int(32) unsigned NOT NULL," + "PRIMARY KEY (`id`)," + "UNIQUE KEY `user` (`user`)) DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;");
        this.write("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "huds` (" + "`user_id` int(10) unsigned NOT NULL," + "`mobhealthbar` varchar(50) NOT NULL DEFAULT '" + (Object)((Object)Config.getInstance().getMobHealthbarDefault()) + "'," + "PRIMARY KEY (`user_id`)) " + "DEFAULT CHARSET=latin1;");
        this.write("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "cooldowns` (" + "`user_id` int(10) unsigned NOT NULL," + "`taming` int(32) unsigned NOT NULL DEFAULT '0'," + "`mining` int(32) unsigned NOT NULL DEFAULT '0'," + "`woodcutting` int(32) unsigned NOT NULL DEFAULT '0'," + "`repair` int(32) unsigned NOT NULL DEFAULT '0'," + "`unarmed` int(32) unsigned NOT NULL DEFAULT '0'," + "`herbalism` int(32) unsigned NOT NULL DEFAULT '0'," + "`excavation` int(32) unsigned NOT NULL DEFAULT '0'," + "`archery` int(32) unsigned NOT NULL DEFAULT '0'," + "`swords` int(32) unsigned NOT NULL DEFAULT '0'," + "`axes` int(32) unsigned NOT NULL DEFAULT '0'," + "`acrobatics` int(32) unsigned NOT NULL DEFAULT '0'," + "`blast_mining` int(32) unsigned NOT NULL DEFAULT '0'," + "PRIMARY KEY (`user_id`)) " + "DEFAULT CHARSET=latin1;");
        this.write("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "skills` (" + "`user_id` int(10) unsigned NOT NULL," + "`taming` int(10) unsigned NOT NULL DEFAULT '0'," + "`mining` int(10) unsigned NOT NULL DEFAULT '0'," + "`woodcutting` int(10) unsigned NOT NULL DEFAULT '0'," + "`repair` int(10) unsigned NOT NULL DEFAULT '0'," + "`unarmed` int(10) unsigned NOT NULL DEFAULT '0'," + "`herbalism` int(10) unsigned NOT NULL DEFAULT '0'," + "`excavation` int(10) unsigned NOT NULL DEFAULT '0'," + "`archery` int(10) unsigned NOT NULL DEFAULT '0'," + "`swords` int(10) unsigned NOT NULL DEFAULT '0'," + "`axes` int(10) unsigned NOT NULL DEFAULT '0'," + "`acrobatics` int(10) unsigned NOT NULL DEFAULT '0'," + "`fishing` int(10) unsigned NOT NULL DEFAULT '0'," + "`alchemy` int(10) unsigned NOT NULL DEFAULT '0'," + "PRIMARY KEY (`user_id`)) " + "DEFAULT CHARSET=latin1;");
        this.write("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "experience` (" + "`user_id` int(10) unsigned NOT NULL," + "`taming` int(10) unsigned NOT NULL DEFAULT '0'," + "`mining` int(10) unsigned NOT NULL DEFAULT '0'," + "`woodcutting` int(10) unsigned NOT NULL DEFAULT '0'," + "`repair` int(10) unsigned NOT NULL DEFAULT '0'," + "`unarmed` int(10) unsigned NOT NULL DEFAULT '0'," + "`herbalism` int(10) unsigned NOT NULL DEFAULT '0'," + "`excavation` int(10) unsigned NOT NULL DEFAULT '0'," + "`archery` int(10) unsigned NOT NULL DEFAULT '0'," + "`swords` int(10) unsigned NOT NULL DEFAULT '0'," + "`axes` int(10) unsigned NOT NULL DEFAULT '0'," + "`acrobatics` int(10) unsigned NOT NULL DEFAULT '0'," + "`fishing` int(10) unsigned NOT NULL DEFAULT '0'," + "`alchemy` int(10) unsigned NOT NULL DEFAULT '0'," + "PRIMARY KEY (`user_id`)) " + "DEFAULT CHARSET=latin1;");
        for (DatabaseUpdateType updateType : DatabaseUpdateType.values()) {
            this.checkDatabaseStructure(updateType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkDatabaseStructure(DatabaseUpdateType update) {
        String sql = "";
        switch (update) {
            case BLAST_MINING: {
                sql = "SELECT * FROM `" + this.tablePrefix + "cooldowns` ORDER BY `" + this.tablePrefix + "cooldowns`.`blast_mining` ASC LIMIT 0 , 30";
                break;
            }
            case FISHING: {
                sql = "SELECT * FROM `" + this.tablePrefix + "experience` ORDER BY `" + this.tablePrefix + "experience`.`fishing` ASC LIMIT 0 , 30";
                break;
            }
            case ALCHEMY: {
                sql = "SELECT * FROM `" + this.tablePrefix + "experience` ORDER BY `" + this.tablePrefix + "experience`.`alchemy` ASC LIMIT 0 , 30";
                break;
            }
            case INDEX: {
                if (this.read("SHOW INDEX FROM " + this.tablePrefix + "skills").size() == 13) return;
                if (!this.checkConnected()) return;
                mcMMO.p.getLogger().info("Indexing tables, this may take a while on larger databases");
                this.write("ALTER TABLE `" + this.tablePrefix + "skills` ADD INDEX `idx_taming` (`taming`) USING BTREE, " + "ADD INDEX `idx_mining` (`mining`) USING BTREE, " + "ADD INDEX `idx_woodcutting` (`woodcutting`) USING BTREE, " + "ADD INDEX `idx_repair` (`repair`) USING BTREE, " + "ADD INDEX `idx_unarmed` (`unarmed`) USING BTREE, " + "ADD INDEX `idx_herbalism` (`herbalism`) USING BTREE, " + "ADD INDEX `idx_excavation` (`excavation`) USING BTREE, " + "ADD INDEX `idx_archery` (`archery`) USING BTREE, " + "ADD INDEX `idx_swords` (`swords`) USING BTREE, " + "ADD INDEX `idx_axes` (`axes`) USING BTREE, " + "ADD INDEX `idx_acrobatics` (`acrobatics`) USING BTREE, " + "ADD INDEX `idx_fishing` (`fishing`) USING BTREE;");
                return;
            }
            case MOB_HEALTHBARS: {
                sql = "SELECT * FROM `" + this.tablePrefix + "huds` ORDER BY `" + this.tablePrefix + "huds`.`mobhealthbar` ASC LIMIT 0 , 30";
                break;
            }
            case PARTY_NAMES: {
                this.write("ALTER TABLE `" + this.tablePrefix + "users` DROP COLUMN `party` ;");
                return;
            }
            case DROPPED_SPOUT: {
                this.write("ALTER TABLE `" + this.tablePrefix + "huds` DROP COLUMN `hudtype` ;");
                return;
            }
            case KILL_ORPHANS: {
                mcMMO.p.getLogger().info("Killing orphans");
                this.write("DELETE FROM " + this.tablePrefix + "experience " + "WHERE NOT EXISTS (SELECT * FROM " + this.tablePrefix + "users u WHERE " + this.tablePrefix + "experience.user_id = u.id);");
                this.write("DELETE FROM " + this.tablePrefix + "huds " + "WHERE NOT EXISTS (SELECT * FROM " + this.tablePrefix + "users u WHERE " + this.tablePrefix + "huds.user_id = u.id);");
                this.write("DELETE FROM " + this.tablePrefix + "cooldowns " + "WHERE NOT EXISTS (SELECT * FROM " + this.tablePrefix + "users u WHERE " + this.tablePrefix + "cooldowns.user_id = u.id);");
                this.write("DELETE FROM " + this.tablePrefix + "skills " + "WHERE NOT EXISTS (SELECT * FROM " + this.tablePrefix + "users u WHERE " + this.tablePrefix + "skills.user_id = u.id);");
                return;
            }
        }
        Statement statement = null;
        try {
            if (!this.checkConnected()) {
                return;
            }
            statement = this.connection.prepareStatement(sql);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
            }
            return;
        }
        catch (SQLException ex) {
            switch (update) {
                case BLAST_MINING: {
                    mcMMO.p.getLogger().info("Updating mcMMO MySQL tables for Blast Mining...");
                    this.write("ALTER TABLE `" + this.tablePrefix + "cooldowns` ADD `blast_mining` int(32) NOT NULL DEFAULT '0' ;");
                    return;
                }
                case FISHING: {
                    mcMMO.p.getLogger().info("Updating mcMMO MySQL tables for Fishing...");
                    this.write("ALTER TABLE `" + this.tablePrefix + "skills` ADD `fishing` int(10) NOT NULL DEFAULT '0' ;");
                    this.write("ALTER TABLE `" + this.tablePrefix + "experience` ADD `fishing` int(10) NOT NULL DEFAULT '0' ;");
                    return;
                }
                case MOB_HEALTHBARS: {
                    mcMMO.p.getLogger().info("Updating mcMMO MySQL tables for mob healthbars...");
                    this.write("ALTER TABLE `" + this.tablePrefix + "huds` ADD `mobhealthbar` varchar(50) NOT NULL DEFAULT '" + (Object)((Object)Config.getInstance().getMobHealthbarDefault()) + "' ;");
                    return;
                }
                case ALCHEMY: {
                    mcMMO.p.getLogger().info("Updating mcMMO MySQL tables for Alchemy...");
                    this.write("ALTER TABLE `" + this.tablePrefix + "skills` ADD `alchemy` int(10) NOT NULL DEFAULT '0' ;");
                    this.write("ALTER TABLE `" + this.tablePrefix + "experience` ADD `alchemy` int(10) NOT NULL DEFAULT '0' ;");
                    return;
                }
            }
            return;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean write(String sql) {
        if (!this.checkConnected()) {
            return false;
        }
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(sql);
            statement.executeUpdate();
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            if (!sql.contains("DROP COLUMN")) {
                this.printErrors(ex);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int update(String sql) {
        int rows = 0;
        if (this.checkConnected()) {
            PreparedStatement statement = null;
            try {
                statement = this.connection.prepareStatement(sql);
                rows = statement.executeUpdate();
            }
            catch (SQLException ex) {
                this.printErrors(ex);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<Integer, ArrayList<String>> read(String sql) {
        HashMap<Integer, ArrayList<String>> rows = new HashMap<Integer, ArrayList<String>>();
        if (this.checkConnected()) {
            PreparedStatement statement = null;
            try {
                statement = this.connection.prepareStatement(sql);
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    ArrayList<String> column = new ArrayList<String>();
                    for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                        column.add(resultSet.getString(i));
                    }
                    rows.put(resultSet.getRow(), column);
                }
            }
            catch (SQLException ex) {
                this.printErrors(ex);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readInt(PreparedStatement statement) {
        int result = -1;
        if (this.checkConnected()) {
            try {
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    result = resultSet.getInt(1);
                }
            }
            catch (SQLException ex) {
                this.printErrors(ex);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMissingRows(int id) {
        Statement statement = null;
        try {
            statement = this.connection.prepareStatement("INSERT IGNORE INTO " + this.tablePrefix + "experience (user_id) VALUES (?)");
            statement.setInt(1, id);
            statement.execute();
            statement.close();
            statement = this.connection.prepareStatement("INSERT IGNORE INTO " + this.tablePrefix + "skills (user_id) VALUES (?)");
            statement.setInt(1, id);
            statement.execute();
            statement.close();
            statement = this.connection.prepareStatement("INSERT IGNORE INTO " + this.tablePrefix + "cooldowns (user_id) VALUES (?)");
            statement.setInt(1, id);
            statement.execute();
            statement.close();
            statement = this.connection.prepareStatement("INSERT IGNORE INTO " + this.tablePrefix + "huds (user_id, mobhealthbar) VALUES (? ,'" + Config.getInstance().getMobHealthbarDefault().name() + "')");
            statement.setInt(1, id);
            statement.execute();
            statement.close();
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void processPurge(Collection<ArrayList<String>> usernames) {
        for (ArrayList<String> user : usernames) {
            Misc.profileCleanup(user.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveIntegers(String sql, int ... args) {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(sql);
            int i = 1;
            for (int arg : args) {
                statement.setInt(i++, arg);
            }
            statement.execute();
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            this.printErrors(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveLongs(String sql, int id, long ... args) {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(sql);
            int i = 1;
            for (long arg : args) {
                statement.setLong(i++, arg);
            }
            statement.setInt(i++, id);
            statement.execute();
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            this.printErrors(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private int readId(String playerName) {
        int id = -1;
        try {
            PreparedStatement statement = this.connection.prepareStatement("SELECT id FROM " + this.tablePrefix + "users WHERE user = ?");
            statement.setString(1, playerName);
            id = this.readInt(statement);
        }
        catch (SQLException ex) {
            this.printErrors(ex);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveLogin(int id, long login) {
        Statement statement = null;
        try {
            statement = this.connection.prepareStatement("UPDATE " + this.tablePrefix + "users SET lastlogin = ? WHERE id = ?");
            statement.setLong(1, login);
            statement.setInt(2, id);
            statement.execute();
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            this.printErrors(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveHuds(int userId, String mobHealthBar) {
        Statement statement = null;
        try {
            statement = this.connection.prepareStatement("UPDATE " + this.tablePrefix + "huds SET mobhealthbar = ? WHERE user_id = ?");
            statement.setString(1, mobHealthBar);
            statement.setInt(2, userId);
            statement.execute();
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            this.printErrors(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private PlayerProfile loadFromResult(String playerName, ResultSet result) throws SQLException {
        MobHealthbarType mobHealthbarType;
        HashMap<SkillType, Integer> skills = new HashMap<SkillType, Integer>();
        HashMap<SkillType, Float> skillsXp = new HashMap<SkillType, Float>();
        HashMap<AbilityType, Integer> skillsDATS = new HashMap<AbilityType, Integer>();
        boolean OFFSET_SKILLS = false;
        int OFFSET_XP = 13;
        int OFFSET_DATS = 26;
        int OFFSET_OTHER = 38;
        skills.put(SkillType.TAMING, result.getInt(1));
        skills.put(SkillType.MINING, result.getInt(2));
        skills.put(SkillType.REPAIR, result.getInt(3));
        skills.put(SkillType.WOODCUTTING, result.getInt(4));
        skills.put(SkillType.UNARMED, result.getInt(5));
        skills.put(SkillType.HERBALISM, result.getInt(6));
        skills.put(SkillType.EXCAVATION, result.getInt(7));
        skills.put(SkillType.ARCHERY, result.getInt(8));
        skills.put(SkillType.SWORDS, result.getInt(9));
        skills.put(SkillType.AXES, result.getInt(10));
        skills.put(SkillType.ACROBATICS, result.getInt(11));
        skills.put(SkillType.FISHING, result.getInt(12));
        skills.put(SkillType.ALCHEMY, result.getInt(13));
        skillsXp.put(SkillType.TAMING, Float.valueOf(result.getFloat(14)));
        skillsXp.put(SkillType.MINING, Float.valueOf(result.getFloat(15)));
        skillsXp.put(SkillType.REPAIR, Float.valueOf(result.getFloat(16)));
        skillsXp.put(SkillType.WOODCUTTING, Float.valueOf(result.getFloat(17)));
        skillsXp.put(SkillType.UNARMED, Float.valueOf(result.getFloat(18)));
        skillsXp.put(SkillType.HERBALISM, Float.valueOf(result.getFloat(19)));
        skillsXp.put(SkillType.EXCAVATION, Float.valueOf(result.getFloat(20)));
        skillsXp.put(SkillType.ARCHERY, Float.valueOf(result.getFloat(21)));
        skillsXp.put(SkillType.SWORDS, Float.valueOf(result.getFloat(22)));
        skillsXp.put(SkillType.AXES, Float.valueOf(result.getFloat(23)));
        skillsXp.put(SkillType.ACROBATICS, Float.valueOf(result.getFloat(24)));
        skillsXp.put(SkillType.FISHING, Float.valueOf(result.getFloat(25)));
        skillsXp.put(SkillType.ALCHEMY, Float.valueOf(result.getFloat(26)));
        skillsDATS.put(AbilityType.SUPER_BREAKER, result.getInt(28));
        skillsDATS.put(AbilityType.TREE_FELLER, result.getInt(30));
        skillsDATS.put(AbilityType.BERSERK, result.getInt(31));
        skillsDATS.put(AbilityType.GREEN_TERRA, result.getInt(32));
        skillsDATS.put(AbilityType.GIGA_DRILL_BREAKER, result.getInt(33));
        skillsDATS.put(AbilityType.SERRATED_STRIKES, result.getInt(35));
        skillsDATS.put(AbilityType.SKULL_SPLITTER, result.getInt(36));
        skillsDATS.put(AbilityType.BLAST_MINING, result.getInt(38));
        try {
            mobHealthbarType = MobHealthbarType.valueOf(result.getString(40));
        }
        catch (Exception e) {
            mobHealthbarType = Config.getInstance().getMobHealthbarDefault();
        }
        return new PlayerProfile(playerName, skills, skillsXp, skillsDATS, mobHealthbarType);
    }

    private void printErrors(SQLException ex) {
        mcMMO.p.getLogger().severe("SQLException: " + ex.getMessage());
        mcMMO.p.getLogger().severe("SQLState: " + ex.getSQLState());
        mcMMO.p.getLogger().severe("VendorError: " + ex.getErrorCode());
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.SQL;
    }
}

