/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.events.fake.FakeEntityDamageByEntityEvent;
import com.gmail.nossr50.events.fake.FakeEntityDamageEvent;
import com.gmail.nossr50.events.fake.FakeEntityTameEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.runnables.skills.BleedTimerTask;
import com.gmail.nossr50.skills.acrobatics.AcrobaticsManager;
import com.gmail.nossr50.skills.archery.Archery;
import com.gmail.nossr50.skills.fishing.Fishing;
import com.gmail.nossr50.skills.herbalism.Herbalism;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.skills.taming.Taming;
import com.gmail.nossr50.skills.taming.TamingManager;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class EntityListener
implements Listener {
    private final mcMMO plugin;

    public EntityListener(mcMMO plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityShootBow(EntityShootBowEvent event) {
        Entity projectile = event.getProjectile();
        if (!(projectile instanceof Arrow)) {
            return;
        }
        if (event.getBow().containsEnchantment(Enchantment.ARROW_INFINITE)) {
            projectile.setMetadata("mcMMO: Infinite Arrow", (MetadataValue)mcMMO.metadataValue);
        }
        projectile.setMetadata("mcMMO: Bow Force", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)Math.min((double)event.getForce() * AdvancedConfig.getInstance().getForceMultiplier(), 1.0)));
        projectile.setMetadata("mcMMO: Arrow Distance", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)projectile.getLocation()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof Arrow) || projectile.hasMetadata("mcMMO: Bow Force")) {
            return;
        }
        projectile.setMetadata("mcMMO: Bow Force", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)1.0));
        projectile.setMetadata("mcMMO: Arrow Distance", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)projectile.getLocation()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Block block = event.getBlock();
        if (!BlockUtils.shouldBeWatched(block.getState())) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlock || entity instanceof Enderman) {
            boolean isTracked = entity.hasMetadata("mcMMO: Spawned Entity");
            if (mcMMO.getPlaceStore().isTrue(block) && !isTracked) {
                mcMMO.getPlaceStore().setFalse(block);
                entity.setMetadata("mcMMO: Spawned Entity", (MetadataValue)mcMMO.metadataValue);
            } else if (isTracked) {
                mcMMO.getPlaceStore().setTrue(block);
            }
        } else if (mcMMO.getPlaceStore().isTrue(block)) {
            mcMMO.getPlaceStore().setFalse(block);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        AnimalTamer animalTamer;
        if (event instanceof FakeEntityDamageByEntityEvent) {
            return;
        }
        double damage = event.getDamage();
        if (damage <= 0.0) {
            return;
        }
        Entity defender = event.getEntity();
        if (defender.hasMetadata("mcMMO: Custom Damage")) {
            defender.removeMetadata("mcMMO: Custom Damage", (Plugin)this.plugin);
            return;
        }
        if (Misc.isNPCEntity(defender) || !defender.isValid() || !(defender instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)defender;
        if (CombatUtils.isInvincible(target, damage)) {
            return;
        }
        Entity attacker = event.getDamager();
        if (Misc.isNPCEntity(attacker)) {
            return;
        }
        if (attacker instanceof Projectile) {
            ProjectileSource projectileSource = ((Projectile)attacker).getShooter();
            if (projectileSource instanceof LivingEntity) {
                attacker = (LivingEntity)projectileSource;
            }
        } else if (attacker instanceof Tameable && (animalTamer = ((Tameable)attacker).getOwner()) != null && ((OfflinePlayer)animalTamer).isOnline()) {
            attacker = (Entity)animalTamer;
        }
        if (defender instanceof Player && attacker instanceof Player) {
            Player defendingPlayer = (Player)defender;
            Player attackingPlayer = (Player)attacker;
            if (!UserManager.hasPlayerDataKey((Entity)defendingPlayer) || !UserManager.hasPlayerDataKey((Entity)attackingPlayer)) {
                return;
            }
            if (defendingPlayer.equals(attackingPlayer)) {
                return;
            }
            if (!(!PartyManager.inSameParty(defendingPlayer, attackingPlayer) && !PartyManager.areAllies(defendingPlayer, attackingPlayer) || Permissions.friendlyFire((Permissible)attackingPlayer) && Permissions.friendlyFire((Permissible)defendingPlayer))) {
                event.setCancelled(true);
                return;
            }
        }
        CombatUtils.processCombatAttack(event, attacker, target);
        CombatUtils.handleHealthbars(attacker, target, event.getDamage());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        AnimalTamer owner;
        Tameable pet;
        if (event instanceof FakeEntityDamageEvent) {
            return;
        }
        double damage = event.getDamage();
        if (damage <= 0.0) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity.hasMetadata("mcMMO: Custom Damage")) {
            entity.removeMetadata("mcMMO: Custom Damage", (Plugin)this.plugin);
            return;
        }
        if (Misc.isNPCEntity(entity) || !entity.isValid() || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (CombatUtils.isInvincible(livingEntity, damage)) {
            return;
        }
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (livingEntity instanceof Player) {
            Player player = (Player)entity;
            if (!UserManager.hasPlayerDataKey((Entity)player)) {
                return;
            }
            McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
            if (mcMMOPlayer.getGodMode()) {
                event.setCancelled(true);
                return;
            }
            switch (cause) {
                case FALL: {
                    if (!SkillUtils.cooldownExpired(mcMMOPlayer.getTeleportATS(), Config.getInstance().getXPAfterTeleportCooldown())) {
                        return;
                    }
                    AcrobaticsManager acrobaticsManager = mcMMOPlayer.getAcrobaticsManager();
                    if (!acrobaticsManager.canRoll()) break;
                    event.setDamage(acrobaticsManager.rollCheck(event.getDamage()));
                    if (event.getDamage() != 0.0) break;
                    event.setCancelled(true);
                    return;
                }
                case BLOCK_EXPLOSION: {
                    MiningManager miningManager = mcMMOPlayer.getMiningManager();
                    if (!miningManager.canUseDemolitionsExpertise()) break;
                    event.setDamage(miningManager.processDemolitionsExpertise(event.getDamage()));
                    if (event.getDamage() != 0.0) break;
                    event.setCancelled(true);
                    return;
                }
            }
            if (event.getDamage() >= 1.0) {
                mcMMOPlayer.actualizeRecentlyHurt();
            }
        } else if (livingEntity instanceof Tameable && Taming.canPreventDamage(pet = (Tameable)livingEntity, owner = pet.getOwner())) {
            Player player = (Player)owner;
            Wolf wolf = (Wolf)pet;
            TamingManager tamingManager = UserManager.getPlayer(player).getTamingManager();
            switch (cause) {
                case CONTACT: 
                case FIRE: 
                case LAVA: {
                    if (tamingManager.canUseEnvironmentallyAware()) {
                        tamingManager.processEnvironmentallyAware(wolf, event.getDamage());
                    }
                    return;
                }
                case FALL: {
                    if (tamingManager.canUseEnvironmentallyAware()) {
                        event.setCancelled(true);
                    }
                    return;
                }
                case ENTITY_ATTACK: 
                case PROJECTILE: {
                    if (tamingManager.canUseThickFur()) {
                        event.setDamage(Taming.processThickFur(wolf, event.getDamage()));
                        if (event.getDamage() == 0.0) {
                            event.setCancelled(true);
                        }
                    }
                    return;
                }
                case FIRE_TICK: {
                    if (tamingManager.canUseThickFur()) {
                        Taming.processThickFurFire(wolf);
                    }
                    return;
                }
                case MAGIC: 
                case POISON: 
                case WITHER: {
                    if (tamingManager.canUseHolyHound()) {
                        Taming.processHolyHound(wolf, event.getDamage());
                    }
                    return;
                }
                case BLOCK_EXPLOSION: 
                case ENTITY_EXPLOSION: 
                case LIGHTNING: {
                    if (tamingManager.canUseShockProof()) {
                        event.setDamage(Taming.processShockProof(wolf, event.getDamage()));
                        if (event.getDamage() == 0.0) {
                            event.setCancelled(true);
                        }
                    }
                    return;
                }
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDeathLowest(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (Misc.isNPCEntity((Entity)entity)) {
            return;
        }
        if (entity.hasMetadata("mcMMO: Custom Name")) {
            entity.setCustomName(((MetadataValue)entity.getMetadata("mcMMO: Custom Name").get(0)).asString());
            entity.removeMetadata("mcMMO: Custom Name", (Plugin)this.plugin);
        }
        if (entity.hasMetadata("mcMMO: Name Visibility")) {
            entity.setCustomNameVisible(((MetadataValue)entity.getMetadata("mcMMO: Name Visibility").get(0)).asBoolean());
            entity.removeMetadata("mcMMO: Name Visibility", (Plugin)this.plugin);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (Misc.isNPCEntity((Entity)entity)) {
            return;
        }
        BleedTimerTask.remove(entity);
        Archery.arrowRetrievalCheck(entity);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        switch (event.getSpawnReason()) {
            case SPAWNER: 
            case SPAWNER_EGG: {
                LivingEntity entity = event.getEntity();
                Entity passenger = entity.getPassenger();
                entity.setMetadata("mcMMO: Spawned Entity", (MetadataValue)mcMMO.metadataValue);
                if (passenger != null) {
                    passenger.setMetadata("mcMMO: Spawned Entity", (MetadataValue)mcMMO.metadataValue);
                }
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExplosionPrime(ExplosionPrimeEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof TNTPrimed) || !entity.hasMetadata("mcMMO: Tracked TNT")) {
            return;
        }
        Player player = this.plugin.getServer().getPlayerExact(((MetadataValue)entity.getMetadata("mcMMO: Tracked TNT").get(0)).asString());
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        MiningManager miningManager = UserManager.getPlayer(player).getMiningManager();
        if (miningManager.canUseBiggerBombs()) {
            event.setRadius(miningManager.biggerBombs(event.getRadius()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEnitityExplode(EntityExplodeEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof TNTPrimed) || !entity.hasMetadata("mcMMO: Tracked TNT")) {
            return;
        }
        Player player = this.plugin.getServer().getPlayerExact(((MetadataValue)entity.getMetadata("mcMMO: Tracked TNT").get(0)).asString());
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        MiningManager miningManager = UserManager.getPlayer(player).getMiningManager();
        if (miningManager.canUseBlastMining()) {
            miningManager.blastMiningDropProcessing(event.getYield(), event.blockList());
            event.setYield(0.0f);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityExplodeMonitor(EntityExplodeEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof TNTPrimed) || !entity.hasMetadata("mcMMO: Safe TNT")) {
            return;
        }
        event.blockList().clear();
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        HumanEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        int currentFoodLevel = player.getFoodLevel();
        int newFoodLevel = event.getFoodLevel();
        int foodChange = newFoodLevel - currentFoodLevel;
        if (foodChange <= 0) {
            return;
        }
        switch (player.getItemInHand().getType()) {
            case BAKED_POTATO: 
            case BREAD: 
            case CARROT_ITEM: 
            case GOLDEN_CARROT: 
            case MUSHROOM_SOUP: 
            case PUMPKIN_PIE: {
                if (Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.FARMERS_DIET)) {
                    event.setFoodLevel(UserManager.getPlayer(player).getHerbalismManager().farmersDiet(Herbalism.farmersDietRankLevel1, newFoodLevel));
                }
                return;
            }
            case COOKIE: 
            case MELON: 
            case POISONOUS_POTATO: 
            case POTATO_ITEM: {
                if (Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.FARMERS_DIET)) {
                    event.setFoodLevel(UserManager.getPlayer(player).getHerbalismManager().farmersDiet(Herbalism.farmersDietRankLevel2, newFoodLevel));
                }
                return;
            }
            case COOKED_FISH: {
                if (Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.FISHERMANS_DIET)) {
                    event.setFoodLevel(UserManager.getPlayer(player).getFishingManager().handleFishermanDiet(Fishing.fishermansDietRankLevel1, newFoodLevel));
                }
                return;
            }
            case RAW_FISH: {
                if (Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.FISHERMANS_DIET)) {
                    event.setFoodLevel(UserManager.getPlayer(player).getFishingManager().handleFishermanDiet(Fishing.fishermansDietRankLevel2, newFoodLevel));
                }
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityTame(EntityTameEvent event) {
        if (event instanceof FakeEntityTameEvent) {
            return;
        }
        Player player = (Player)event.getOwner();
        LivingEntity entity = event.getEntity();
        if (!UserManager.hasPlayerDataKey((Entity)player) || Misc.isNPCEntity((Entity)entity) || entity.hasMetadata("mcMMO: Spawned Entity")) {
            return;
        }
        entity.setMetadata("mcMMO: Spawned Entity", (MetadataValue)mcMMO.metadataValue);
        UserManager.getPlayer(player).getTamingManager().awardTamingXP(entity);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent event) {
        Entity entity = event.getEntity();
        Entity target = event.getTarget();
        if (!(entity instanceof Tameable) || !(target instanceof Player)) {
            return;
        }
        Player player = (Player)target;
        Tameable tameable = (Tameable)entity;
        if (!CombatUtils.isFriendlyPet(player, tameable)) {
            return;
        }
        if (!Permissions.friendlyFire((Permissible)player) || !Permissions.friendlyFire((Permissible)((Player)tameable.getOwner()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPotionSplash(PotionSplashEvent event) {
        for (PotionEffect effect : ((PotionMeta)event.getPotion().getItem().getItemMeta()).getCustomEffects()) {
            if (!effect.getType().equals((Object)PotionEffectType.SATURATION)) {
                return;
            }
            for (LivingEntity entity : event.getAffectedEntities()) {
                int duration = (int)((double)effect.getDuration() * event.getIntensity(entity));
                entity.addPotionEffect(new PotionEffect(effect.getType(), duration, effect.getAmplifier(), effect.isAmbient()));
            }
        }
    }
}

