/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.metrics;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.HiddenConfig;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.metrics.mcstats.EMetrics;
import com.gmail.nossr50.metrics.mcstats.Metrics;
import com.gmail.nossr50.metrics.mcstats.data.DataEvent;
import com.gmail.nossr50.metrics.mcstats.data.DataTracker;
import com.gmail.nossr50.metrics.mcstats.tracker.Tracker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import org.bukkit.plugin.Plugin;

public class MetricsManager {
    private static boolean setup = false;
    private static Tracker chimeraUseTracker;
    private static Tracker chimeraServerUseTracker;
    private static boolean customConfig;
    private static DataTracker tracker;
    private static EMetrics emetrics;

    public static void setup() {
        if (setup) {
            return;
        }
        if (Config.getInstance().getStatsTrackingEnabled()) {
            try {
                emetrics = new EMetrics((Plugin)mcMMO.p);
                Metrics metrics = emetrics.getMetrics();
                Metrics.Graph timingsGraph = metrics.createGraph("Percentage of servers using timings");
                if (mcMMO.p.getServer().getPluginManager().useTimings()) {
                    timingsGraph.addPlotter(new Metrics.Plotter("Enabled"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                } else {
                    timingsGraph.addPlotter(new Metrics.Plotter("Disabled"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                }
                Metrics.Graph versionDonutGraph = metrics.createGraph("Donut Version");
                boolean haveVersionInformation = false;
                boolean isOfficialBuild = false;
                String officialKey = "e14cfacdd442a953343ebd8529138680";
                String version = mcMMO.p.getDescription().getVersion();
                InputStreamReader isr = new InputStreamReader(mcMMO.p.getResource(".jenkins"));
                BufferedReader br = new BufferedReader(isr);
                char[] key = new char[32];
                br.read(key);
                if (officialKey.equals(String.valueOf(key))) {
                    isOfficialBuild = true;
                }
                if (version.contains("-")) {
                    int startIndex;
                    String majorVersion = version.substring(0, version.indexOf("-"));
                    String subVersion = isOfficialBuild ? (version.substring((startIndex = version.indexOf("-")) + 1).contains("-") ? version.substring(startIndex, version.indexOf("-", startIndex + 1)) : "-release") : "-custom";
                    version = majorVersion + "~=~" + subVersion;
                    haveVersionInformation = true;
                }
                if (haveVersionInformation) {
                    versionDonutGraph.addPlotter(new Metrics.Plotter(version){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                }
                Metrics.Graph officialGraph = metrics.createGraph("Built by official ci");
                if (isOfficialBuild) {
                    officialGraph.addPlotter(new Metrics.Plotter("Yes"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                } else {
                    officialGraph.addPlotter(new Metrics.Plotter("No"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                }
                Metrics.Graph chunkmetaGraph = metrics.createGraph("Uses Chunkmeta");
                if (HiddenConfig.getInstance().getChunkletsEnabled()) {
                    chunkmetaGraph.addPlotter(new Metrics.Plotter("Yes"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                } else {
                    chunkmetaGraph.addPlotter(new Metrics.Plotter("No"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                }
                Metrics.Graph storageGraph = metrics.createGraph("Storage method");
                if (Config.getInstance().getUseMySQL()) {
                    storageGraph.addPlotter(new Metrics.Plotter("SQL"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                } else {
                    storageGraph.addPlotter(new Metrics.Plotter("Flatfile"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                }
                Metrics.Graph localeGraph = metrics.createGraph("Locale");
                localeGraph.addPlotter(new Metrics.Plotter(LocaleLoader.getCurrentLocale().getDisplayLanguage(Locale.US)){

                    @Override
                    public int getValue() {
                        return 1;
                    }
                });
                Metrics.Graph experienceFormulaShapeGraph = metrics.createGraph("Experience Formula Shape Graph");
                experienceFormulaShapeGraph.addPlotter(new Metrics.Plotter(ExperienceConfig.getInstance().getFormulaType().toString()){

                    @Override
                    public int getValue() {
                        return 1;
                    }
                });
                Metrics.Graph globalMultiplierGraph = metrics.createGraph("Global Multiplier Graph");
                globalMultiplierGraph.addPlotter(new Metrics.Plotter(ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier() + ""){

                    @Override
                    public int getValue() {
                        return 1;
                    }
                });
                Metrics.Graph globalCurveModifierGraph = metrics.createGraph("Global Curve Modifier Graph");
                globalCurveModifierGraph.addPlotter(new Metrics.Plotter(ExperienceConfig.getInstance().getMultiplier(FormulaType.LINEAR) + ""){

                    @Override
                    public int getValue() {
                        return 1;
                    }
                });
                Metrics.Graph globalMultiplierGraphFuzzy = metrics.createGraph("Global Multiplier Fuzz");
                if (ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier() > 1.0) {
                    globalMultiplierGraphFuzzy.addPlotter(new Metrics.Plotter("Higher"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                } else if (ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier() < 1.0) {
                    globalMultiplierGraphFuzzy.addPlotter(new Metrics.Plotter("Lower"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                } else {
                    globalMultiplierGraphFuzzy.addPlotter(new Metrics.Plotter("Default"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                }
                Metrics.Graph globalCurveMultiplierGraphFuzzy = metrics.createGraph("Global Curve Multiplier Fuzz");
                if (ExperienceConfig.getInstance().getMultiplier(FormulaType.LINEAR) > 20.0) {
                    globalCurveMultiplierGraphFuzzy.addPlotter(new Metrics.Plotter("Higher"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                } else if (ExperienceConfig.getInstance().getMultiplier(FormulaType.LINEAR) < 20.0) {
                    globalCurveMultiplierGraphFuzzy.addPlotter(new Metrics.Plotter("Lower"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                } else {
                    globalCurveMultiplierGraphFuzzy.addPlotter(new Metrics.Plotter("Default"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                }
                String chimeraGraphName = "Chimera Wing Usage";
                chimeraUseTracker = EMetrics.createBasicTracker("Chimera Wing Usage", "Player use");
                chimeraServerUseTracker = EMetrics.createEnabledTracker("Chimera Wing Usage", "Server use");
                emetrics.addTracker(chimeraUseTracker);
                emetrics.addTracker(chimeraServerUseTracker);
                Metrics.Graph chimeraGraph = metrics.createGraph("Chimera Wing");
                if (Config.getInstance().getChimaeraEnabled()) {
                    chimeraGraph.addPlotter(new Metrics.Plotter("Enabled"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                } else {
                    chimeraGraph.addPlotter(new Metrics.Plotter("Disabled"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                }
                Metrics.Graph customConfigGraph = metrics.createGraph("Modified Configs");
                if (customConfig) {
                    customConfigGraph.addPlotter(new Metrics.Plotter("Edited"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                } else {
                    customConfigGraph.addPlotter(new Metrics.Plotter("Vanilla"){

                        @Override
                        public int getValue() {
                            return 1;
                        }
                    });
                }
                emetrics.startMetrics();
            }
            catch (IOException e) {
                mcMMO.p.getLogger().warning("Failed to submit stats.");
            }
        }
    }

    public static void chimeraWingUsed() {
        chimeraUseTracker.increment();
        chimeraServerUseTracker.increment();
    }

    public static void customConfig() {
        customConfig = true;
    }

    private static void debug() {
        emetrics.getMetrics().flush();
        for (DataEvent event : tracker.getEvents()) {
            String graphName = event.getGraphName();
            String colName = event.getTrackerName();
            int value = event.getValueSent();
            System.out.println("Graph: " + graphName + ", Column: " + colName + ", Value: " + value);
        }
        tracker.resetEvents();
    }

    static {
        customConfig = false;
    }
}

