/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.metrics.mcstats;

import com.gmail.nossr50.metrics.mcstats.EMetrics;
import com.gmail.nossr50.metrics.mcstats.Timer;
import com.gmail.nossr50.metrics.mcstats.data.DataEvent;
import com.gmail.nossr50.metrics.mcstats.data.DataTracker;
import com.gmail.nossr50.metrics.mcstats.logging.EMetricsLogger;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.scheduler.BukkitTask;

public class Metrics {
    static final int REVISION = 7;
    protected String BASE_URL = "http://report.mcstats.org";
    private static final String REPORT_URL = "/plugin/%s";
    static int PING_INTERVAL = 15;
    private final Plugin plugin;
    private final Set<Graph> graphs = Collections.synchronizedSet(new HashSet());
    private final YamlConfiguration configuration;
    private final File configurationFile;
    private final YamlConfiguration econfiguration;
    private final File econfigurationFile;
    protected File configFile;
    protected File econfigFile;
    private final String guid;
    protected final boolean naturalDebug;
    protected boolean pluginDebug = false;
    private final Object optOutLock = new Object();
    private volatile BukkitTask task = null;
    protected DataTracker dataTracker = new DataTracker();
    protected boolean pluginLog = false;
    protected boolean naturalLog = false;
    private boolean firstPost = true;
    protected final EMetricsLogger log;
    private final int timeout;
    protected final Graph defaultGraph = new Graph("Default");

    public Metrics(Plugin plugin) throws IOException {
        this(plugin, null, null);
    }

    public Metrics(Plugin plugin, File config, File emetricsConfig) throws IOException {
        if (config != null) {
            this.configFile = config;
        }
        if (emetricsConfig != null) {
            this.econfigFile = emetricsConfig;
        }
        if (plugin == null) {
            IllegalArgumentException exception = new IllegalArgumentException("Plugin cannot be null");
            this.fireDataEvent(DataEvent.DataType.ERROR, exception, null, null);
            throw exception;
        }
        this.plugin = plugin;
        this.configurationFile = this.getConfigFile();
        this.configuration = YamlConfiguration.loadConfiguration((File)this.configurationFile);
        this.configuration.addDefault("opt-out", (Object)false);
        this.configuration.addDefault("guid", (Object)UUID.randomUUID().toString());
        this.configuration.addDefault("debug", (Object)false);
        if (this.configuration.get("guid", null) == null) {
            this.configuration.options().header("http://mcstats.org").copyDefaults(true);
            this.configuration.save(this.configurationFile);
        }
        this.econfigurationFile = this.getEConfigFile();
        this.econfiguration = YamlConfiguration.loadConfiguration((File)this.econfigurationFile);
        this.econfiguration.addDefault("log-emetrics", (Object)false);
        this.econfiguration.addDefault("timeout-in-seconds", (Object)30);
        if (this.econfiguration.get("log-emetrics", null) == null || this.econfiguration.get("timeout-in-seconds", null) == null) {
            this.econfiguration.options().header("One or more of the plugins on your server use EMetrics.\nTo learn about EMetrics please visit https://github.com/turt2live/MetricsExtension\n\nThe value below is to turn on global logging for all EMetrics plugins.").copyDefaults(true);
            this.econfiguration.save(this.econfigurationFile);
        }
        this.guid = this.configuration.getString("guid");
        this.naturalDebug = this.configuration.getBoolean("debug", false);
        this.naturalLog = this.econfiguration.getBoolean("log-emetrics", false);
        this.timeout = this.econfiguration.getInt("timeout-in-seconds", 30);
        this.log = new EMetricsLogger(plugin, new File(this.getConfigFile().getParentFile(), "logs"));
    }

    public Graph createGraph(String name) {
        if (name == null) {
            IllegalArgumentException exception = new IllegalArgumentException("Graph name cannot be null");
            this.fireDataEvent(DataEvent.DataType.ERROR, exception, null, null);
            throw exception;
        }
        Graph graph = new Graph(name);
        this.graphs.add(graph);
        try {
            if (this.naturalLog || this.pluginLog) {
                this.log.log("Create Graph: " + name);
            }
        }
        catch (IOException e) {
            if (this.naturalDebug || this.pluginDebug) {
                EMetrics.log(e.getMessage(), this.plugin, null);
            }
            this.fireDataEvent(DataEvent.DataType.ERROR, e, name, null);
        }
        return graph;
    }

    public void addGraph(Graph graph) {
        if (graph == null) {
            IllegalArgumentException exception = new IllegalArgumentException("Graph cannot be null");
            this.fireDataEvent(DataEvent.DataType.ERROR, exception, null, null);
            throw exception;
        }
        this.graphs.add(graph);
        try {
            if (this.naturalLog || this.pluginLog) {
                this.log.log("Create Graph: " + graph.getName());
            }
        }
        catch (IOException e) {
            if (this.naturalDebug || this.pluginDebug) {
                EMetrics.log(e.getMessage(), this.plugin, null);
            }
            this.fireDataEvent(DataEvent.DataType.ERROR, e, graph.getName(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Object object = this.optOutLock;
        synchronized (object) {
            if (this.isOptOut()) {
                return false;
            }
            if (this.task != null) {
                return true;
            }
            this.task = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously(this.plugin, new Runnable(){
                private boolean firstPost = true;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = Metrics.this.optOutLock;
                        synchronized (object) {
                            if (Metrics.this.isOptOut() && Metrics.this.task != null) {
                                Metrics.this.task.cancel();
                                Metrics.this.task = null;
                                for (Graph graph : Metrics.this.graphs) {
                                    graph.onOptOut();
                                }
                                try {
                                    if (Metrics.this.naturalLog || Metrics.this.pluginLog) {
                                        Metrics.this.log.log("Server opted out.");
                                    }
                                }
                                catch (IOException e) {
                                    if (Metrics.this.naturalDebug || Metrics.this.pluginDebug) {
                                        EMetrics.log(e.getMessage(), Metrics.this.plugin, null);
                                    }
                                    Metrics.this.fireDataEvent(DataEvent.DataType.ERROR, e, null, null);
                                }
                            }
                        }
                        Metrics.this.postPlugin(!this.firstPost);
                        this.firstPost = false;
                    }
                    catch (IOException e) {
                        if (Metrics.this.naturalDebug || Metrics.this.pluginDebug) {
                            EMetrics.log(e.getMessage(), Metrics.this.plugin, null);
                        }
                        Metrics.this.fireDataEvent(DataEvent.DataType.ERROR, e, null, null);
                    }
                }
            }, 0L, (long)(PING_INTERVAL * 1200));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOptOut() {
        Object object = this.optOutLock;
        synchronized (object) {
            try {
                this.configuration.load(this.getConfigFile());
            }
            catch (IOException ex) {
                if (this.naturalDebug || this.pluginDebug) {
                    EMetrics.log(ex.getMessage(), this.plugin, null);
                }
                this.fireDataEvent(DataEvent.DataType.ERROR, ex, null, null);
                return true;
            }
            catch (InvalidConfigurationException ex) {
                if (this.naturalDebug || this.pluginDebug) {
                    EMetrics.log(ex.getMessage(), this.plugin, null);
                }
                this.fireDataEvent(DataEvent.DataType.ERROR, (Exception)((Object)ex), null, null);
                return true;
            }
            return this.configuration.getBoolean("opt-out", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() throws IOException {
        Object object = this.optOutLock;
        synchronized (object) {
            if (this.isOptOut()) {
                this.configuration.set("opt-out", (Object)false);
                this.configuration.save(this.configurationFile);
            }
            if (this.task == null) {
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() throws IOException {
        Object object = this.optOutLock;
        synchronized (object) {
            if (!this.isOptOut()) {
                this.configuration.set("opt-out", (Object)true);
                this.configuration.save(this.configurationFile);
            }
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }

    public File getConfigFile() {
        File pluginsFolder = this.plugin.getDataFolder().getParentFile();
        return new File(new File(pluginsFolder, "PluginMetrics"), "config.yml");
    }

    public File getEConfigFile() {
        if (this.econfigFile == null) {
            File pluginsFolder = this.plugin.getDataFolder().getParentFile();
            this.econfigFile = new File(new File(pluginsFolder, "PluginMetrics"), "emetrics-config.yml");
        }
        return this.econfigFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postPlugin(boolean isPing) throws IOException {
        if (this.isOptOut()) {
            return;
        }
        Timer.start();
        this.log.prepareForSpam(true);
        PluginDescriptionFile description = this.plugin.getDescription();
        String pluginName = description.getName();
        boolean onlineMode = Bukkit.getServer().getOnlineMode();
        String pluginVersion = description.getVersion();
        String serverVersion = Bukkit.getVersion();
        int playersOnline = Bukkit.getServer().getOnlinePlayers().length;
        StringBuilder json = new StringBuilder(1024);
        json.append('{');
        Metrics.appendJSONPair(json, "guid", this.guid);
        Metrics.appendJSONPair(json, "plugin_version", pluginVersion);
        Metrics.appendJSONPair(json, "server_version", serverVersion);
        Metrics.appendJSONPair(json, "players_online", Integer.toString(playersOnline));
        String osname = System.getProperty("os.name");
        String osarch = System.getProperty("os.arch");
        String osversion = System.getProperty("os.version");
        String java_version = System.getProperty("java.version");
        int coreCount = Runtime.getRuntime().availableProcessors();
        if (osarch.equals("amd64")) {
            osarch = "x86_64";
        }
        Metrics.appendJSONPair(json, "osname", osname);
        Metrics.appendJSONPair(json, "osarch", osarch);
        Metrics.appendJSONPair(json, "osversion", osversion);
        Metrics.appendJSONPair(json, "cores", Integer.toString(coreCount));
        Metrics.appendJSONPair(json, "auth_mode", onlineMode ? "1" : "0");
        Metrics.appendJSONPair(json, "java_version", java_version);
        Metrics.appendJSONPair(json, "used_emetrics", "true");
        if (isPing) {
            Metrics.appendJSONPair(json, "ping", "1");
        }
        if (this.naturalDebug || this.pluginDebug) {
            EMetrics.log("Number of graphs: " + this.graphs.size(), this.plugin, null);
        }
        if (this.graphs.size() > 0) {
            Set<Graph> set = this.graphs;
            synchronized (set) {
                json.append(',');
                json.append('\"');
                json.append("graphs");
                json.append('\"');
                json.append(':');
                json.append('{');
                boolean firstGraph = true;
                for (Graph graph : this.graphs) {
                    if (this.naturalDebug || this.pluginDebug) {
                        EMetrics.log("Number of plotters (" + graph.getName() + "): " + graph.getPlotters().size(), this.plugin, null);
                    }
                    StringBuilder graphJson = new StringBuilder();
                    graphJson.append('{');
                    for (Plotter plotter : graph.getPlotters()) {
                        Metrics.appendJSONPair(graphJson, plotter.getColumnName(), Integer.toString(plotter.getValue()));
                        if (this.naturalDebug || this.pluginDebug) {
                            EMetrics.log("Sending data (graph = " + graph.getName() + "): " + plotter.getColumnName() + " = " + plotter.getValue(), this.plugin, null);
                        }
                        try {
                            if (this.naturalLog || this.pluginLog) {
                                this.log.log("Sending plotter data for graph '" + graph.getName() + "'. Plotter name = " + plotter.getColumnName() + ", value = " + plotter.getValue());
                            }
                        }
                        catch (IOException e) {
                            if (this.naturalDebug || this.pluginDebug) {
                                EMetrics.log(e.getMessage(), this.plugin, null);
                            }
                            this.fireDataEvent(DataEvent.DataType.ERROR, e, null, null);
                        }
                        this.fireDataEvent(DataEvent.DataType.SEND_DATA, plotter.getValue(), graph.getName(), plotter.getColumnName());
                    }
                    graphJson.append('}');
                    if (!firstGraph) {
                        json.append(',');
                    }
                    json.append(Metrics.escapeJSON(graph.getName()));
                    json.append(':');
                    json.append((CharSequence)graphJson);
                    firstGraph = false;
                }
                json.append('}');
            }
        }
        json.append('}');
        URL url = new URL(this.BASE_URL + String.format(REPORT_URL, Metrics.urlEncode(pluginName)));
        URLConnection connection = this.isMineshafterPresent() ? url.openConnection(Proxy.NO_PROXY) : url.openConnection();
        byte[] uncompressed = json.toString().getBytes();
        byte[] compressed = Metrics.gzip(json.toString());
        connection.addRequestProperty("User-Agent", "MCStats/7");
        connection.addRequestProperty("Content-Type", "application/json");
        connection.addRequestProperty("Content-Encoding", "gzip");
        connection.addRequestProperty("Content-Length", Integer.toString(compressed.length));
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Connection", "close");
        connection.setDoOutput(true);
        connection.setConnectTimeout(this.timeout * 1000);
        if (this.naturalDebug || this.pluginDebug) {
            try {
                this.log.log("[Metrics] Prepared request for " + pluginName + " uncompressed=" + uncompressed.length + " compressed=" + compressed.length);
            }
            catch (IOException e) {
                if (this.naturalDebug || this.pluginDebug) {
                    EMetrics.log(e.getMessage(), this.plugin, null);
                }
                this.fireDataEvent(DataEvent.DataType.ERROR, e, null, null);
            }
        }
        OutputStream os = connection.getOutputStream();
        os.write(compressed);
        os.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String response = reader.readLine();
        os.close();
        reader.close();
        if (this.naturalDebug || this.pluginDebug) {
            EMetrics.log("RESPONSE: " + response, this.plugin, null);
        }
        try {
            if (this.naturalLog || this.pluginLog) {
                this.log.log("mcstats.org response = " + response);
            }
        }
        catch (IOException e) {
            if (this.naturalDebug || this.pluginDebug) {
                EMetrics.log(e.getMessage(), this.plugin, null);
            }
            this.fireDataEvent(DataEvent.DataType.ERROR, e, null, null);
        }
        if (response == null || response.startsWith("ERR") || response.startsWith("7")) {
            if (response == null) {
                response = "null";
            } else if (response.startsWith("7")) {
                response = response.substring(response.startsWith("7,") ? 2 : 1);
            }
            IOException exception = new IOException(response);
            this.fireDataEvent(DataEvent.DataType.ERROR, exception, null, null);
            throw exception;
        }
        if (response.equals("1") || response.contains("This is your first update this hour")) {
            Set<Graph> set = this.graphs;
            synchronized (set) {
                for (Graph graph : this.graphs) {
                    for (Plotter plotter : graph.getPlotters()) {
                        plotter.reset();
                        if (this.naturalDebug || this.pluginDebug) {
                            EMetrics.log("Reset plotter '" + plotter.getColumnName() + "' for graph '" + graph.getName() + "'", this.plugin, null);
                        }
                        this.fireDataEvent(DataEvent.DataType.RESET_DATA, graph.getName(), plotter.getColumnName());
                        try {
                            if (!this.naturalLog && !this.pluginLog) continue;
                            this.log.log("Resetting plotter data for graph '" + graph.getName() + "'. Plotter name = " + plotter.getColumnName());
                        }
                        catch (IOException e) {
                            if (this.naturalDebug || this.pluginDebug) {
                                EMetrics.log(e.getMessage(), this.plugin, null);
                            }
                            this.fireDataEvent(DataEvent.DataType.ERROR, e, null, null);
                        }
                    }
                }
            }
        }
        long time = Timer.stop();
        EMetrics.self.addPostTime(time);
        this.log.prepareForSpam(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzip(String input) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = null;
        try {
            gzos = new GZIPOutputStream(baos);
            gzos.write(input.getBytes("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (gzos != null) {
                try {
                    gzos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return baos.toByteArray();
    }

    private boolean isMineshafterPresent() {
        try {
            Class.forName("mineshafter.MineServer");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void flushNoCancel() {
        this.fireDataEvent(DataEvent.DataType.FLUSH_DATA, null, null);
        try {
            this.postPlugin(!this.firstPost);
        }
        catch (IOException e) {
            if (this.naturalDebug || this.pluginDebug) {
                this.plugin.getServer().getLogger().log(Level.INFO, "[" + this.plugin.getName() + "] [EMetrics Debug] " + e.getMessage());
            }
            this.fireDataEvent(DataEvent.DataType.ERROR, e, null, null);
        }
        try {
            if (this.naturalLog || this.pluginLog) {
                this.log.log("Flushing, NOT closing plugin information");
            }
        }
        catch (IOException e) {
            if (this.naturalDebug || this.pluginDebug) {
                EMetrics.log(e.getMessage(), this.plugin, null);
            }
            this.fireDataEvent(DataEvent.DataType.ERROR, e, null, null);
        }
    }

    public void flush() {
        this.fireDataEvent(DataEvent.DataType.FLUSH_DATA, null, null);
        if (this.task != null) {
            this.task.cancel();
        }
        try {
            this.postPlugin(!this.firstPost);
        }
        catch (IOException e) {
            if (this.naturalDebug || this.pluginDebug) {
                this.plugin.getServer().getLogger().log(Level.INFO, "[" + this.plugin.getName() + "] [EMetrics Debug] " + e.getMessage());
            }
            this.fireDataEvent(DataEvent.DataType.ERROR, e, null, null);
        }
        try {
            if (this.naturalLog || this.pluginLog) {
                this.log.log("Flushing, closing plugin information");
            }
        }
        catch (IOException e) {
            if (this.naturalDebug || this.pluginDebug) {
                EMetrics.log(e.getMessage(), this.plugin, null);
            }
            this.fireDataEvent(DataEvent.DataType.ERROR, e, null, null);
        }
    }

    private static void appendJSONPair(StringBuilder json, String key, String value) throws UnsupportedEncodingException {
        boolean isValueNumeric = false;
        try {
            if (value.equals("0") || !value.endsWith("0")) {
                Double.parseDouble(value);
                isValueNumeric = true;
            }
        }
        catch (NumberFormatException e) {
            isValueNumeric = false;
        }
        if (json.charAt(json.length() - 1) != '{') {
            json.append(',');
        }
        json.append(Metrics.escapeJSON(key));
        json.append(':');
        if (isValueNumeric) {
            json.append(value);
        } else {
            json.append(Metrics.escapeJSON(value));
        }
    }

    private static String escapeJSON(String text) {
        StringBuilder builder = new StringBuilder();
        builder.append('\"');
        block7: for (int index = 0; index < text.length(); ++index) {
            char chr = text.charAt(index);
            switch (chr) {
                case '\"': 
                case '\\': {
                    builder.append('\\');
                    builder.append(chr);
                    continue block7;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block7;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block7;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block7;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block7;
                }
                default: {
                    if (chr < ' ') {
                        String t = "000" + Integer.toHexString(chr);
                        builder.append("\\u" + t.substring(t.length() - 4));
                        continue block7;
                    }
                    builder.append(chr);
                }
            }
        }
        builder.append('\"');
        return builder.toString();
    }

    private static String urlEncode(String text) throws UnsupportedEncodingException {
        return URLEncoder.encode(text, "UTF-8");
    }

    private void fireDataEvent(DataEvent.DataType type, String graphName, String trackerName) {
        DataEvent event = new DataEvent(type, graphName, trackerName);
        this.dataTracker.addEvent(event);
    }

    private void fireDataEvent(DataEvent.DataType type, int information, String graphName, String trackerName) {
        DataEvent event = new DataEvent(type, information, graphName, trackerName);
        this.dataTracker.addEvent(event);
    }

    private void fireDataEvent(DataEvent.DataType type, Exception exception, String graphName, String trackerName) {
        block3: {
            DataEvent event = new DataEvent(type, exception, graphName, trackerName);
            this.dataTracker.addEvent(event);
            try {
                if (this.naturalLog || this.pluginLog) {
                    this.log.log(exception);
                }
            }
            catch (IOException e) {
                if (!this.naturalDebug && !this.pluginDebug) break block3;
                EMetrics.log(e.getMessage(), this.plugin, null);
            }
        }
    }

    public static abstract class Plotter {
        private final String name;

        public Plotter() {
            this("Default");
        }

        public Plotter(String name) {
            this.name = name;
        }

        public abstract int getValue();

        public String getColumnName() {
            return this.name;
        }

        public void reset() {
        }

        public int hashCode() {
            return this.getColumnName().hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Plotter)) {
                return false;
            }
            Plotter plotter = (Plotter)object;
            return plotter.name.equals(this.name) && plotter.getValue() == this.getValue();
        }
    }

    public static class Graph {
        private final String name;
        private final Set<Plotter> plotters = new LinkedHashSet<Plotter>();

        protected Graph(String name) {
            this.name = name == null ? "Default" : name;
        }

        public String getName() {
            return this.name;
        }

        public void addPlotter(Plotter plotter) {
            this.plotters.add(plotter);
        }

        public void removePlotter(Plotter plotter) {
            this.plotters.remove(plotter);
        }

        public Set<Plotter> getPlotters() {
            return Collections.unmodifiableSet(this.plotters);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Graph)) {
                return false;
            }
            Graph graph = (Graph)object;
            return graph.name.equals(this.name);
        }

        protected void onOptOut() {
        }
    }
}

