/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.metrics.mcstats.data;

import com.gmail.nossr50.metrics.mcstats.data.DataEvent;
import com.gmail.nossr50.metrics.mcstats.data.DataListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DataTracker {
    private boolean enabled = false;
    private final List<DataEvent> events = new ArrayList<DataEvent>();
    private DataEvent.DataType[] filter = null;
    private DataEvent recent = null;
    private List<DataListener> listeners = new ArrayList<DataListener>();

    public void addListener(DataListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DataListener listener) {
        this.listeners.remove(listener);
    }

    public void enable() {
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void resetEvents() {
        this.events.clear();
    }

    public boolean hasEvents() {
        return this.events.size() > 0;
    }

    public void addEvent(DataEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Event cannot be null");
        }
        if (!this.isFiltered(event.getType()) && this.enabled) {
            this.events.add(event.clone());
            this.recent = event.clone();
            for (DataListener listener : this.listeners) {
                listener.onDataEvent(this.recent);
            }
        }
    }

    public DataEvent getMostRecentEvent() {
        return this.recent;
    }

    public boolean hasMostRecent() {
        return this.recent != null;
    }

    public List<DataEvent> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public boolean isFiltered(DataEvent.DataType type) {
        if (this.filter == null || this.filter.length == 0) {
            return false;
        }
        return Arrays.binarySearch((Object[])this.filter, (Object)type) < 0;
    }

    public void setFilter(DataEvent.DataType[] filter) {
        DataEvent.DataType[] dataTypeArray = this.filter = filter == null ? null : (DataEvent.DataType[])filter.clone();
        if (this.filter != null) {
            Arrays.sort((Object[])filter);
        }
    }

    public DataEvent.DataType[] getFilter() {
        return this.filter == null ? null : (DataEvent.DataType[])this.filter.clone();
    }
}

