/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.metrics.mcstats.logging;

import com.gmail.nossr50.metrics.mcstats.EMetricsPlugin;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bukkit.plugin.Plugin;

public class EMetricsLogger {
    private File file;
    private boolean isSelf = false;
    private BufferedWriter out;
    private String pluginName = "";

    public EMetricsLogger(Plugin plugin, File directory) throws IOException {
        if (plugin == null || directory == null) {
            throw new IllegalArgumentException("Null arguments are not supported");
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.isSelf = plugin instanceof EMetricsPlugin;
        this.file = new File(directory, (this.isSelf ? "EMetrics" : plugin.getName()).replaceAll("[^0-9a-zA-Z]", "_") + ".log");
        this.pluginName = this.isSelf ? ((EMetricsPlugin)plugin).getRealPluginName() : plugin.getName();
    }

    public void prepareForSpam(boolean spam) throws IOException {
        if (!spam && this.out != null) {
            this.out.close();
            this.out = null;
        } else if (spam) {
            this.out = new BufferedWriter(new FileWriter(this.file, true));
        }
    }

    public void log(String information) throws IOException {
        if (information == null) {
            throw new IllegalArgumentException("Null arguments are not supported");
        }
        BufferedWriter writer = this.out != null ? this.out : new BufferedWriter(new FileWriter(this.file, true));
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM dd, yyyy HH:mm:ss Z");
        String date = "[" + dateFormat.format(new Date()) + "]" + (this.isSelf ? " [" + this.pluginName + "]" : "");
        writer.write(date + " " + information);
        writer.newLine();
        if (this.out == null) {
            writer.close();
        }
    }

    public void log(Exception e) throws IOException {
        if (e == null) {
            throw new IllegalArgumentException("Null arguments are not supported");
        }
        PrintWriter printer = new PrintWriter(new FileWriter(this.file, true));
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM dd, yyyy HH:mm:ss Z");
        String date = "[" + dateFormat.format(new Date()) + "]" + (this.isSelf ? " [" + this.pluginName + "]" : "");
        printer.println(date + " Exception Occured: " + e.getMessage());
        e.printStackTrace(printer);
        printer.println();
        printer.flush();
        printer.close();
    }
}

