/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.metrics.mcstats.tracker;

import com.gmail.nossr50.metrics.mcstats.tracker.Tracker;

public class RangeTracker
extends Tracker {
    protected int max = 0;
    protected int min = 0;

    public RangeTracker(String graphName, String valueName) {
        super(graphName, valueName);
    }

    public RangeTracker(String valueName) {
        super(valueName);
    }

    @Override
    public void increment(int value) {
        if (this.max == 0 && this.min == 0) {
            this.max = value;
        } else if (this.max != 0 && this.min == 0) {
            if (value > this.max) {
                this.min = this.max;
                this.max = value;
            } else {
                this.min = value;
            }
        } else if (value > this.max) {
            this.max = value;
        } else if (value < this.min) {
            this.min = value;
        }
    }

    @Override
    public void setValue(int value) {
        this.increment(value);
    }

    @Override
    public int getValue() {
        return this.max - this.min;
    }

    @Override
    public void reset() {
        this.max = 0;
        this.min = 0;
    }
}

