/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.metrics.mcstats.tracker;

import com.gmail.nossr50.metrics.mcstats.Metrics;

public abstract class Tracker
extends Metrics.Plotter {
    public static final String DEFAULT_GRAPH_NAME = null;
    private boolean hasGraph = true;
    protected int value = 0;
    private String valueName = "UNKNOWN";
    private String graphName = "UNKNOWN";

    public Tracker(String graphName, String valueName) {
        if (valueName == null || valueName.trim().isEmpty()) {
            throw new IllegalArgumentException("Bad valueName supplied");
        }
        this.valueName = valueName.trim();
        this.graphName = graphName == null ? null : graphName.trim();
    }

    public Tracker(String valueName) {
        this(null, valueName);
        this.hasGraph = false;
    }

    public final boolean hasGraph() {
        return this.hasGraph;
    }

    public void setValue(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value cannot be negative");
        }
        this.value = value;
    }

    public void increment(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount cannot be negative");
        }
        this.value += amount;
    }

    public void increment() {
        this.increment(1);
    }

    public final String getValueName() {
        return this.valueName;
    }

    public final String getGraphName() {
        return this.graphName;
    }

    @Override
    public final String getColumnName() {
        return this.valueName;
    }

    @Override
    public void reset() {
        this.value = 0;
    }

    @Override
    public int getValue() {
        return this.value;
    }
}

