/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.archery;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.archery.Archery;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ArcheryManager
extends SkillManager {
    public ArcheryManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, SkillType.ARCHERY);
    }

    public boolean canDaze(LivingEntity target) {
        return target instanceof Player && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.DAZE);
    }

    public boolean canSkillShot() {
        return this.getSkillLevel() >= Archery.skillShotIncreaseLevel && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.SKILL_SHOT);
    }

    public boolean canRetrieveArrows() {
        return Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.RETRIEVE);
    }

    public void distanceXpBonus(LivingEntity target, Entity damager) {
        Location firedLocation = (Location)((MetadataValue)damager.getMetadata("mcMMO: Arrow Distance").get(0)).value();
        Location targetLocation = target.getLocation();
        if (firedLocation.getWorld() != targetLocation.getWorld()) {
            return;
        }
        this.applyXpGain((int)(firedLocation.distanceSquared(targetLocation) * 0.025));
    }

    public void retrieveArrows(LivingEntity target) {
        if (SkillUtils.activationSuccessful(SecondaryAbility.RETRIEVE, this.getPlayer(), this.getSkillLevel(), this.activationChance)) {
            Archery.incrementTrackerValue(target);
        }
    }

    public double daze(Player defender, Arrow arrow) {
        if (!SkillUtils.activationSuccessful(SecondaryAbility.DAZE, this.getPlayer(), this.getSkillLevel(), this.activationChance)) {
            return 0.0;
        }
        Location dazedLocation = defender.getLocation();
        dazedLocation.setPitch((float)(90 - Misc.getRandom().nextInt(181)));
        defender.teleport(dazedLocation);
        defender.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, 200, 10));
        if (UserManager.getPlayer(defender).useChatNotifications()) {
            defender.sendMessage(LocaleLoader.getString("Combat.TouchedFuzzy"));
        }
        if (this.mcMMOPlayer.useChatNotifications()) {
            this.getPlayer().sendMessage(LocaleLoader.getString("Combat.TargetDazed"));
        }
        return CombatUtils.callFakeDamageEvent((Entity)arrow, (Entity)defender, EntityDamageEvent.DamageCause.PROJECTILE, Archery.dazeModifier);
    }

    public double skillShot(LivingEntity target, double damage, Arrow arrow) {
        double damageBonusPercent = Math.min((double)(this.getSkillLevel() / Archery.skillShotIncreaseLevel) * Archery.skillShotIncreasePercentage, Archery.skillShotMaxBonusPercentage);
        double archeryBonus = Math.min(damage * damageBonusPercent, Archery.skillShotMaxBonusDamage);
        return CombatUtils.callFakeDamageEvent((Entity)arrow, (Entity)target, EntityDamageEvent.DamageCause.PROJECTILE, archeryBonus);
    }
}

