/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.excavation;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.datatypes.treasure.ExcavationTreasure;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.excavation.Excavation;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.permissions.Permissible;

public class ExcavationManager
extends SkillManager {
    public ExcavationManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, SkillType.EXCAVATION);
    }

    public void excavationBlockCheck(BlockState blockState) {
        List<ExcavationTreasure> treasures;
        int xp = Excavation.getBlockXP(blockState);
        if (Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.EXCAVATION_TREASURE_HUNTER) && !(treasures = Excavation.getTreasures(blockState)).isEmpty()) {
            int skillLevel = this.getSkillLevel();
            Location location = blockState.getLocation();
            for (ExcavationTreasure treasure : treasures) {
                if (skillLevel < treasure.getDropLevel() || !SkillUtils.treasureDropSuccessful(this.getPlayer(), treasure.getDropChance(), this.activationChance)) continue;
                xp += treasure.getXp();
                Misc.dropItem(location, treasure.getDrop());
            }
        }
        this.applyXpGain(xp);
    }

    public void gigaDrillBreaker(BlockState blockState) {
        this.excavationBlockCheck(blockState);
        this.excavationBlockCheck(blockState);
        SkillUtils.handleDurabilityChange(this.getPlayer().getItemInHand(), Config.getInstance().getAbilityToolDamage());
    }
}

