/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.taming;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.events.fake.FakeEntityTameEvent;
import com.gmail.nossr50.events.skills.secondaryabilities.SecondaryAbilityWeightedActivationCheckEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.BleedTimerTask;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.taming.Taming;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;

public class TamingManager
extends SkillManager {
    public TamingManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, SkillType.TAMING);
    }

    public boolean canUseThickFur() {
        return this.getSkillLevel() >= Taming.thickFurUnlockLevel && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.THICK_FUR);
    }

    public boolean canUseEnvironmentallyAware() {
        return this.getSkillLevel() >= Taming.environmentallyAwareUnlockLevel && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.ENVIROMENTALLY_AWARE);
    }

    public boolean canUseShockProof() {
        return this.getSkillLevel() >= Taming.shockProofUnlockLevel && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.SHOCK_PROOF);
    }

    public boolean canUseHolyHound() {
        return this.getSkillLevel() >= Taming.holyHoundUnlockLevel && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.HOLY_HOUND);
    }

    public boolean canUseFastFoodService() {
        return this.getSkillLevel() >= Taming.fastFoodServiceUnlockLevel && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.FAST_FOOD);
    }

    public boolean canUseSharpenedClaws() {
        return this.getSkillLevel() >= Taming.sharpenedClawsUnlockLevel && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.SHARPENED_CLAWS);
    }

    public boolean canUseGore() {
        return Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.GORE);
    }

    public boolean canUseBeastLore() {
        return Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.BEAST_LORE);
    }

    public void awardTamingXP(LivingEntity entity) {
        switch (entity.getType()) {
            case HORSE: {
                this.applyXpGain(Taming.horseXp);
                return;
            }
            case WOLF: {
                this.applyXpGain(Taming.wolfXp);
                return;
            }
            case OCELOT: {
                this.applyXpGain(Taming.ocelotXp);
                return;
            }
        }
    }

    public void fastFoodService(Wolf wolf, double damage) {
        double maxHealth;
        double health;
        double chance = Taming.fastFoodServiceActivationChance / (double)this.activationChance;
        SecondaryAbilityWeightedActivationCheckEvent event = new SecondaryAbilityWeightedActivationCheckEvent(this.getPlayer(), SecondaryAbility.FAST_FOOD, chance);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
        if (event.getChance() * (double)this.activationChance > (double)Misc.getRandom().nextInt(this.activationChance) && (health = wolf.getHealth()) < (maxHealth = wolf.getMaxHealth())) {
            double newHealth = health + damage;
            wolf.setHealth(Math.min(newHealth, maxHealth));
        }
    }

    public double gore(LivingEntity target, double damage, Wolf wolf) {
        if (!SkillUtils.activationSuccessful(SecondaryAbility.GORE, this.getPlayer(), this.getSkillLevel(), this.activationChance)) {
            return 0.0;
        }
        BleedTimerTask.add(target, Taming.goreBleedTicks);
        if (target instanceof Player) {
            ((Player)target).sendMessage(LocaleLoader.getString("Combat.StruckByGore"));
        }
        this.getPlayer().sendMessage(LocaleLoader.getString("Combat.Gore"));
        damage = damage * Taming.goreModifier - damage;
        return CombatUtils.callFakeDamageEvent((Entity)wolf, (Entity)target, damage);
    }

    public double sharpenedClaws(LivingEntity target, Wolf wolf) {
        return CombatUtils.callFakeDamageEvent((Entity)wolf, (Entity)target, Taming.sharpenedClawsBonusDamage);
    }

    public void summonOcelot() {
        if (!Permissions.callOfTheWild((Permissible)this.getPlayer(), EntityType.OCELOT)) {
            return;
        }
        this.callOfTheWild(EntityType.OCELOT, Config.getInstance().getTamingCOTWCost(EntityType.OCELOT));
    }

    public void summonWolf() {
        if (!Permissions.callOfTheWild((Permissible)this.getPlayer(), EntityType.WOLF)) {
            return;
        }
        this.callOfTheWild(EntityType.WOLF, Config.getInstance().getTamingCOTWCost(EntityType.WOLF));
    }

    public void summonHorse() {
        if (!Permissions.callOfTheWild((Permissible)this.getPlayer(), EntityType.HORSE)) {
            return;
        }
        this.callOfTheWild(EntityType.HORSE, Config.getInstance().getTamingCOTWCost(EntityType.HORSE));
    }

    public void beastLore(LivingEntity target) {
        Player player = this.getPlayer();
        Tameable beast = (Tameable)target;
        String message = LocaleLoader.getString("Combat.BeastLore") + " ";
        if (beast.isTamed() && beast.getOwner() != null) {
            message = message.concat(LocaleLoader.getString("Combat.BeastLoreOwner", beast.getOwner().getName()) + " ");
        }
        message = message.concat(LocaleLoader.getString("Combat.BeastLoreHealth", target.getHealth(), target.getMaxHealth()));
        player.sendMessage(message);
    }

    public void processEnvironmentallyAware(Wolf wolf, double damage) {
        if (damage > wolf.getHealth()) {
            return;
        }
        Player owner = this.getPlayer();
        wolf.teleport((Entity)owner);
        owner.sendMessage(LocaleLoader.getString("Taming.Listener.Wolf"));
    }

    private void callOfTheWild(EntityType type, int summonAmount) {
        Player player = this.getPlayer();
        ItemStack heldItem = player.getItemInHand();
        int heldItemAmount = heldItem.getAmount();
        if (heldItemAmount < summonAmount) {
            player.sendMessage(LocaleLoader.getString("Skills.NeedMore", StringUtils.getPrettyItemString(heldItem.getType())));
            return;
        }
        if (!this.rangeCheck(type)) {
            return;
        }
        int amount = Config.getInstance().getTamingCOTWAmount(type);
        for (int i = 0; i < amount; ++i) {
            LivingEntity entity = (LivingEntity)player.getWorld().spawnEntity(player.getLocation(), type);
            FakeEntityTameEvent event = new FakeEntityTameEvent(entity, (AnimalTamer)player);
            mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            entity.setMetadata("mcMMO: Spawned Entity", (MetadataValue)mcMMO.metadataValue);
            ((Tameable)entity).setOwner((AnimalTamer)player);
            entity.setRemoveWhenFarAway(false);
            switch (type) {
                case OCELOT: {
                    ((Ocelot)entity).setCatType(Ocelot.Type.values()[1 + Misc.getRandom().nextInt(3)]);
                    break;
                }
                case WOLF: {
                    entity.setMaxHealth(20.0);
                    entity.setHealth(entity.getMaxHealth());
                    break;
                }
                case HORSE: {
                    Horse horse = (Horse)entity;
                    entity.setMaxHealth(15.0 + Misc.getRandom().nextDouble() * 15.0);
                    entity.setHealth(entity.getMaxHealth());
                    horse.setColor(Horse.Color.values()[Misc.getRandom().nextInt(Horse.Color.values().length)]);
                    horse.setStyle(Horse.Style.values()[Misc.getRandom().nextInt(Horse.Style.values().length)]);
                    horse.setJumpStrength(Math.max(AdvancedConfig.getInstance().getMinHorseJumpStrength(), Math.min(Math.min(Misc.getRandom().nextDouble(), Misc.getRandom().nextDouble()) * 2.0, AdvancedConfig.getInstance().getMaxHorseJumpStrength())));
                    break;
                }
            }
            if (!Permissions.renamePets((Permissible)player)) continue;
            entity.setCustomName(LocaleLoader.getString("Taming.Summon.Name.Format", player.getName(), StringUtils.getPrettyEntityTypeString(type)));
            entity.setCustomNameVisible(true);
        }
        player.setItemInHand(heldItemAmount == summonAmount ? null : new ItemStack(heldItem.getType(), heldItemAmount - summonAmount));
        player.sendMessage(LocaleLoader.getString("Taming.Summon.Complete"));
    }

    private boolean rangeCheck(EntityType type) {
        double range = Config.getInstance().getTamingCOTWRange();
        Player player = this.getPlayer();
        if (range == 0.0) {
            return true;
        }
        for (Entity entity : player.getNearbyEntities(range, range, range)) {
            if (entity.getType() != type) continue;
            player.sendMessage(Taming.getCallOfTheWildFailureMessage(type));
            return false;
        }
        return true;
    }
}

