/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.unarmed;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.unarmed.Unarmed;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.material.SmoothBrick;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;

public class UnarmedManager
extends SkillManager {
    public UnarmedManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, SkillType.UNARMED);
    }

    public boolean canActivateAbility() {
        return this.mcMMOPlayer.getToolPreparationMode(ToolType.FISTS) && Permissions.berserk((Permissible)this.getPlayer());
    }

    public boolean canUseIronArm() {
        return Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.IRON_ARM);
    }

    public boolean canUseBerserk() {
        return this.mcMMOPlayer.getAbilityMode(AbilityType.BERSERK) && Permissions.berserk((Permissible)this.getPlayer());
    }

    public boolean canDisarm(LivingEntity target) {
        return target instanceof Player && ((Player)target).getItemInHand().getType() != Material.AIR && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.DISARM);
    }

    public boolean canDeflect() {
        Player player = this.getPlayer();
        return player.getItemInHand().getType() == Material.AIR && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.DEFLECT);
    }

    public boolean canUseBlockCracker() {
        return Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.BLOCK_CRACKER);
    }

    public boolean blockCrackerCheck(BlockState blockState) {
        MaterialData data = blockState.getData();
        switch (blockState.getType()) {
            case SMOOTH_BRICK: {
                if (!Unarmed.blockCrackerSmoothBrick) {
                    return false;
                }
                SmoothBrick smoothBrick = (SmoothBrick)data;
                if (smoothBrick.getMaterial() != Material.STONE) {
                    return false;
                }
                smoothBrick.setMaterial(Material.COBBLESTONE);
                return true;
            }
        }
        return false;
    }

    public void disarmCheck(Player defender) {
        if (SkillUtils.activationSuccessful(SecondaryAbility.DISARM, this.getPlayer(), this.getSkillLevel(), this.activationChance) && !this.hasIronGrip(defender)) {
            if (EventUtils.callDisarmEvent(defender).isCancelled()) {
                return;
            }
            Item item = Misc.dropItem(defender.getLocation(), defender.getItemInHand());
            if (item != null && AdvancedConfig.getInstance().getDisarmProtected()) {
                item.setMetadata("mcMMO: Disarmed Item", (MetadataValue)UserManager.getPlayer(defender).getPlayerMetadata());
            }
            defender.setItemInHand(new ItemStack(Material.AIR));
            defender.sendMessage(LocaleLoader.getString("Skills.Disarmed"));
        }
    }

    public boolean deflectCheck() {
        if (SkillUtils.activationSuccessful(SecondaryAbility.DEFLECT, this.getPlayer(), this.getSkillLevel(), this.activationChance)) {
            this.getPlayer().sendMessage(LocaleLoader.getString("Combat.ArrowDeflect"));
            return true;
        }
        return false;
    }

    public double berserkDamage(LivingEntity target, double damage) {
        damage = damage * Unarmed.berserkDamageModifier - damage;
        return CombatUtils.callFakeDamageEvent((Entity)this.getPlayer(), (Entity)target, damage);
    }

    public double ironArm(LivingEntity target) {
        double unarmedBonus = Math.min(Unarmed.ironArmMinBonusDamage + (double)(this.getSkillLevel() / Unarmed.ironArmIncreaseLevel), Unarmed.ironArmMaxBonusDamage);
        return CombatUtils.callFakeDamageEvent((Entity)this.getPlayer(), (Entity)target, unarmedBonus);
    }

    private boolean hasIronGrip(Player defender) {
        if (!Misc.isNPCEntity((Entity)defender) && Permissions.secondaryAbilityEnabled((Permissible)defender, SecondaryAbility.IRON_GRIP) && SkillUtils.activationSuccessful(SecondaryAbility.IRON_GRIP, defender, this.skill)) {
            defender.sendMessage(LocaleLoader.getString("Unarmed.Ability.IronGrip.Defender"));
            this.getPlayer().sendMessage(LocaleLoader.getString("Unarmed.Ability.IronGrip.Attacker"));
            return true;
        }
        return false;
    }
}

