/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.repair.Repair;
import com.gmail.nossr50.util.MaterialUtils;
import java.util.HashSet;
import org.bukkit.CropState;
import org.bukkit.Material;
import org.bukkit.NetherWartsState;
import org.bukkit.block.BlockState;
import org.bukkit.material.CocoaPlant;
import org.bukkit.material.Crops;
import org.bukkit.material.NetherWarts;
import org.bukkit.material.SmoothBrick;

public final class BlockUtils {
    private BlockUtils() {
    }

    public static boolean shouldBeWatched(BlockState blockState) {
        return BlockUtils.affectedByGigaDrillBreaker(blockState) || BlockUtils.affectedByGreenTerra(blockState) || BlockUtils.affectedBySuperBreaker(blockState) != false || BlockUtils.isLog(blockState);
    }

    public static boolean canActivateAbilities(BlockState blockState) {
        switch (blockState.getType()) {
            case BED_BLOCK: 
            case BREWING_STAND: 
            case BOOKSHELF: 
            case BURNING_FURNACE: 
            case CAKE_BLOCK: 
            case CHEST: 
            case DISPENSER: 
            case ENCHANTMENT_TABLE: 
            case ENDER_CHEST: 
            case FENCE_GATE: 
            case FURNACE: 
            case IRON_DOOR_BLOCK: 
            case JUKEBOX: 
            case LEVER: 
            case NOTE_BLOCK: 
            case STONE_BUTTON: 
            case WOOD_BUTTON: 
            case TRAP_DOOR: 
            case WALL_SIGN: 
            case WOODEN_DOOR: 
            case WORKBENCH: 
            case BEACON: 
            case ANVIL: 
            case DROPPER: 
            case HOPPER: 
            case TRAPPED_CHEST: {
                return false;
            }
        }
        return !BlockUtils.isMcMMOAnvil(blockState) && !mcMMO.getModManager().isCustomAbilityBlock(blockState);
    }

    public static boolean isOre(BlockState blockState) {
        return MaterialUtils.isOre(blockState.getData());
    }

    public static boolean canMakeMossy(BlockState blockState) {
        switch (blockState.getType()) {
            case COBBLESTONE: 
            case DIRT: {
                return true;
            }
            case SMOOTH_BRICK: {
                return ((SmoothBrick)blockState.getData()).getMaterial() == Material.STONE;
            }
            case COBBLE_WALL: {
                return blockState.getRawData() == 0;
            }
        }
        return false;
    }

    public static boolean affectedByGreenTerra(BlockState blockState) {
        switch (blockState.getType()) {
            case BROWN_MUSHROOM: 
            case CACTUS: 
            case DOUBLE_PLANT: 
            case MELON_BLOCK: 
            case LONG_GRASS: 
            case PUMPKIN: 
            case RED_MUSHROOM: 
            case RED_ROSE: 
            case SUGAR_CANE_BLOCK: 
            case VINE: 
            case WATER_LILY: 
            case YELLOW_FLOWER: {
                return true;
            }
            case CARROT: 
            case POTATO: {
                return blockState.getRawData() == CropState.RIPE.getData();
            }
            case CROPS: {
                return ((Crops)blockState.getData()).getState() == CropState.RIPE;
            }
            case NETHER_WARTS: {
                return ((NetherWarts)blockState.getData()).getState() == NetherWartsState.RIPE;
            }
            case COCOA: {
                return ((CocoaPlant)blockState.getData()).getSize() == CocoaPlant.CocoaPlantSize.LARGE;
            }
        }
        return mcMMO.getModManager().isCustomHerbalismBlock(blockState);
    }

    public static Boolean affectedBySuperBreaker(BlockState blockState) {
        switch (blockState.getType()) {
            case ENDER_STONE: 
            case GLOWSTONE: 
            case HARD_CLAY: 
            case MOSSY_COBBLESTONE: 
            case NETHERRACK: 
            case OBSIDIAN: 
            case PACKED_ICE: 
            case SANDSTONE: 
            case STAINED_CLAY: 
            case STONE: {
                return true;
            }
        }
        return BlockUtils.isOre(blockState) || mcMMO.getModManager().isCustomMiningBlock(blockState);
    }

    public static boolean affectedByGigaDrillBreaker(BlockState blockState) {
        switch (blockState.getType()) {
            case DIRT: 
            case CLAY: 
            case GRASS: 
            case GRAVEL: 
            case MYCEL: 
            case SAND: 
            case SNOW: 
            case SNOW_BLOCK: 
            case SOUL_SAND: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomExcavationBlock(blockState);
    }

    public static boolean isLog(BlockState blockState) {
        switch (blockState.getType()) {
            case LOG: 
            case LOG_2: 
            case HUGE_MUSHROOM_1: 
            case HUGE_MUSHROOM_2: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomLog(blockState);
    }

    public static boolean isLeaves(BlockState blockState) {
        switch (blockState.getType()) {
            case LEAVES: 
            case LEAVES_2: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomLeaf(blockState);
    }

    public static boolean affectedByFluxMining(BlockState blockState) {
        switch (blockState.getType()) {
            case IRON_ORE: 
            case GOLD_ORE: {
                return true;
            }
        }
        return false;
    }

    public static boolean canActivateHerbalism(BlockState blockState) {
        switch (blockState.getType()) {
            case DIRT: 
            case GRASS: 
            case SOIL: {
                return false;
            }
        }
        return true;
    }

    public static boolean affectedByBlockCracker(BlockState blockState) {
        switch (blockState.getType()) {
            case SMOOTH_BRICK: {
                return ((SmoothBrick)blockState.getData()).getMaterial() == Material.STONE;
            }
        }
        return false;
    }

    public static boolean canMakeShroomy(BlockState blockState) {
        switch (blockState.getType()) {
            case DIRT: 
            case GRASS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMcMMOAnvil(BlockState blockState) {
        Material type = blockState.getType();
        return type == Repair.repairAnvilMaterial || type == Repair.salvageAnvilMaterial;
    }

    public static HashSet<Byte> getTransparentBlocks() {
        HashSet<Byte> transparentBlocks = new HashSet<Byte>();
        for (Material material : Material.values()) {
            if (!material.isTransparent()) continue;
            transparentBlocks.add((byte)material.getId());
        }
        return transparentBlocks;
    }
}

