/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.events.items.McMMOItemSpawnEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.player.UserManager;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public final class Misc {
    private static Random random = new Random();
    public static final int TIME_CONVERSION_FACTOR = 1000;
    public static final int TICK_CONVERSION_FACTOR = 20;
    public static final int PLAYER_RESPAWN_COOLDOWN_SECONDS = 5;
    public static final double SKILL_MESSAGE_MAX_SENDING_DISTANCE = 10.0;
    public static final float ANVIL_USE_PITCH = 0.3f;
    public static final float ANVIL_USE_VOLUME = 1.0f;
    public static final float FIZZ_VOLUME = 0.5f;
    public static final float POP_VOLUME = 0.2f;
    public static final float BAT_VOLUME = 1.0f;
    public static final float BAT_PITCH = 0.6f;
    public static final float GHAST_VOLUME = 1.0f;
    public static final float LEVELUP_PITCH = 0.5f;
    public static final float LEVELUP_VOLUME = 0.75f;

    private Misc() {
    }

    public static float getFizzPitch() {
        return 2.6f + (Misc.getRandom().nextFloat() - Misc.getRandom().nextFloat()) * 0.8f;
    }

    public static float getPopPitch() {
        return ((Misc.getRandom().nextFloat() - Misc.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f;
    }

    public static float getGhastPitch() {
        return (Misc.getRandom().nextFloat() - Misc.getRandom().nextFloat()) * 0.2f + 1.0f;
    }

    public static boolean isNPCEntity(Entity entity) {
        return entity == null || entity.hasMetadata("NPC") || entity instanceof NPC || mcMMO.isCombatTagEnabled() && entity instanceof HumanEntity && ((HumanEntity)entity).getName().contains("PvpLogger") || entity.getClass().getName().equalsIgnoreCase("cofh.entity.PlayerFake");
    }

    public static boolean isNear(Location first, Location second, double maxDistance) {
        return first.getWorld() == second.getWorld() && (first.distanceSquared(second) < maxDistance * maxDistance || maxDistance == 0.0);
    }

    public static void dropItems(Location location, Collection<ItemStack> drops) {
        for (ItemStack drop : drops) {
            Misc.dropItem(location, drop);
        }
    }

    public static void dropItems(Location location, ItemStack is, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            Misc.dropItem(location, is);
        }
    }

    public static Item dropItem(Location location, ItemStack itemStack) {
        if (itemStack.getType() == Material.AIR) {
            return null;
        }
        McMMOItemSpawnEvent event = new McMMOItemSpawnEvent(location, itemStack);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        return location.getWorld().dropItemNaturally(location, itemStack);
    }

    public static void profileCleanup(String playerName) {
        Player player = mcMMO.p.getServer().getPlayerExact(playerName);
        if (player != null) {
            UserManager.remove(player);
            UserManager.addUser(player);
        }
    }

    public static void printProgress(int convertedUsers, int progressInterval, long startMillis) {
        if (convertedUsers % progressInterval == 0) {
            mcMMO.p.getLogger().info(String.format("Conversion progress: %d users at %.2f users/second", convertedUsers, (double)convertedUsers / (double)((System.currentTimeMillis() - startMillis) / 1000L)));
        }
    }

    public static Random getRandom() {
        return random;
    }
}

