/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.blockmeta;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.blockmeta.ChunkletManager;
import com.gmail.nossr50.util.blockmeta.ChunkletStore;
import com.gmail.nossr50.util.blockmeta.ChunkletStoreFactory;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.util.HashMap;
import org.bukkit.World;
import org.bukkit.block.Block;

public class HashChunkletManager
implements ChunkletManager {
    public HashMap<String, ChunkletStore> store = new HashMap();

    @Override
    public void loadChunklet(int cx, int cy, int cz, World world) {
        File dataDir = new File(world.getWorldFolder(), "mcmmo_data");
        File cxDir = new File(dataDir, "" + cx);
        if (!cxDir.exists()) {
            return;
        }
        File czDir = new File(cxDir, "" + cz);
        if (!czDir.exists()) {
            return;
        }
        File yFile = new File(czDir, "" + cy);
        if (!yFile.exists()) {
            return;
        }
        ChunkletStore in = this.deserializeChunkletStore(yFile);
        if (in != null) {
            this.store.put(world.getName() + "," + cx + "," + cz + "," + cy, in);
        }
    }

    @Override
    public void unloadChunklet(int cx, int cy, int cz, World world) {
        File dataDir = new File(world.getWorldFolder(), "mcmmo_data");
        if (this.store.containsKey(world.getName() + "," + cx + "," + cz + "," + cy)) {
            File czDir;
            File cxDir = new File(dataDir, "" + cx);
            if (!cxDir.exists()) {
                cxDir.mkdir();
            }
            if (!(czDir = new File(cxDir, "" + cz)).exists()) {
                czDir.mkdir();
            }
            File yFile = new File(czDir, "" + cy);
            ChunkletStore out = this.store.get(world.getName() + "," + cx + "," + cz + "," + cy);
            this.serializeChunkletStore(out, yFile);
            this.store.remove(world.getName() + "," + cx + "," + cz + "," + cy);
        }
    }

    @Override
    public void loadChunk(int cx, int cz, World world) {
        File dataDir = new File(world.getWorldFolder(), "mcmmo_data");
        File cxDir = new File(dataDir, "" + cx);
        if (!cxDir.exists()) {
            return;
        }
        File czDir = new File(cxDir, "" + cz);
        if (!czDir.exists()) {
            return;
        }
        for (int y = 0; y < 4; ++y) {
            ChunkletStore in;
            File yFile = new File(czDir, "" + y);
            if (!yFile.exists() || (in = this.deserializeChunkletStore(yFile)) == null) continue;
            this.store.put(world.getName() + "," + cx + "," + cz + "," + y, in);
        }
    }

    @Override
    public void unloadChunk(int cx, int cz, World world) {
        File dataDir = new File(world.getWorldFolder(), "mcmmo_data");
        for (int y = 0; y < 4; ++y) {
            File czDir;
            if (!this.store.containsKey(world.getName() + "," + cx + "," + cz + "," + y)) continue;
            File cxDir = new File(dataDir, "" + cx);
            if (!cxDir.exists()) {
                cxDir.mkdir();
            }
            if (!(czDir = new File(cxDir, "" + cz)).exists()) {
                czDir.mkdir();
            }
            File yFile = new File(czDir, "" + y);
            ChunkletStore out = this.store.get(world.getName() + "," + cx + "," + cz + "," + y);
            this.serializeChunkletStore(out, yFile);
            this.store.remove(world.getName() + "," + cx + "," + cz + "," + y);
        }
    }

    @Override
    public void chunkLoaded(int cx, int cz, World world) {
    }

    @Override
    public void chunkUnloaded(int cx, int cz, World world) {
        this.unloadChunk(cx, cx, world);
    }

    @Override
    public void saveWorld(World world) {
        String worldName = world.getName();
        File dataDir = new File(world.getWorldFolder(), "mcmmo_data");
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        for (String key : this.store.keySet()) {
            File czDir;
            String[] info = key.split(",");
            if (!worldName.equals(info[0])) continue;
            File cxDir = new File(dataDir, "" + info[1]);
            if (!cxDir.exists()) {
                cxDir.mkdir();
            }
            if (!(czDir = new File(cxDir, "" + info[2])).exists()) {
                czDir.mkdir();
            }
            File yFile = new File(czDir, "" + info[3]);
            this.serializeChunkletStore(this.store.get(key), yFile);
        }
    }

    @Override
    public void unloadWorld(World world) {
        this.saveWorld(world);
        String worldName = world.getName();
        for (String key : this.store.keySet()) {
            String tempWorldName = key.split(",")[0];
            if (!tempWorldName.equals(worldName)) continue;
            this.store.remove(key);
            return;
        }
    }

    @Override
    public void loadWorld(World world) {
    }

    @Override
    public void saveAll() {
        for (World world : mcMMO.p.getServer().getWorlds()) {
            this.saveWorld(world);
        }
    }

    @Override
    public void unloadAll() {
        this.saveAll();
        for (World world : mcMMO.p.getServer().getWorlds()) {
            this.unloadWorld(world);
        }
    }

    @Override
    public boolean isTrue(int x, int y, int z, World world) {
        int cx = x / 16;
        int cz = z / 16;
        int cy = y / 64;
        String key = world.getName() + "," + cx + "," + cz + "," + cy;
        if (!this.store.containsKey(key)) {
            this.loadChunklet(cx, cy, cz, world);
        }
        if (!this.store.containsKey(key)) {
            return false;
        }
        ChunkletStore check = this.store.get(world.getName() + "," + cx + "," + cz + "," + cy);
        int ix = Math.abs(x) % 16;
        int iz = Math.abs(z) % 16;
        int iy = Math.abs(y) % 64;
        return check.isTrue(ix, iy, iz);
    }

    @Override
    public boolean isTrue(Block block) {
        return this.isTrue(block.getX(), block.getY(), block.getZ(), block.getWorld());
    }

    @Override
    public void setTrue(int x, int y, int z, World world) {
        ChunkletStore cStore;
        int cx = x / 16;
        int cz = z / 16;
        int cy = y / 64;
        int ix = Math.abs(x) % 16;
        int iz = Math.abs(z) % 16;
        int iy = Math.abs(y) % 64;
        String key = world.getName() + "," + cx + "," + cz + "," + cy;
        if (!this.store.containsKey(key)) {
            this.loadChunklet(cx, cy, cz, world);
        }
        if ((cStore = this.store.get(key)) == null) {
            cStore = ChunkletStoreFactory.getChunkletStore();
            this.store.put(world.getName() + "," + cx + "," + cz + "," + cy, cStore);
        }
        cStore.setTrue(ix, iy, iz);
    }

    @Override
    public void setTrue(Block block) {
        this.setTrue(block.getX(), block.getY(), block.getZ(), block.getWorld());
    }

    @Override
    public void setFalse(int x, int y, int z, World world) {
        ChunkletStore cStore;
        int cx = x / 16;
        int cz = z / 16;
        int cy = y / 64;
        int ix = Math.abs(x) % 16;
        int iz = Math.abs(z) % 16;
        int iy = Math.abs(y) % 64;
        String key = world.getName() + "," + cx + "," + cz + "," + cy;
        if (!this.store.containsKey(key)) {
            this.loadChunklet(cx, cy, cz, world);
        }
        if ((cStore = this.store.get(key)) == null) {
            return;
        }
        cStore.setFalse(ix, iy, iz);
    }

    @Override
    public void setFalse(Block block) {
        this.setFalse(block.getX(), block.getY(), block.getZ(), block.getWorld());
    }

    @Override
    public void cleanUp() {
        for (String key : this.store.keySet()) {
            File czDir;
            if (!this.store.get(key).isEmpty()) continue;
            String[] info = key.split(",");
            File dataDir = new File(mcMMO.p.getServer().getWorld(info[0]).getWorldFolder(), "mcmmo_data");
            File cxDir = new File(dataDir, "" + info[1]);
            if (!cxDir.exists() || !(czDir = new File(cxDir, "" + info[2])).exists()) continue;
            File yFile = new File(czDir, "" + info[3]);
            yFile.delete();
            if (czDir.list().length == 0) {
                czDir.delete();
            }
            if (cxDir.list().length != 0) continue;
            cxDir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeChunkletStore(ChunkletStore cStore, File location) {
        FileOutputStream fileOut = null;
        ObjectOutputStream objOut = null;
        try {
            if (!location.exists()) {
                location.createNewFile();
            }
            fileOut = new FileOutputStream(location);
            objOut = new ObjectOutputStream(fileOut);
            objOut.writeObject(cStore);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (objOut != null) {
                try {
                    objOut.flush();
                    objOut.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkletStore deserializeChunkletStore(File location) {
        ChunkletStore storeIn = null;
        FileInputStream fileIn = null;
        ObjectInputStream objIn = null;
        try {
            fileIn = new FileInputStream(location);
            objIn = new ObjectInputStream(fileIn);
            storeIn = (ChunkletStore)objIn.readObject();
        }
        catch (IOException ex) {
            if (ex instanceof EOFException) {
                ChunkletStore chunkletStore = ChunkletStoreFactory.getChunkletStore();
                return chunkletStore;
            }
            if (ex instanceof StreamCorruptedException) {
                ChunkletStore chunkletStore = ChunkletStoreFactory.getChunkletStore();
                return chunkletStore;
            }
            if (ex instanceof UTFDataFormatException) {
                ChunkletStore chunkletStore = ChunkletStoreFactory.getChunkletStore();
                return chunkletStore;
            }
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        finally {
            if (objIn != null) {
                try {
                    objIn.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return storeIn;
    }
}

